/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.util.ValueComparator;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.PropertyShape;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlQueryParserCache;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.paths.SimplePath;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeHelper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SingletonBindingSet;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;

abstract class AbstractPairwisePlanNode
implements PlanNode {
    private final SailConnection connection;
    private final Resource[] dataGraph;
    private final IRI predicate;
    private final StatementMatcher.Variable<Resource> subject;
    private final String query;
    private final Dataset dataset;
    private final StatementMatcher.Variable<Value> object;
    private final PlanNode parent;
    private final Shape shape;
    private final ConstraintComponent constraintComponent;
    private ValidationExecutionLogger validationExecutionLogger;
    private boolean produceValidationReports;
    Set<Value> valuesByPath;
    Set<Value> valuesByPredicate;

    public AbstractPairwisePlanNode(SailConnection connection, Resource[] dataGraph, PlanNode parent, IRI predicate, StatementMatcher.Variable<Resource> subject, StatementMatcher.Variable<Value> object, SparqlFragment targetQueryFragment, Shape shape, ConstraintComponent constraintComponent, boolean produceValidationReports) {
        this.parent = parent;
        this.connection = connection;
        assert (this.connection != null);
        this.dataGraph = dataGraph;
        this.predicate = predicate;
        this.subject = subject;
        this.object = object;
        this.query = targetQueryFragment != null ? "select * where {\n" + targetQueryFragment.getFragment() + "\n}" : null;
        this.dataset = PlanNodeHelper.asDefaultGraphDataset(dataGraph);
        this.shape = shape;
        this.constraintComponent = constraintComponent;
        this.produceValidationReports = produceValidationReports;
    }

    private Set<Value> getMismatchedValues(ValidationTuple t) {
        Resource target = (Resource)t.getActiveTarget();
        if (this.query == null) {
            this.valuesByPath = Set.of(target);
        } else {
            TupleExpr tupleExpr = SparqlQueryParserCache.get(this.query);
            try (Stream<? extends BindingSet> stream = this.connection.evaluate(tupleExpr, this.dataset, new SingletonBindingSet(this.subject.getName(), target), true).stream();){
                this.valuesByPath = stream.map(bindingSet -> bindingSet.getValue(this.object.getName())).collect(Collectors.toSet());
            }
        }
        try (Stream<? extends Statement> stream = this.connection.getStatements(target, this.predicate, null, false, this.dataGraph).stream();){
            this.valuesByPredicate = stream.map(Statement::getObject).collect(Collectors.toSet());
        }
        return this.getInvalidValues(this.valuesByPath, this.valuesByPredicate);
    }

    abstract Set<Value> getInvalidValues(Set<Value> var1, Set<Value> var2);

    @Override
    public CloseableIteration<? extends ValidationTuple> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            private CloseableIteration<? extends ValidationTuple> parentIterator;
            private Iterator<ValidationTuple> nextIterator;
            private final ValueComparator valueComparator;
            {
                this.nextIterator = null;
                this.valueComparator = new ValueComparator();
            }

            @Override
            protected void init() {
                this.parentIterator = AbstractPairwisePlanNode.this.parent.iterator();
            }

            private void populateNextIterator() {
                if (this.nextIterator != null && this.nextIterator.hasNext()) {
                    return;
                }
                while (this.parentIterator.hasNext() && (this.nextIterator == null || !this.nextIterator.hasNext())) {
                    ValidationTuple next = (ValidationTuple)this.parentIterator.next();
                    Set<Value> mismatchedValues = AbstractPairwisePlanNode.this.getMismatchedValues(next);
                    if (mismatchedValues.isEmpty()) continue;
                    this.nextIterator = Arrays.stream(mismatchedValues.toArray(new Value[0])).sorted(this.valueComparator).map(value -> {
                        if (next.getScope() == ConstraintComponent.Scope.propertyShape) {
                            ValidationTuple validationTuple = next.setValue((Value)value);
                            Path path = !AbstractPairwisePlanNode.this.valuesByPath.contains(value) ? new SimplePath(AbstractPairwisePlanNode.this.predicate) : ((PropertyShape)AbstractPairwisePlanNode.this.shape).getPath();
                            if (AbstractPairwisePlanNode.this.produceValidationReports) {
                                return validationTuple.addValidationResult(t -> new ValidationResult(t.getActiveTarget(), t.getValue(), AbstractPairwisePlanNode.this.shape, AbstractPairwisePlanNode.this.constraintComponent, AbstractPairwisePlanNode.this.shape.getSeverity(), t.getScope(), t.getContexts(), AbstractPairwisePlanNode.this.shape.getContexts(), path));
                            }
                            return validationTuple;
                        }
                        ValidationTuple validationTuple = next.shiftToPropertyShapeScope((Value)value);
                        SimplePath path = !AbstractPairwisePlanNode.this.valuesByPath.contains(value) ? new SimplePath(AbstractPairwisePlanNode.this.predicate) : null;
                        if (AbstractPairwisePlanNode.this.produceValidationReports) {
                            return validationTuple.addValidationResult(t -> new ValidationResult(t.getActiveTarget(), t.getValue(), AbstractPairwisePlanNode.this.shape, AbstractPairwisePlanNode.this.constraintComponent, AbstractPairwisePlanNode.this.shape.getSeverity(), t.getScope(), t.getContexts(), AbstractPairwisePlanNode.this.shape.getContexts(), path));
                        }
                        return validationTuple;
                    }).iterator();
                    return;
                }
            }

            @Override
            protected ValidationTuple loggingNext() {
                this.populateNextIterator();
                return this.nextIterator.next();
            }

            @Override
            protected boolean localHasNext() {
                this.populateNextIterator();
                return this.nextIterator != null && this.nextIterator.hasNext();
            }

            @Override
            protected void localClose() {
                this.parentIterator.close();
            }
        };
    }

    @Override
    public int depth() {
        return this.parent.depth() + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "CheckEqualsValuesBasedOnPathAndPredicate";
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
        this.parent.receiveLogger(validationExecutionLogger);
    }

    @Override
    public boolean producesSorted() {
        return this.parent.producesSorted();
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }
}

