/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public class IndependentJoingroupBindingsIteration3
extends LookAheadIteration<BindingSet> {
    protected static final Pattern pattern = Pattern.compile("(.*)_(.*)_(.*)");
    protected final List<BindingSet> bindings;
    protected final CloseableIteration<BindingSet> iter;
    protected ArrayList<BindingSet> result = null;
    protected int currentIdx = 0;

    public IndependentJoingroupBindingsIteration3(CloseableIteration<BindingSet> iter, List<BindingSet> bindings) {
        this.bindings = bindings;
        this.iter = iter;
    }

    @Override
    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.result == null) {
            this.result = this.computeResult();
        }
        if (this.currentIdx >= this.result.size()) {
            return null;
        }
        return this.result.get(this.currentIdx++);
    }

    protected ArrayList<BindingSet> computeResult() throws QueryEvaluationException {
        ArrayList a_res = new ArrayList(this.bindings.size());
        ArrayList b_res = new ArrayList(this.bindings.size());
        for (int i = 0; i < this.bindings.size(); ++i) {
            a_res.add(new LinkedList());
            b_res.add(new LinkedList());
        }
        while (this.iter.hasNext()) {
            BindingSet bIn = (BindingSet)this.iter.next();
            if (bIn.size() != 1) {
                throw new RuntimeException("For this optimization a bindingset needs to have exactly one binding, it has " + bIn.size() + ": " + bIn);
            }
            Binding b = bIn.getBinding(bIn.getBindingNames().iterator().next());
            Matcher m = pattern.matcher(b.getName());
            if (!m.find()) {
                throw new QueryEvaluationException("Unexpected pattern for binding name: " + b.getName());
            }
            BindingInfo bInfo = new BindingInfo(m.group(1), Integer.parseInt(m.group(3)), b.getValue());
            int bIndex = Integer.parseInt(m.group(2));
            if (bIndex == 0) {
                ((LinkedList)a_res.get(bInfo.bindingsIdx)).add(bInfo);
                continue;
            }
            if (bIndex == 1) {
                ((LinkedList)b_res.get(bInfo.bindingsIdx)).add(bInfo);
                continue;
            }
            throw new RuntimeException("Unexpected binding value.");
        }
        ArrayList<BindingSet> res = new ArrayList<BindingSet>(2 * this.bindings.size());
        for (int a_idx = 0; a_idx < a_res.size(); ++a_idx) {
            LinkedList a_list = (LinkedList)a_res.get(a_idx);
            for (BindingInfo a : a_list) {
                for (BindingInfo b : (LinkedList)b_res.get(a_idx)) {
                    QueryBindingSet newB = new QueryBindingSet(this.bindings.size() + 2);
                    newB.addBinding(a.name, a.value);
                    newB.addBinding(b.name, b.value);
                    newB.addAll(this.bindings.get(a.bindingsIdx));
                    res.add(newB);
                }
            }
        }
        return res;
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            this.iter.close();
        }
    }

    protected class BindingInfo {
        public final String name;
        public final int bindingsIdx;
        public final Value value;

        public BindingInfo(String name, int bindingsIdx, Value value) {
            this.name = name;
            this.bindingsIdx = bindingsIdx;
            this.value = value;
        }

        public String toString() {
            return this.name + ":" + this.value.stringValue();
        }
    }
}

