/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.datatypes;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URISyntaxException;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.namespace.QName;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.text.ASCIIUtil;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.datatypes.XMLDateTime;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class XMLDatatypeUtil {
    private static final IllegalArgumentExceptionWithoutStackTrace VALUE_SMALLER_THAN_MINIMUM_VALUE_EXCEPTION = new IllegalArgumentExceptionWithoutStackTrace("Value smaller than minimum value");
    private static final IllegalArgumentExceptionWithoutStackTrace VALUE_LARGER_THAN_MAXIMUM_VALUE_EXCEPTION = new IllegalArgumentExceptionWithoutStackTrace("Value larger than maximum value");
    private static final IllegalArgumentExceptionWithoutStackTrace NAN_COMPARE_EXCEPTION = new IllegalArgumentExceptionWithoutStackTrace("NaN cannot be compared to other floats");
    public static final String POSITIVE_INFINITY = "INF";
    public static final String NEGATIVE_INFINITY = "-INF";
    public static final String NaN = "NaN";
    private static final DatatypeFactory dtFactory;
    private static final Pattern P_DURATION;
    private static final Pattern P_DAYTIMEDURATION;
    private static final Pattern P_YEARMONTHDURATION;
    private static final Pattern P_TIMEZONE;
    private static final Pattern P_DATE;
    private static final Pattern P_TIME;
    private static final Pattern P_GDAY;
    private static final Pattern P_GMONTH;
    private static final Pattern P_GMONTHDAY;
    private static final Pattern P_GYEAR;
    private static final Pattern P_GYEARMONTH;
    private static final Set<IRI> primitiveDatatypes;
    private static final Set<IRI> derivedDatatypes;
    private static final Set<IRI> integerDatatypes;
    private static final Set<IRI> calendarDatatypes;
    private static final Set<IRI> durationDatatypes;

    public static boolean isPrimitiveDatatype(IRI datatype) {
        return primitiveDatatypes.contains(datatype);
    }

    public static boolean isDerivedDatatype(IRI datatype) {
        return derivedDatatypes.contains(datatype);
    }

    public static boolean isBuiltInDatatype(IRI datatype) {
        return XMLDatatypeUtil.isPrimitiveDatatype(datatype) || XMLDatatypeUtil.isDerivedDatatype(datatype);
    }

    public static boolean isNumericDatatype(IRI datatype) {
        return XMLDatatypeUtil.isDecimalDatatype(datatype) || XMLDatatypeUtil.isFloatingPointDatatype(datatype);
    }

    public static boolean isDecimalDatatype(IRI datatype) {
        return datatype.equals(XSD.DECIMAL) || XMLDatatypeUtil.isIntegerDatatype(datatype);
    }

    public static boolean isIntegerDatatype(IRI datatype) {
        return integerDatatypes.contains(datatype);
    }

    public static boolean isFloatingPointDatatype(IRI datatype) {
        return datatype.equals(XSD.FLOAT) || datatype.equals(XSD.DOUBLE);
    }

    public static boolean isCalendarDatatype(IRI datatype) {
        return calendarDatatypes.contains(datatype);
    }

    public static boolean isDurationDatatype(IRI datatype) {
        return durationDatatypes.contains(datatype);
    }

    public static boolean isOrderedDatatype(IRI datatype) {
        return XMLDatatypeUtil.isNumericDatatype(datatype) || XMLDatatypeUtil.isCalendarDatatype(datatype);
    }

    public static boolean isValidValue(String value, IRI datatype) {
        if (datatype.equals(XSD.DECIMAL)) {
            return XMLDatatypeUtil.isValidDecimal(value);
        }
        if (datatype.equals(XSD.INTEGER)) {
            return XMLDatatypeUtil.isValidInteger(value);
        }
        if (datatype.equals(XSD.NEGATIVE_INTEGER)) {
            return XMLDatatypeUtil.isValidNegativeInteger(value);
        }
        if (datatype.equals(XSD.NON_POSITIVE_INTEGER)) {
            return XMLDatatypeUtil.isValidNonPositiveInteger(value);
        }
        if (datatype.equals(XSD.NON_NEGATIVE_INTEGER)) {
            return XMLDatatypeUtil.isValidNonNegativeInteger(value);
        }
        if (datatype.equals(XSD.POSITIVE_INTEGER)) {
            return XMLDatatypeUtil.isValidPositiveInteger(value);
        }
        if (datatype.equals(XSD.LONG)) {
            return XMLDatatypeUtil.isValidLong(value);
        }
        if (datatype.equals(XSD.INT)) {
            return XMLDatatypeUtil.isValidInt(value);
        }
        if (datatype.equals(XSD.SHORT)) {
            return XMLDatatypeUtil.isValidShort(value);
        }
        if (datatype.equals(XSD.BYTE)) {
            return XMLDatatypeUtil.isValidByte(value);
        }
        if (datatype.equals(XSD.UNSIGNED_LONG)) {
            return XMLDatatypeUtil.isValidUnsignedLong(value);
        }
        if (datatype.equals(XSD.UNSIGNED_INT)) {
            return XMLDatatypeUtil.isValidUnsignedInt(value);
        }
        if (datatype.equals(XSD.UNSIGNED_SHORT)) {
            return XMLDatatypeUtil.isValidUnsignedShort(value);
        }
        if (datatype.equals(XSD.UNSIGNED_BYTE)) {
            return XMLDatatypeUtil.isValidUnsignedByte(value);
        }
        if (datatype.equals(XSD.FLOAT)) {
            return XMLDatatypeUtil.isValidFloat(value);
        }
        if (datatype.equals(XSD.DOUBLE)) {
            return XMLDatatypeUtil.isValidDouble(value);
        }
        if (datatype.equals(XSD.BOOLEAN)) {
            return XMLDatatypeUtil.isValidBoolean(value);
        }
        if (datatype.equals(XSD.DATETIME)) {
            return XMLDatatypeUtil.isValidDateTime(value);
        }
        if (datatype.equals(XSD.DATETIMESTAMP)) {
            return XMLDatatypeUtil.isValidDateTimeStamp(value);
        }
        if (datatype.equals(XSD.DATE)) {
            return XMLDatatypeUtil.isValidDate(value);
        }
        if (datatype.equals(XSD.TIME)) {
            return XMLDatatypeUtil.isValidTime(value);
        }
        if (datatype.equals(XSD.GDAY)) {
            return XMLDatatypeUtil.isValidGDay(value);
        }
        if (datatype.equals(XSD.GMONTH)) {
            return XMLDatatypeUtil.isValidGMonth(value);
        }
        if (datatype.equals(XSD.GMONTHDAY)) {
            return XMLDatatypeUtil.isValidGMonthDay(value);
        }
        if (datatype.equals(XSD.GYEAR)) {
            return XMLDatatypeUtil.isValidGYear(value);
        }
        if (datatype.equals(XSD.GYEARMONTH)) {
            return XMLDatatypeUtil.isValidGYearMonth(value);
        }
        if (datatype.equals(XSD.DURATION)) {
            return XMLDatatypeUtil.isValidDuration(value);
        }
        if (datatype.equals(XSD.DAYTIMEDURATION)) {
            return XMLDatatypeUtil.isValidDayTimeDuration(value);
        }
        if (datatype.equals(XSD.YEARMONTHDURATION)) {
            return XMLDatatypeUtil.isValidYearMonthDuration(value);
        }
        if (datatype.equals(XSD.QNAME)) {
            return XMLDatatypeUtil.isValidQName(value);
        }
        if (datatype.equals(XSD.ANYURI)) {
            return XMLDatatypeUtil.isValidAnyURI(value);
        }
        if (datatype.equals(XSD.LANGUAGE)) {
            return Literals.isValidLanguageTag(value);
        }
        return true;
    }

    public static boolean isValidValue(String value, CoreDatatype datatype) {
        if (datatype.isXSDDatatype()) {
            return XMLDatatypeUtil.isValidValue(value, (CoreDatatype.XSD)datatype);
        }
        return true;
    }

    public static boolean isValidValue(String value, CoreDatatype.XSD datatype) {
        switch (datatype) {
            case DECIMAL: {
                return XMLDatatypeUtil.isValidDecimal(value);
            }
            case INTEGER: {
                return XMLDatatypeUtil.isValidInteger(value);
            }
            case NEGATIVE_INTEGER: {
                return XMLDatatypeUtil.isValidNegativeInteger(value);
            }
            case NON_POSITIVE_INTEGER: {
                return XMLDatatypeUtil.isValidNonPositiveInteger(value);
            }
            case NON_NEGATIVE_INTEGER: {
                return XMLDatatypeUtil.isValidNonNegativeInteger(value);
            }
            case POSITIVE_INTEGER: {
                return XMLDatatypeUtil.isValidPositiveInteger(value);
            }
            case LONG: {
                return XMLDatatypeUtil.isValidLong(value);
            }
            case INT: {
                return XMLDatatypeUtil.isValidInt(value);
            }
            case SHORT: {
                return XMLDatatypeUtil.isValidShort(value);
            }
            case BYTE: {
                return XMLDatatypeUtil.isValidByte(value);
            }
            case UNSIGNED_LONG: {
                return XMLDatatypeUtil.isValidUnsignedLong(value);
            }
            case UNSIGNED_INT: {
                return XMLDatatypeUtil.isValidUnsignedInt(value);
            }
            case UNSIGNED_SHORT: {
                return XMLDatatypeUtil.isValidUnsignedShort(value);
            }
            case UNSIGNED_BYTE: {
                return XMLDatatypeUtil.isValidUnsignedByte(value);
            }
            case FLOAT: {
                return XMLDatatypeUtil.isValidFloat(value);
            }
            case DOUBLE: {
                return XMLDatatypeUtil.isValidDouble(value);
            }
            case BOOLEAN: {
                return XMLDatatypeUtil.isValidBoolean(value);
            }
            case DATETIME: {
                return XMLDatatypeUtil.isValidDateTime(value);
            }
            case DATETIMESTAMP: {
                return XMLDatatypeUtil.isValidDateTimeStamp(value);
            }
            case DATE: {
                return XMLDatatypeUtil.isValidDate(value);
            }
            case TIME: {
                return XMLDatatypeUtil.isValidTime(value);
            }
            case GDAY: {
                return XMLDatatypeUtil.isValidGDay(value);
            }
            case GMONTH: {
                return XMLDatatypeUtil.isValidGMonth(value);
            }
            case GMONTHDAY: {
                return XMLDatatypeUtil.isValidGMonthDay(value);
            }
            case GYEAR: {
                return XMLDatatypeUtil.isValidGYear(value);
            }
            case GYEARMONTH: {
                return XMLDatatypeUtil.isValidGYearMonth(value);
            }
            case DURATION: {
                return XMLDatatypeUtil.isValidDuration(value);
            }
            case DAYTIMEDURATION: {
                return XMLDatatypeUtil.isValidDayTimeDuration(value);
            }
            case YEARMONTHDURATION: {
                return XMLDatatypeUtil.isValidYearMonthDuration(value);
            }
            case QNAME: {
                return XMLDatatypeUtil.isValidQName(value);
            }
            case ANYURI: {
                return XMLDatatypeUtil.isValidAnyURI(value);
            }
            case LANGUAGE: {
                return Literals.isValidLanguageTag(value);
            }
        }
        return true;
    }

    public static boolean isValidDecimal(String value) {
        try {
            XMLDatatypeUtil.normalizeDecimal(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidInteger(String value) {
        try {
            XMLDatatypeUtil.normalizeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNegativeInteger(String value) {
        try {
            XMLDatatypeUtil.normalizeNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNonPositiveInteger(String value) {
        try {
            XMLDatatypeUtil.normalizeNonPositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidNonNegativeInteger(String value) {
        try {
            XMLDatatypeUtil.normalizeNonNegativeInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidPositiveInteger(String value) {
        try {
            XMLDatatypeUtil.normalizePositiveInteger(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidLong(String value) {
        try {
            XMLDatatypeUtil.normalizeLong(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidInt(String value) {
        try {
            XMLDatatypeUtil.normalizeInt(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidShort(String value) {
        try {
            XMLDatatypeUtil.normalizeShort(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidByte(String value) {
        try {
            XMLDatatypeUtil.normalizeByte(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedLong(String value) {
        try {
            XMLDatatypeUtil.normalizeUnsignedLong(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedInt(String value) {
        try {
            XMLDatatypeUtil.normalizeUnsignedInt(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedShort(String value) {
        try {
            XMLDatatypeUtil.normalizeUnsignedShort(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidUnsignedByte(String value) {
        try {
            XMLDatatypeUtil.normalizeUnsignedByte(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidFloat(String value) {
        try {
            XMLDatatypeUtil.normalizeFloat(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDouble(String value) {
        try {
            XMLDatatypeUtil.normalizeDouble(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidBoolean(String value) {
        try {
            XMLDatatypeUtil.normalizeBoolean(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDuration(String value) {
        return value.length() > 1 && P_DURATION.matcher(value).matches();
    }

    public static boolean isValidDayTimeDuration(String value) {
        return value.length() > 1 && P_DAYTIMEDURATION.matcher(value).matches();
    }

    public static boolean isValidYearMonthDuration(String value) {
        return value.length() > 1 && P_YEARMONTHDURATION.matcher(value).matches();
    }

    public static boolean isValidDateTime(String value) {
        try {
            XMLDateTime dt = new XMLDateTime(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDateTimeStamp(String value) {
        try {
            XMLDateTime dt = new XMLDateTime(value);
            return P_TIMEZONE.matcher(value).matches();
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static boolean isValidDate(String value) {
        return P_DATE.matcher(value).matches() && XMLDatatypeUtil.isValidCalendarValue(value);
    }

    public static boolean isValidTime(String value) {
        return P_TIME.matcher(value).matches() && XMLDatatypeUtil.isValidCalendarValue(value);
    }

    public static boolean isValidGDay(String value) {
        return P_GDAY.matcher(value).matches() && XMLDatatypeUtil.isValidCalendarValue(value);
    }

    public static boolean isValidGMonth(String value) {
        return P_GMONTH.matcher(value).matches() && XMLDatatypeUtil.isValidCalendarValue(value);
    }

    public static boolean isValidGMonthDay(String value) {
        return P_GMONTHDAY.matcher(value).matches() && XMLDatatypeUtil.isValidCalendarValue(value);
    }

    public static boolean isValidGYear(String value) {
        return P_GYEAR.matcher(value).matches() && XMLDatatypeUtil.isValidCalendarValue(value);
    }

    public static boolean isValidGYearMonth(String value) {
        return P_GYEARMONTH.matcher(value).matches() && XMLDatatypeUtil.isValidCalendarValue(value);
    }

    public static boolean isValidQName(String value) {
        String name;
        String[] split = value.split(":", -2);
        if (split.length != 2) {
            return false;
        }
        String prefix = split[0];
        if (!"".equals(prefix)) {
            if (XMLDatatypeUtil.isNotPrefixStartChar(prefix.charAt(0))) {
                return false;
            }
            for (int i = 1; i < prefix.length(); ++i) {
                if (!XMLDatatypeUtil.isNotNameChar(prefix.charAt(i))) continue;
                return false;
            }
        }
        if (!"".equals(name = split[1])) {
            if (XMLDatatypeUtil.isNotNameStartChar(name.charAt(0))) {
                return false;
            }
            for (int i = 1; i < name.length(); ++i) {
                if (!XMLDatatypeUtil.isNotNameChar(name.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean isValidAnyURI(String value) {
        try {
            new ParsedIRI(value.trim());
            return true;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private static boolean isNotPrefixStartChar(int c) {
        return !(ASCIIUtil.isLetter(c) || c >= 192 && c <= 214 || c >= 216 && c <= 246 || c >= 248 && c <= 767 || c >= 880 && c <= 893 || c >= 895 && c <= 8191 || c >= 8204 && c <= 8205 || c >= 8304 && c <= 8591 || c >= 11264 && c <= 12271 || c >= 12289 && c <= 55295 || c >= 63744 && c <= 64975 || c >= 65008 && c <= 65533 || c >= 65536 && c <= 983039);
    }

    private static boolean isNotNameStartChar(int c) {
        return c != 95 && XMLDatatypeUtil.isNotPrefixStartChar(c);
    }

    private static boolean isNotNameChar(int c) {
        return !(!XMLDatatypeUtil.isNotNameStartChar(c) || ASCIIUtil.isNumber(c) || c == 45 || c == 183 || c >= 768 && c <= 879 || c >= 8255 && c <= 8256);
    }

    private static boolean isValidCalendarValue(String value) {
        try {
            XMLDatatypeUtil.parseCalendar(value);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static String normalize(String value, IRI datatype) {
        if (datatype.equals(XSD.DECIMAL)) {
            return XMLDatatypeUtil.normalizeDecimal(value);
        }
        if (datatype.equals(XSD.INTEGER)) {
            return XMLDatatypeUtil.normalizeInteger(value);
        }
        if (datatype.equals(XSD.NEGATIVE_INTEGER)) {
            return XMLDatatypeUtil.normalizeNegativeInteger(value);
        }
        if (datatype.equals(XSD.NON_POSITIVE_INTEGER)) {
            return XMLDatatypeUtil.normalizeNonPositiveInteger(value);
        }
        if (datatype.equals(XSD.NON_NEGATIVE_INTEGER)) {
            return XMLDatatypeUtil.normalizeNonNegativeInteger(value);
        }
        if (datatype.equals(XSD.POSITIVE_INTEGER)) {
            return XMLDatatypeUtil.normalizePositiveInteger(value);
        }
        if (datatype.equals(XSD.LONG)) {
            return XMLDatatypeUtil.normalizeLong(value);
        }
        if (datatype.equals(XSD.INT)) {
            return XMLDatatypeUtil.normalizeInt(value);
        }
        if (datatype.equals(XSD.SHORT)) {
            return XMLDatatypeUtil.normalizeShort(value);
        }
        if (datatype.equals(XSD.BYTE)) {
            return XMLDatatypeUtil.normalizeByte(value);
        }
        if (datatype.equals(XSD.UNSIGNED_LONG)) {
            return XMLDatatypeUtil.normalizeUnsignedLong(value);
        }
        if (datatype.equals(XSD.UNSIGNED_INT)) {
            return XMLDatatypeUtil.normalizeUnsignedInt(value);
        }
        if (datatype.equals(XSD.UNSIGNED_SHORT)) {
            return XMLDatatypeUtil.normalizeUnsignedShort(value);
        }
        if (datatype.equals(XSD.UNSIGNED_BYTE)) {
            return XMLDatatypeUtil.normalizeUnsignedByte(value);
        }
        if (datatype.equals(XSD.FLOAT)) {
            return XMLDatatypeUtil.normalizeFloat(value);
        }
        if (datatype.equals(XSD.DOUBLE)) {
            return XMLDatatypeUtil.normalizeDouble(value);
        }
        if (datatype.equals(XSD.BOOLEAN)) {
            return XMLDatatypeUtil.normalizeBoolean(value);
        }
        if (datatype.equals(XSD.DATETIME)) {
            return XMLDatatypeUtil.normalizeDateTime(value);
        }
        if (datatype.equals(XSD.ANYURI)) {
            return XMLDatatypeUtil.collapseWhiteSpace(value);
        }
        return value;
    }

    public static String normalize(String value, CoreDatatype.XSD datatype) {
        switch (datatype) {
            case DECIMAL: {
                return XMLDatatypeUtil.normalizeDecimal(value);
            }
            case INTEGER: {
                return XMLDatatypeUtil.normalizeInteger(value);
            }
            case NEGATIVE_INTEGER: {
                return XMLDatatypeUtil.normalizeNegativeInteger(value);
            }
            case NON_POSITIVE_INTEGER: {
                return XMLDatatypeUtil.normalizeNonPositiveInteger(value);
            }
            case NON_NEGATIVE_INTEGER: {
                return XMLDatatypeUtil.normalizeNonNegativeInteger(value);
            }
            case POSITIVE_INTEGER: {
                return XMLDatatypeUtil.normalizePositiveInteger(value);
            }
            case LONG: {
                return XMLDatatypeUtil.normalizeLong(value);
            }
            case INT: {
                return XMLDatatypeUtil.normalizeInt(value);
            }
            case SHORT: {
                return XMLDatatypeUtil.normalizeShort(value);
            }
            case BYTE: {
                return XMLDatatypeUtil.normalizeByte(value);
            }
            case UNSIGNED_LONG: {
                return XMLDatatypeUtil.normalizeUnsignedLong(value);
            }
            case UNSIGNED_INT: {
                return XMLDatatypeUtil.normalizeUnsignedInt(value);
            }
            case UNSIGNED_SHORT: {
                return XMLDatatypeUtil.normalizeUnsignedShort(value);
            }
            case UNSIGNED_BYTE: {
                return XMLDatatypeUtil.normalizeUnsignedByte(value);
            }
            case FLOAT: {
                return XMLDatatypeUtil.normalizeFloat(value);
            }
            case DOUBLE: {
                return XMLDatatypeUtil.normalizeDouble(value);
            }
            case BOOLEAN: {
                return XMLDatatypeUtil.normalizeBoolean(value);
            }
            case DATETIME: {
                return XMLDatatypeUtil.normalizeDateTime(value);
            }
            case ANYURI: {
                return XMLDatatypeUtil.collapseWhiteSpace(value);
            }
        }
        return value;
    }

    public static String normalizeBoolean(String value) {
        if ((value = XMLDatatypeUtil.collapseWhiteSpace(value)).equals("1")) {
            return "true";
        }
        if (value.equals("0")) {
            return "false";
        }
        if (value.equals("true") || value.equals("false")) {
            return value;
        }
        throw new IllegalArgumentExceptionWithoutStackTrace("Not a legal boolean value: " + value);
    }

    public static String normalizeDecimal(String decimal) {
        decimal = XMLDatatypeUtil.collapseWhiteSpace(decimal);
        int decLength = decimal.length();
        StringBuilder result = new StringBuilder(decLength + 2);
        if (decLength == 0) {
            throw new IllegalArgumentExceptionWithoutStackTrace("Not a legal decimal: " + decimal);
        }
        boolean isZeroPointZero = true;
        int idx = 0;
        if (decimal.charAt(idx) == '-') {
            result.append('-');
            ++idx;
        } else if (decimal.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == decLength) {
            throw new IllegalArgumentExceptionWithoutStackTrace("Not a legal decimal: " + decimal);
        }
        while (idx < decLength && decimal.charAt(idx) == '0') {
            ++idx;
        }
        if (idx == decLength) {
            result.append('0');
        } else if (idx < decLength && decimal.charAt(idx) == '.') {
            result.append('0');
        } else {
            char c;
            isZeroPointZero = false;
            while (idx < decLength && (c = decimal.charAt(idx)) != '.') {
                if (XMLDatatypeUtil.isNotDigit(c)) {
                    throw new IllegalArgumentExceptionWithoutStackTrace("Not a legal decimal: " + decimal);
                }
                result.append(c);
                ++idx;
            }
        }
        result.append('.');
        if (idx == decLength) {
            result.append('0');
        } else {
            int lastIdx;
            ++idx;
            for (lastIdx = decLength - 1; lastIdx >= 0 && decimal.charAt(lastIdx) == '0'; --lastIdx) {
            }
            if (idx > lastIdx) {
                result.append('0');
            } else {
                isZeroPointZero = false;
                while (idx <= lastIdx) {
                    char c = decimal.charAt(idx);
                    if (XMLDatatypeUtil.isNotDigit(c)) {
                        throw new IllegalArgumentExceptionWithoutStackTrace("Not a legal decimal: " + decimal);
                    }
                    result.append(c);
                    ++idx;
                }
            }
        }
        if (isZeroPointZero) {
            return "0.0";
        }
        return result.toString();
    }

    public static String normalizeInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, null, null);
    }

    public static String normalizeNegativeInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, null, "-1");
    }

    public static String normalizeNonPositiveInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, null, "0");
    }

    public static String normalizeNonNegativeInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", null);
    }

    public static String normalizePositiveInteger(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "1", null);
    }

    public static String normalizeLong(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "-9223372036854775808", "9223372036854775807");
    }

    public static String normalizeInt(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "-2147483648", "2147483647");
    }

    public static String normalizeShort(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "-32768", "32767");
    }

    public static String normalizeByte(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "-128", "127");
    }

    public static String normalizeUnsignedLong(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", "18446744073709551615");
    }

    public static String normalizeUnsignedInt(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", "4294967295");
    }

    public static String normalizeUnsignedShort(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", "65535");
    }

    public static String normalizeUnsignedByte(String value) {
        return XMLDatatypeUtil.normalizeIntegerValue(value, "0", "255");
    }

    private static String normalizeIntegerValue(String integer, String minValue, String maxValue) {
        int intLength = (integer = XMLDatatypeUtil.collapseWhiteSpace(integer)).length();
        if (intLength == 0) {
            throw new IllegalArgumentExceptionWithoutStackTrace("Not a legal integer: " + integer);
        }
        int idx = 0;
        boolean isNegative = false;
        if (integer.charAt(idx) == '-') {
            isNegative = true;
            ++idx;
        } else if (integer.charAt(idx) == '+') {
            ++idx;
        }
        if (idx == intLength) {
            throw new IllegalArgumentExceptionWithoutStackTrace("Not a legal integer: " + integer);
        }
        if (integer.charAt(idx) == '0' && idx < intLength - 1) {
            ++idx;
            while (idx < intLength - 1 && integer.charAt(idx) == '0') {
                ++idx;
            }
        }
        Object norm = integer.substring(idx);
        for (int i = 0; i < ((String)norm).length(); ++i) {
            if (!XMLDatatypeUtil.isNotDigit(((String)norm).charAt(i))) continue;
            throw new IllegalArgumentExceptionWithoutStackTrace("Not a legal integer: " + integer);
        }
        if (isNegative && ((String)norm).charAt(0) != '0') {
            norm = "-" + (String)norm;
        }
        if (minValue != null && XMLDatatypeUtil.compareCanonicalIntegers((String)norm, minValue) < 0) {
            throw VALUE_SMALLER_THAN_MINIMUM_VALUE_EXCEPTION;
        }
        if (maxValue != null && XMLDatatypeUtil.compareCanonicalIntegers((String)norm, maxValue) > 0) {
            throw VALUE_LARGER_THAN_MAXIMUM_VALUE_EXCEPTION;
        }
        return norm;
    }

    public static String normalizeFloat(String value) {
        return XMLDatatypeUtil.normalizeFPNumber(value, "-16777215.0", "16777215.0", "-149", "104");
    }

    public static String normalizeDouble(String value) {
        return XMLDatatypeUtil.normalizeFPNumber(value, "-9007199254740991.0", "9007199254740991.0", "-1075", "970");
    }

    public static String normalizeFPNumber(String value) {
        return XMLDatatypeUtil.normalizeFPNumber(value, null, null, null, null);
    }

    private static String normalizeFPNumber(String value, String minMantissa, String maxMantissa, String minExponent, String maxExponent) {
        int dotIdx;
        String exponent;
        String mantissa;
        if ((value = XMLDatatypeUtil.collapseWhiteSpace(value)).contains(" ")) {
            throw new IllegalArgumentExceptionWithoutStackTrace("No space allowed in floating point lexical value (" + value + ")");
        }
        if (value.equals(POSITIVE_INFINITY) || value.equals(NEGATIVE_INFINITY) || value.equals(NaN)) {
            return value;
        }
        int eIdx = value.indexOf(69);
        if (eIdx == -1) {
            eIdx = value.indexOf(101);
        }
        if (eIdx == -1) {
            mantissa = XMLDatatypeUtil.normalizeDecimal(value);
            exponent = "0";
        } else {
            mantissa = XMLDatatypeUtil.normalizeDecimal(value.substring(0, eIdx));
            exponent = XMLDatatypeUtil.normalizeInteger(value.substring(eIdx + 1));
        }
        int shift = 0;
        int digitCount = dotIdx = mantissa.indexOf(46);
        if (mantissa.charAt(0) == '-') {
            --digitCount;
        }
        if (digitCount > 1) {
            int nonZeroIdx;
            StringBuilder sb = new StringBuilder(mantissa.length());
            int firstDigitIdx = 0;
            if (mantissa.charAt(0) == '-') {
                sb.append('-');
                firstDigitIdx = 1;
            }
            sb.append(mantissa.charAt(firstDigitIdx));
            sb.append('.');
            sb.append(mantissa, firstDigitIdx + 1, dotIdx);
            sb.append(mantissa.substring(dotIdx + 1));
            mantissa = sb.toString();
            for (nonZeroIdx = mantissa.length() - 1; nonZeroIdx >= 3 && mantissa.charAt(nonZeroIdx) == '0'; --nonZeroIdx) {
            }
            if (nonZeroIdx < 3 && mantissa.charAt(0) == '-') {
                ++nonZeroIdx;
            }
            if (nonZeroIdx < mantissa.length() - 1) {
                mantissa = mantissa.substring(0, nonZeroIdx + 1);
            }
            shift = 1 - digitCount;
        } else if (mantissa.startsWith("0.") || mantissa.startsWith("-0.")) {
            int nonZeroIdx = 2;
            boolean negative = false;
            if (mantissa.charAt(0) == '-') {
                ++nonZeroIdx;
                negative = true;
            }
            while (nonZeroIdx < mantissa.length() && mantissa.charAt(nonZeroIdx) == '0') {
                ++nonZeroIdx;
            }
            if (nonZeroIdx < mantissa.length()) {
                StringBuilder sb = new StringBuilder(mantissa.length());
                if (negative) {
                    sb.append('-');
                }
                sb.append(mantissa.charAt(nonZeroIdx));
                sb.append('.');
                if (nonZeroIdx == mantissa.length() - 1) {
                    sb.append('0');
                } else {
                    sb.append(mantissa.substring(nonZeroIdx + 1));
                }
                mantissa = sb.toString();
                int n = shift = negative ? nonZeroIdx - 2 : nonZeroIdx - 1;
            }
        }
        if (shift != 0) {
            try {
                int exp = Integer.parseInt(exponent);
                exponent = String.valueOf(exp - shift);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("NumberFormatException: " + e.getMessage());
            }
        }
        if (minMantissa != null && XMLDatatypeUtil.compareCanonicalDecimals(mantissa, minMantissa) < 0) {
            throw new IllegalArgumentExceptionWithoutStackTrace("Mantissa smaller than minimum value (" + minMantissa + ")");
        }
        if (maxMantissa != null && XMLDatatypeUtil.compareCanonicalDecimals(mantissa, maxMantissa) > 0) {
            throw new IllegalArgumentExceptionWithoutStackTrace("Mantissa larger than maximum value (" + maxMantissa + ")");
        }
        if (minExponent != null && XMLDatatypeUtil.compareCanonicalIntegers(exponent, minExponent) < 0) {
            throw new IllegalArgumentExceptionWithoutStackTrace("Exponent smaller than minimum value (" + minExponent + ")");
        }
        if (maxExponent != null && XMLDatatypeUtil.compareCanonicalIntegers(exponent, maxExponent) > 0) {
            throw new IllegalArgumentExceptionWithoutStackTrace("Exponent larger than maximum value (" + maxExponent + ")");
        }
        return mantissa + "E" + exponent;
    }

    public static String normalizeDateTime(String value) {
        XMLDateTime dt = new XMLDateTime(value);
        dt.normalize();
        return dt.toString();
    }

    public static String collapseWhiteSpace(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        StringTokenizer st = new StringTokenizer(s, "\t\r\n ");
        if (st.hasMoreTokens()) {
            sb.append(st.nextToken());
        }
        while (st.hasMoreTokens()) {
            sb.append(' ').append(st.nextToken());
        }
        return sb.toString();
    }

    public static int compare(String value1, String value2, IRI datatype) {
        if (datatype.equals(XSD.DECIMAL)) {
            return XMLDatatypeUtil.compareDecimals(value1, value2);
        }
        if (datatype.equals(XSD.INTEGER)) {
            return XMLDatatypeUtil.compareIntegers(value1, value2);
        }
        if (datatype.equals(XSD.NEGATIVE_INTEGER)) {
            return XMLDatatypeUtil.compareNegativeIntegers(value1, value2);
        }
        if (datatype.equals(XSD.NON_POSITIVE_INTEGER)) {
            return XMLDatatypeUtil.compareNonPositiveIntegers(value1, value2);
        }
        if (datatype.equals(XSD.NON_NEGATIVE_INTEGER)) {
            return XMLDatatypeUtil.compareNonNegativeIntegers(value1, value2);
        }
        if (datatype.equals(XSD.POSITIVE_INTEGER)) {
            return XMLDatatypeUtil.comparePositiveIntegers(value1, value2);
        }
        if (datatype.equals(XSD.LONG)) {
            return XMLDatatypeUtil.compareLongs(value1, value2);
        }
        if (datatype.equals(XSD.INT)) {
            return XMLDatatypeUtil.compareInts(value1, value2);
        }
        if (datatype.equals(XSD.SHORT)) {
            return XMLDatatypeUtil.compareShorts(value1, value2);
        }
        if (datatype.equals(XSD.BYTE)) {
            return XMLDatatypeUtil.compareBytes(value1, value2);
        }
        if (datatype.equals(XSD.UNSIGNED_LONG)) {
            return XMLDatatypeUtil.compareUnsignedLongs(value1, value2);
        }
        if (datatype.equals(XSD.UNSIGNED_INT)) {
            return XMLDatatypeUtil.compareUnsignedInts(value1, value2);
        }
        if (datatype.equals(XSD.UNSIGNED_SHORT)) {
            return XMLDatatypeUtil.compareUnsignedShorts(value1, value2);
        }
        if (datatype.equals(XSD.UNSIGNED_BYTE)) {
            return XMLDatatypeUtil.compareUnsignedBytes(value1, value2);
        }
        if (datatype.equals(XSD.FLOAT)) {
            return XMLDatatypeUtil.compareFloats(value1, value2);
        }
        if (datatype.equals(XSD.DOUBLE)) {
            return XMLDatatypeUtil.compareDoubles(value1, value2);
        }
        if (datatype.equals(XSD.DATETIME) || datatype.equals(XSD.DATETIMESTAMP)) {
            return XMLDatatypeUtil.compareDateTime(value1, value2);
        }
        throw new IllegalArgumentException("datatype is not ordered");
    }

    public static int compareDecimals(String dec1, String dec2) {
        dec1 = XMLDatatypeUtil.normalizeDecimal(dec1);
        dec2 = XMLDatatypeUtil.normalizeDecimal(dec2);
        return XMLDatatypeUtil.compareCanonicalDecimals(dec1, dec2);
    }

    public static int compareCanonicalDecimals(String dec1, String dec2) {
        int dotIdx2;
        if (dec1.equals(dec2)) {
            return 0;
        }
        if (dec1.charAt(0) == '-' && dec2.charAt(0) != '-') {
            return -1;
        }
        if (dec2.charAt(0) == '-' && dec1.charAt(0) != '-') {
            return 1;
        }
        int dotIdx1 = dec1.indexOf(46);
        int result = dotIdx1 - (dotIdx2 = dec2.indexOf(46));
        if (result == 0) {
            for (int i = 0; result == 0 && i < dotIdx1; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            int dec1Length = dec1.length();
            int dec2Length = dec2.length();
            int lastIdx = Math.min(dec1Length, dec2Length);
            for (int i = dotIdx1 + 1; result == 0 && i < lastIdx; ++i) {
                result = dec1.charAt(i) - dec2.charAt(i);
            }
            if (result == 0) {
                result = dec1Length - dec2Length;
            }
        }
        if (dec1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    public static int compareIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeInteger(int1);
        int2 = XMLDatatypeUtil.normalizeInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareCanonicalIntegers(String int1, String int2) {
        if (int1.equals(int2)) {
            return 0;
        }
        if (int1.charAt(0) == '-' && int2.charAt(0) != '-') {
            return -1;
        }
        if (int2.charAt(0) == '-' && int1.charAt(0) != '-') {
            return 1;
        }
        int result = int1.length() - int2.length();
        if (result == 0) {
            for (int i = 0; result == 0 && i < int1.length(); ++i) {
                result = int1.charAt(i) - int2.charAt(i);
            }
        }
        if (int1.charAt(0) == '-') {
            result = -result;
        }
        return result;
    }

    public static int compareNegativeIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeNegativeInteger(int1);
        int2 = XMLDatatypeUtil.normalizeNegativeInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareNonPositiveIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeNonPositiveInteger(int1);
        int2 = XMLDatatypeUtil.normalizeNonPositiveInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareNonNegativeIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeNonNegativeInteger(int1);
        int2 = XMLDatatypeUtil.normalizeNonNegativeInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int comparePositiveIntegers(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizePositiveInteger(int1);
        int2 = XMLDatatypeUtil.normalizePositiveInteger(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareLongs(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeLong(int1);
        int2 = XMLDatatypeUtil.normalizeLong(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareInts(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeInt(int1);
        int2 = XMLDatatypeUtil.normalizeInt(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareShorts(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeShort(int1);
        int2 = XMLDatatypeUtil.normalizeShort(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareBytes(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeByte(int1);
        int2 = XMLDatatypeUtil.normalizeByte(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedLongs(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeUnsignedLong(int1);
        int2 = XMLDatatypeUtil.normalizeUnsignedLong(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedInts(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeUnsignedInt(int1);
        int2 = XMLDatatypeUtil.normalizeUnsignedInt(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedShorts(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeUnsignedShort(int1);
        int2 = XMLDatatypeUtil.normalizeUnsignedShort(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareUnsignedBytes(String int1, String int2) {
        int1 = XMLDatatypeUtil.normalizeUnsignedByte(int1);
        int2 = XMLDatatypeUtil.normalizeUnsignedByte(int2);
        return XMLDatatypeUtil.compareCanonicalIntegers(int1, int2);
    }

    public static int compareFloats(String float1, String float2) {
        float1 = XMLDatatypeUtil.normalizeFloat(float1);
        float2 = XMLDatatypeUtil.normalizeFloat(float2);
        return XMLDatatypeUtil.compareCanonicalFloats(float1, float2);
    }

    public static int compareCanonicalFloats(String float1, String float2) {
        return XMLDatatypeUtil.compareCanonicalFPNumbers(float1, float2);
    }

    public static int compareDoubles(String double1, String double2) {
        double1 = XMLDatatypeUtil.normalizeDouble(double1);
        double2 = XMLDatatypeUtil.normalizeDouble(double2);
        return XMLDatatypeUtil.compareCanonicalDoubles(double1, double2);
    }

    public static int compareCanonicalDoubles(String double1, String double2) {
        return XMLDatatypeUtil.compareCanonicalFPNumbers(double1, double2);
    }

    public static int compareFPNumbers(String fp1, String fp2) {
        return XMLDatatypeUtil.compareCanonicalFPNumbers(XMLDatatypeUtil.normalizeFPNumber(fp1), XMLDatatypeUtil.normalizeFPNumber(fp2));
    }

    public static int compareCanonicalFPNumbers(String float1, String float2) {
        if (float1.equals(NaN) || float2.equals(NaN)) {
            if (float1.equals(float2)) {
                return 0;
            }
            throw NAN_COMPARE_EXCEPTION;
        }
        if (float1.equals(POSITIVE_INFINITY)) {
            return float2.equals(POSITIVE_INFINITY) ? 0 : 1;
        }
        if (float2.equals(POSITIVE_INFINITY)) {
            return -1;
        }
        if (float1.equals(NEGATIVE_INFINITY)) {
            return float2.equals(NEGATIVE_INFINITY) ? 0 : -1;
        }
        if (float2.equals(NEGATIVE_INFINITY)) {
            return 1;
        }
        if (float1.charAt(0) == '-' && float2.charAt(0) != '-') {
            return -1;
        }
        if (float2.charAt(0) == '-' && float1.charAt(0) != '-') {
            return 1;
        }
        int eIdx1 = float1.indexOf(69);
        String mantissa1 = float1.substring(0, eIdx1);
        String exponent1 = float1.substring(eIdx1 + 1);
        int eIdx2 = float2.indexOf(69);
        String mantissa2 = float2.substring(0, eIdx2);
        String exponent2 = float2.substring(eIdx2 + 1);
        int result = XMLDatatypeUtil.compareCanonicalIntegers(exponent1, exponent2);
        if (result != 0 && float1.charAt(0) == '-') {
            result = -result;
        }
        if (result == 0) {
            result = XMLDatatypeUtil.compareCanonicalDecimals(mantissa1, mantissa2);
        }
        return result;
    }

    public static int compareDateTime(String value1, String value2) {
        XMLDateTime dateTime1 = new XMLDateTime(value1);
        XMLDateTime dateTime2 = new XMLDateTime(value2);
        dateTime1.normalize();
        dateTime2.normalize();
        return dateTime1.compareTo(dateTime2);
    }

    public static boolean parseBoolean(String s) {
        return XMLDatatypeUtil.normalizeBoolean(s).equals("true");
    }

    public static byte parseByte(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Byte.parseByte(s);
    }

    public static short parseShort(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Short.parseShort(s);
    }

    public static int parseInt(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Integer.parseInt(s);
    }

    public static long parseLong(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Long.parseLong(s);
    }

    public static float parseFloat(String s) {
        if (POSITIVE_INFINITY.equals(s)) {
            return Float.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Float.NEGATIVE_INFINITY;
        }
        if (NaN.equals(s)) {
            return Float.NaN;
        }
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Float.parseFloat(s);
    }

    public static double parseDouble(String s) {
        if (POSITIVE_INFINITY.equals(s)) {
            return Double.POSITIVE_INFINITY;
        }
        if (NEGATIVE_INFINITY.equals(s)) {
            return Double.NEGATIVE_INFINITY;
        }
        if (NaN.equals(s)) {
            return Double.NaN;
        }
        s = XMLDatatypeUtil.trimPlusSign(s);
        return Double.parseDouble(s);
    }

    public static BigInteger parseInteger(String s) {
        s = XMLDatatypeUtil.trimPlusSign(s);
        return new BigInteger(s);
    }

    public static BigDecimal parseDecimal(String s) {
        return new BigDecimal(s);
    }

    public static XMLGregorianCalendar parseCalendar(String s) {
        return dtFactory.newXMLGregorianCalendar(s);
    }

    public static Duration parseDuration(String s) {
        return dtFactory.newDuration(s);
    }

    private static String trimPlusSign(String s) {
        if (s.length() > 0 && s.charAt(0) == '+') {
            return s.substring(1);
        }
        return s;
    }

    public static IRI qnameToURI(QName qname) {
        if (DatatypeConstants.DATETIME == qname) {
            return XSD.DATETIME;
        }
        if (DatatypeConstants.DATE == qname) {
            return XSD.DATE;
        }
        if (DatatypeConstants.TIME == qname) {
            return XSD.TIME;
        }
        if (DatatypeConstants.GYEARMONTH == qname) {
            return XSD.GYEARMONTH;
        }
        if (DatatypeConstants.GMONTHDAY == qname) {
            return XSD.GMONTHDAY;
        }
        if (DatatypeConstants.GYEAR == qname) {
            return XSD.GYEAR;
        }
        if (DatatypeConstants.GMONTH == qname) {
            return XSD.GMONTH;
        }
        if (DatatypeConstants.GDAY == qname) {
            return XSD.GDAY;
        }
        if (DatatypeConstants.DURATION == qname) {
            return XSD.DURATION;
        }
        if (DatatypeConstants.DURATION_DAYTIME == qname) {
            return XSD.DAYTIMEDURATION;
        }
        if (DatatypeConstants.DURATION_YEARMONTH == qname) {
            return XSD.YEARMONTHDURATION;
        }
        throw new IllegalArgumentException("QName cannot be mapped to an XML Schema IRI: " + qname.toString());
    }

    public static CoreDatatype.XSD qnameToCoreDatatype(QName qname) {
        if (DatatypeConstants.DATETIME == qname) {
            return CoreDatatype.XSD.DATETIME;
        }
        if (DatatypeConstants.DATE == qname) {
            return CoreDatatype.XSD.DATE;
        }
        if (DatatypeConstants.TIME == qname) {
            return CoreDatatype.XSD.TIME;
        }
        if (DatatypeConstants.GYEARMONTH == qname) {
            return CoreDatatype.XSD.GYEARMONTH;
        }
        if (DatatypeConstants.GMONTHDAY == qname) {
            return CoreDatatype.XSD.GMONTHDAY;
        }
        if (DatatypeConstants.GYEAR == qname) {
            return CoreDatatype.XSD.GYEAR;
        }
        if (DatatypeConstants.GMONTH == qname) {
            return CoreDatatype.XSD.GMONTH;
        }
        if (DatatypeConstants.GDAY == qname) {
            return CoreDatatype.XSD.GDAY;
        }
        if (DatatypeConstants.DURATION == qname) {
            return CoreDatatype.XSD.DURATION;
        }
        if (DatatypeConstants.DURATION_DAYTIME == qname) {
            return CoreDatatype.XSD.DAYTIMEDURATION;
        }
        if (DatatypeConstants.DURATION_YEARMONTH == qname) {
            return CoreDatatype.XSD.YEARMONTHDURATION;
        }
        throw new IllegalArgumentException("QName cannot be mapped to an XML Schema IRI: " + qname.toString());
    }

    public static String toString(Number value) {
        double d = value.doubleValue();
        if (Double.POSITIVE_INFINITY == d) {
            return POSITIVE_INFINITY;
        }
        if (Double.NEGATIVE_INFINITY == d) {
            return NEGATIVE_INFINITY;
        }
        if (Double.isNaN(d)) {
            return NaN;
        }
        return value.toString();
    }

    private static boolean isNotDigit(char c) {
        return c < '0' || c > '9';
    }

    static {
        try {
            dtFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new RuntimeException(e);
        }
        P_DURATION = Pattern.compile("-?P((\\d)+Y)?((\\d)+M)?((\\d)+D)?((T(\\d)+H((\\d)+M)?((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+M((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+(\\.(\\d)+)?S))?");
        P_DAYTIMEDURATION = Pattern.compile("-?P((\\d)+D)?((T(\\d)+H((\\d)+M)?((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+M((\\d)+(\\.(\\d)+)?S)?)|(T(\\d)+(\\.(\\d)+)?S))?");
        P_YEARMONTHDURATION = Pattern.compile("-?P((\\d)+Y)?((\\d)+M)?");
        P_TIMEZONE = Pattern.compile(".*(Z|[+-]((0\\d|1[0-3]):[0-5]\\d|14:00))$");
        P_DATE = Pattern.compile("-?\\d{4,}-\\d\\d-\\d\\d(Z|([+\\-])\\d\\d:\\d\\d)?");
        P_TIME = Pattern.compile("\\d\\d:\\d\\d:\\d\\d(\\.\\d+)?(Z|([+\\-])\\d\\d:\\d\\d)?");
        P_GDAY = Pattern.compile("---\\d\\d(Z|([+\\-])\\d\\d:\\d\\d)?");
        P_GMONTH = Pattern.compile("--\\d\\d(Z|([+\\-])\\d\\d:\\d\\d)?");
        P_GMONTHDAY = Pattern.compile("--\\d\\d-\\d\\d(Z|([+\\-])\\d\\d:\\d\\d)?");
        P_GYEAR = Pattern.compile("-?\\d{4,}(Z|([+\\-])\\d\\d:\\d\\d)?");
        P_GYEARMONTH = Pattern.compile("-?\\d{4,}-\\d\\d(Z|([+\\-])\\d\\d:\\d\\d)?");
        primitiveDatatypes = Set.of(XSD.DURATION, XSD.DATETIME, XSD.TIME, XSD.DATE, XSD.GYEARMONTH, XSD.GYEAR, XSD.GMONTHDAY, XSD.GDAY, XSD.GMONTH, XSD.STRING, XSD.BOOLEAN, XSD.BASE64BINARY, XSD.HEXBINARY, XSD.FLOAT, XSD.DECIMAL, XSD.DOUBLE, XSD.ANYURI, XSD.QNAME, XSD.NOTATION);
        derivedDatatypes = Set.of(XSD.NORMALIZEDSTRING, XSD.TOKEN, XSD.LANGUAGE, XSD.NMTOKEN, XSD.NMTOKENS, XSD.NAME, XSD.NCNAME, XSD.ID, XSD.IDREF, XSD.IDREFS, XSD.ENTITY, XSD.ENTITIES, XSD.INTEGER, XSD.LONG, XSD.INT, XSD.SHORT, XSD.BYTE, XSD.NON_POSITIVE_INTEGER, XSD.NEGATIVE_INTEGER, XSD.NON_NEGATIVE_INTEGER, XSD.POSITIVE_INTEGER, XSD.UNSIGNED_LONG, XSD.UNSIGNED_INT, XSD.UNSIGNED_SHORT, XSD.UNSIGNED_BYTE, XSD.DAYTIMEDURATION, XSD.YEARMONTHDURATION, XSD.DATETIMESTAMP);
        integerDatatypes = Set.of(XSD.INTEGER, XSD.LONG, XSD.INT, XSD.SHORT, XSD.BYTE, XSD.NON_POSITIVE_INTEGER, XSD.NEGATIVE_INTEGER, XSD.NON_NEGATIVE_INTEGER, XSD.POSITIVE_INTEGER, XSD.UNSIGNED_LONG, XSD.UNSIGNED_INT, XSD.UNSIGNED_SHORT, XSD.UNSIGNED_BYTE);
        calendarDatatypes = Set.of(XSD.DATETIME, XSD.DATE, XSD.TIME, XSD.GYEARMONTH, XSD.GMONTHDAY, XSD.GYEAR, XSD.GMONTH, XSD.GDAY, XSD.DATETIMESTAMP);
        durationDatatypes = Set.of(XSD.DURATION, XSD.DAYTIMEDURATION, XSD.YEARMONTHDURATION);
    }

    private static class IllegalArgumentExceptionWithoutStackTrace
    extends IllegalArgumentException {
        public IllegalArgumentExceptionWithoutStackTrace(String msg) {
            super(msg);
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

