/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.core;

import java.util.Collection;
import java.util.Optional;
import java.util.function.Function;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElement;
import org.eclipse.rdf4j.sparqlbuilder.core.QueryElementCollection;

public abstract class StandardQueryElementCollection<T extends QueryElement>
extends QueryElementCollection<T> {
    private Optional<String> operatorName = Optional.empty();
    private Function<String, String> wrapperMethod = Function.identity();
    private boolean printBodyIfEmpty = false;
    private boolean printNameIfEmpty = true;

    protected StandardQueryElementCollection() {
    }

    protected StandardQueryElementCollection(String delimeter) {
        super(delimeter);
    }

    protected StandardQueryElementCollection(String operatorName, String delimeter) {
        super(delimeter);
        this.setOperatorName(operatorName);
    }

    protected StandardQueryElementCollection(String delimeter, Collection<T> collection) {
        super(delimeter, collection);
    }

    protected StandardQueryElementCollection(String operatorName, Function<String, String> wrapperMethod) {
        this.setOperatorName(operatorName);
        this.setWrapperMethod(wrapperMethod);
    }

    protected StandardQueryElementCollection(String operatorName, String delimiter, Collection<T> collection) {
        super(delimiter, collection);
        this.setOperatorName(operatorName);
    }

    protected StandardQueryElementCollection(String operatorName, String delimiter, Function<String, String> wrapperMethod, Collection<T> collection) {
        super(delimiter, collection);
        this.setOperatorName(operatorName);
        this.setWrapperMethod(wrapperMethod);
    }

    protected void setOperatorName(String operatorName) {
        this.setOperatorName(operatorName, true);
    }

    protected void setOperatorName(String operatorName, boolean pad) {
        this.operatorName = Optional.of(operatorName + (pad ? " " : ""));
    }

    protected void setWrapperMethod(Function<String, String> wrapperMethod) {
        this.wrapperMethod = wrapperMethod;
    }

    protected void resetWrapperMethod() {
        this.wrapperMethod = Function.identity();
    }

    protected void printBodyIfEmpty(boolean printBodyIfEmpty) {
        this.printBodyIfEmpty = printBodyIfEmpty;
    }

    protected void printNameIfEmpty(boolean printNameIfEmpty) {
        this.printNameIfEmpty = printNameIfEmpty;
    }

    @Override
    public String getQueryString() {
        StringBuilder queryString;
        block5: {
            block4: {
                queryString = new StringBuilder();
                if (this.printNameIfEmpty) break block4;
                if (this.isEmpty()) break block5;
            }
            this.operatorName.ifPresent(queryString::append);
        }
        if (this.printBodyIfEmpty || !this.isEmpty()) {
            queryString.append(this.wrapperMethod.apply(super.getQueryString()));
        }
        return queryString.toString();
    }
}

