/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.config;

import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.sail.base.config.BaseSailConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.nativerdf.config.NativeStoreSchema;

public class NativeStoreConfig
extends BaseSailConfig {
    private static final boolean USE_CONFIG = "true".equalsIgnoreCase(System.getProperty("org.eclipse.rdf4j.model.vocabulary.experimental.enableConfig"));
    private String tripleIndexes;
    private boolean forceSync = false;
    private int valueCacheSize = -1;
    private int valueIDCacheSize = -1;
    private int namespaceCacheSize = -1;
    private int namespaceIDCacheSize = -1;

    public NativeStoreConfig() {
        super("openrdf:NativeStore");
    }

    public NativeStoreConfig(String tripleIndexes) {
        this();
        this.setTripleIndexes(tripleIndexes);
    }

    public NativeStoreConfig(String tripleIndexes, boolean forceSync) {
        this(tripleIndexes);
        this.setForceSync(forceSync);
    }

    public String getTripleIndexes() {
        return this.tripleIndexes;
    }

    public void setTripleIndexes(String tripleIndexes) {
        this.tripleIndexes = tripleIndexes;
    }

    public boolean getForceSync() {
        return this.forceSync;
    }

    public void setForceSync(boolean forceSync) {
        this.forceSync = forceSync;
    }

    public int getValueCacheSize() {
        return this.valueCacheSize;
    }

    public void setValueCacheSize(int valueCacheSize) {
        this.valueCacheSize = valueCacheSize;
    }

    public int getValueIDCacheSize() {
        return this.valueIDCacheSize;
    }

    public void setValueIDCacheSize(int valueIDCacheSize) {
        this.valueIDCacheSize = valueIDCacheSize;
    }

    public int getNamespaceCacheSize() {
        return this.namespaceCacheSize;
    }

    public void setNamespaceCacheSize(int namespaceCacheSize) {
        this.namespaceCacheSize = namespaceCacheSize;
    }

    public int getNamespaceIDCacheSize() {
        return this.namespaceIDCacheSize;
    }

    public void setNamespaceIDCacheSize(int namespaceIDCacheSize) {
        this.namespaceIDCacheSize = namespaceIDCacheSize;
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        m.setNamespace(CONFIG.NS);
        if (this.tripleIndexes != null) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Native.tripleIndexes, Values.literal(this.tripleIndexes), new Resource[0]);
            } else {
                m.add(implNode, NativeStoreSchema.TRIPLE_INDEXES, Values.literal(this.tripleIndexes), new Resource[0]);
            }
        }
        if (this.forceSync) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Native.forceSync, Values.literal(this.forceSync), new Resource[0]);
            } else {
                m.add(implNode, NativeStoreSchema.FORCE_SYNC, Values.literal(this.forceSync), new Resource[0]);
            }
        }
        if (this.valueCacheSize >= 0) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Native.valueCacheSize, Values.literal(this.valueCacheSize), new Resource[0]);
            } else {
                m.add(implNode, NativeStoreSchema.VALUE_CACHE_SIZE, Values.literal(this.valueCacheSize), new Resource[0]);
            }
        }
        if (this.valueIDCacheSize >= 0) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Native.valueIDCacheSize, Values.literal(this.valueIDCacheSize), new Resource[0]);
            } else {
                m.add(implNode, NativeStoreSchema.VALUE_ID_CACHE_SIZE, Values.literal(this.valueIDCacheSize), new Resource[0]);
            }
        }
        if (this.namespaceCacheSize >= 0) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Native.namespaceCacheSize, Values.literal(this.namespaceCacheSize), new Resource[0]);
            } else {
                m.add(implNode, NativeStoreSchema.NAMESPACE_CACHE_SIZE, Values.literal(this.namespaceCacheSize), new Resource[0]);
            }
        }
        if (this.namespaceIDCacheSize >= 0) {
            if (USE_CONFIG) {
                m.add(implNode, CONFIG.Native.namespaceIDCacheSize, Values.literal(this.namespaceIDCacheSize), new Resource[0]);
            } else {
                m.add(implNode, NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE, Values.literal(this.namespaceIDCacheSize), new Resource[0]);
            }
        }
        return implNode;
    }

    @Override
    public void parse(Model m, Resource implNode) throws SailConfigException {
        super.parse(m, implNode);
        try {
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.tripleIndexes, NativeStoreSchema.TRIPLE_INDEXES).ifPresent(lit -> this.setTripleIndexes(lit.getLabel()));
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.forceSync, NativeStoreSchema.FORCE_SYNC).ifPresent(lit -> {
                try {
                    this.setForceSync(lit.booleanValue());
                }
                catch (IllegalArgumentException e) {
                    throw new SailConfigException("Boolean value required for " + CONFIG.Native.forceSync + " property, found " + lit);
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.valueCacheSize, NativeStoreSchema.VALUE_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setValueCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + CONFIG.Native.valueCacheSize + " property, found " + lit);
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.valueIDCacheSize, NativeStoreSchema.VALUE_ID_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setValueIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + CONFIG.Native.valueIDCacheSize + " property, found " + lit);
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.namespaceCacheSize, NativeStoreSchema.NAMESPACE_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setNamespaceCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + CONFIG.Native.namespaceCacheSize + " property, found " + lit);
                }
            });
            Configurations.getLiteralValue(m, implNode, CONFIG.Native.namespaceIDCacheSize, NativeStoreSchema.NAMESPACE_ID_CACHE_SIZE).ifPresent(lit -> {
                try {
                    this.setNamespaceIDCacheSize(lit.intValue());
                }
                catch (NumberFormatException e) {
                    throw new SailConfigException("Integer value required for " + CONFIG.Native.namespaceIDCacheSize + " property, found " + lit);
                }
            });
        }
        catch (ModelException e) {
            throw new SailConfigException(e.getMessage(), e);
        }
    }
}

