/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.nquads;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.ntriples.NTriplesWriter;

public class NQuadsWriter
extends NTriplesWriter {
    public NQuadsWriter(OutputStream outputStream) {
        super(outputStream);
    }

    public NQuadsWriter(Writer writer) {
        super(writer);
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.NQUADS;
    }

    public void consumeStatement(Statement st) throws RDFHandlerException {
        try {
            this.writeValue((Value)st.getSubject());
            this.writer.write(" ");
            this.writeValue((Value)st.getPredicate());
            this.writer.write(" ");
            this.writeValue(st.getObject());
            if (null != st.getContext()) {
                this.writer.write(" ");
                this.writeValue((Value)st.getContext());
            }
            this.writer.write(" .\n");
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }
}

