/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.helpers;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.helpers.NTriplesUtil;

public class RDFStarUtil {
    public static final String TRIPLE_PREFIX = "urn:rdf4j:triple:";
    private static ValueFactory VF = SimpleValueFactory.getInstance();

    public static <T extends Value> T toRDFEncodedValue(T value) {
        return (T)(value instanceof Triple ? VF.createIRI(TRIPLE_PREFIX + RDFStarUtil.encode(NTriplesUtil.toNTriplesString(value))) : value);
    }

    public static <T extends Value> T fromRDFEncodedValue(T encodedValue) {
        try {
            return (T)(RDFStarUtil.isEncodedTriple(encodedValue) ? NTriplesUtil.parseTriple(RDFStarUtil.decode(encodedValue.stringValue().substring(TRIPLE_PREFIX.length())), VF) : encodedValue);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid RDF-star encoded triple: " + encodedValue);
        }
    }

    public static boolean isEncodedTriple(Value value) {
        return value instanceof IRI && value.stringValue().startsWith(TRIPLE_PREFIX);
    }

    private static String encode(String s) {
        return Base64.getUrlEncoder().encodeToString(s.getBytes(StandardCharsets.UTF_8));
    }

    private static String decode(String s) {
        return new String(Base64.getUrlDecoder().decode(s), StandardCharsets.UTF_8);
    }
}

