/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lmdb;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.sail.lmdb.LmdbUtil;
import org.lwjgl.PointerBuffer;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.util.lmdb.LMDB;

class TxnRef {
    private final Mode mode;
    private final Map<Thread, TxnState> state = new HashMap<Thread, TxnState>();
    private final Txn[] pool;
    private long env;
    private volatile int poolIndex = -1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TxnRef(long txn) {
        Map<Thread, TxnState> map = this.state;
        synchronized (map) {
            this.state.put(Thread.currentThread(), new TxnState(new Txn(txn)));
            this.mode = Mode.NONE;
            this.pool = null;
        }
    }

    TxnRef(long env, Mode mode) {
        this.env = env;
        this.mode = mode;
        this.pool = mode == Mode.RESET ? new Txn[128] : null;
    }

    private long startReadTxn() {
        long readTxn;
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer pp = stack.mallocPointer(1);
            LmdbUtil.E(LMDB.mdb_txn_begin((long)this.env, (long)0L, (int)131072, (PointerBuffer)pp));
            readTxn = pp.get(0);
        }
        return readTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Txn createTxnInternal() {
        Txn newTxn = null;
        if (this.mode == Mode.RESET) {
            Map<Thread, TxnState> map = this.state;
            synchronized (map) {
                if (this.poolIndex >= 0) {
                    newTxn = this.pool[this.poolIndex--];
                }
            }
            if (newTxn == null) {
                newTxn = new Txn(this.startReadTxn());
            } else {
                LMDB.mdb_txn_renew((long)newTxn.txn);
                newTxn.refCount = 0L;
            }
        } else {
            newTxn = new Txn(this.startReadTxn());
        }
        return newTxn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long create() {
        Txn currentTxn;
        TxnState s;
        Map<Thread, TxnState> map = this.state;
        synchronized (map) {
            s = this.state.get(Thread.currentThread());
        }
        if (s == null) {
            s = new TxnState(this.createTxnInternal());
            currentTxn = s.currentTxn;
            Map<Thread, TxnState> map2 = this.state;
            synchronized (map2) {
                this.state.put(Thread.currentThread(), s);
            }
        } else {
            currentTxn = s.currentTxn;
            if (currentTxn == null) {
                s.currentTxn = currentTxn = this.createTxnInternal();
            }
        }
        ++currentTxn.refCount;
        return currentTxn.txn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void free(long txn) {
        Map<Thread, TxnState> map = this.state;
        synchronized (map) {
            TxnState s = this.state.get(Thread.currentThread());
            Txn t = s.currentTxn;
            if (t == null || t.txn != txn) {
                t = s.staleTxns.stream().filter(oldTxn -> oldTxn.txn == txn).findFirst().get();
            }
            if (--t.refCount <= 0L) {
                switch (this.mode) {
                    case RESET: {
                        if (this.poolIndex < this.pool.length - 1) {
                            LMDB.mdb_txn_reset((long)txn);
                            this.pool[++this.poolIndex] = t;
                            break;
                        }
                        LMDB.mdb_txn_abort((long)txn);
                        break;
                    }
                    case ABORT: {
                        LMDB.mdb_txn_abort((long)txn);
                        break;
                    }
                }
                if (t == s.currentTxn) {
                    if (s.staleTxns == null || s.staleTxns.isEmpty()) {
                        this.state.remove(Thread.currentThread());
                    } else {
                        s.currentTxn = null;
                    }
                } else if (s.staleTxns.size() == 1) {
                    this.state.remove(Thread.currentThread());
                } else {
                    s.staleTxns.remove(t);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T doWith(LmdbUtil.Transaction<T> transaction) throws IOException {
        T ret;
        try (MemoryStack stack = MemoryStack.stackPush();){
            long txn = this.create();
            try {
                ret = transaction.exec(stack, txn);
            }
            finally {
                this.free(txn);
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void invalidate() {
        Map<Thread, TxnState> map = this.state;
        synchronized (map) {
            this.state.values().forEach(s -> s.invalidate());
        }
    }

    static class Txn {
        long txn;
        long refCount;

        Txn(long txn) {
            this.txn = txn;
        }
    }

    static class TxnState {
        Txn currentTxn;
        List<Txn> staleTxns;

        TxnState(Txn txn) {
            this.currentTxn = txn;
        }

        void invalidate() {
            if (this.currentTxn != null) {
                if (this.staleTxns == null) {
                    this.staleTxns = new ArrayList<Txn>(5);
                }
                this.staleTxns.add(this.currentTxn);
                this.currentTxn = null;
            }
        }
    }

    static enum Mode {
        RESET,
        ABORT,
        NONE;

    }
}

