/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.Date;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;

public interface QueryEvaluationContext {
    public Literal getNow();

    public Dataset getDataset();

    default public MutableBindingSet createBindingSet() {
        return new QueryBindingSet();
    }

    default public Predicate<BindingSet> hasBinding(String variableName) {
        return bs -> bs.hasBinding(variableName);
    }

    default public Function<BindingSet, Binding> getBinding(String variableName) {
        return bs -> bs.getBinding(variableName);
    }

    default public Function<BindingSet, Value> getValue(String variableName) {
        Function<BindingSet, Binding> getBinding = this.getBinding(variableName);
        return bs -> {
            Binding binding = (Binding)getBinding.apply((BindingSet)bs);
            if (binding == null) {
                return null;
            }
            return binding.getValue();
        };
    }

    default public BiConsumer<Value, MutableBindingSet> setBinding(String variableName) {
        return (val, bs) -> bs.setBinding(variableName, val);
    }

    default public BiConsumer<Value, MutableBindingSet> addBinding(String variableName) {
        return (val, bs) -> bs.addBinding(variableName, val);
    }

    default public MutableBindingSet createBindingSet(BindingSet bindings) {
        return new QueryBindingSet(bindings);
    }

    public static class Minimal
    implements QueryEvaluationContext {
        private final Literal now;
        private final Dataset dataset;

        public Minimal(Literal now, Dataset dataset) {
            this.now = now;
            this.dataset = dataset;
        }

        public Minimal(Dataset dataset) {
            this.dataset = dataset;
            this.now = SimpleValueFactory.getInstance().createLiteral(new Date());
        }

        @Override
        public Literal getNow() {
            return this.now;
        }

        @Override
        public Dataset getDataset() {
            return this.dataset;
        }
    }
}

