/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.Cleaner;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.eclipse.rdf4j.common.annotation.Experimental;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.common.concurrent.locks.Lock;
import org.eclipse.rdf4j.common.concurrent.locks.ReadPrefReadWriteLockManager;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.common.transaction.TransactionSetting;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.model.vocabulary.DASH;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.model.vocabulary.RSX;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailConflictException;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencer;
import org.eclipse.rdf4j.sail.inferencer.fc.SchemaCachingRDFSInferencerConnection;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.ShaclSailBaseConfiguration;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSail
extends ShaclSailBaseConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSail.class);
    private static final Cleaner cleaner = Cleaner.create();
    private static final Model DASH_CONSTANTS = ShaclSail.resourceAsModel("shacl-sparql-inference/dashConstants.ttl");
    private static final IRI shaclVocabularyGraph = Values.iri("http://rdf4j.org/schema/rdf4j#", "shaclVocabularyGraph");
    private static final SchemaCachingRDFSInferencer shaclVocabulary = ShaclSail.createShaclVocabulary();
    private SailRepository shapesRepo;
    private final ReadPrefReadWriteLockManager lockManager = new ReadPrefReadWriteLockManager();
    private transient ShaclSailConnection currentConnection;
    private transient boolean multipleConcurrentConnections;
    private transient Thread threadHoldingWriteLock;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final ExecutorService[] executorService = new ExecutorService[1];

    public ShaclSail(NotifyingSail baseSail) {
        super(baseSail);
        cleaner.register(this, new CleanableState(this.initialized, this.executorService));
    }

    public ShaclSail() {
        cleaner.register(this, new CleanableState(this.initialized, this.executorService));
    }

    synchronized void closeConnection(ShaclSailConnection connection) {
        if (connection == this.currentConnection) {
            this.currentConnection = null;
        }
    }

    synchronized boolean usesSingleConnection() {
        return !this.multipleConcurrentConnections;
    }

    public static List<IRI> getSupportedShaclPredicates() {
        return Arrays.asList(SHACL.TARGET_CLASS, SHACL.PATH, SHACL.PROPERTY, SHACL.OR, SHACL.AND, SHACL.MIN_COUNT, SHACL.MAX_COUNT, SHACL.MIN_LENGTH, SHACL.MAX_LENGTH, SHACL.PATTERN, SHACL.FLAGS, SHACL.NODE_KIND_PROP, SHACL.LANGUAGE_IN, SHACL.DATATYPE, SHACL.MIN_EXCLUSIVE, SHACL.MIN_INCLUSIVE, SHACL.MAX_EXCLUSIVE, SHACL.MAX_INCLUSIVE, SHACL.CLASS, SHACL.TARGET_NODE, SHACL.DEACTIVATED, SHACL.TARGET_SUBJECTS_OF, SHACL.IN, SHACL.UNIQUE_LANG, SHACL.NOT, SHACL.TARGET_OBJECTS_OF, SHACL.HAS_VALUE, SHACL.TARGET_PROP, SHACL.INVERSE_PATH, SHACL.NODE, SHACL.QUALIFIED_MAX_COUNT, SHACL.QUALIFIED_MIN_COUNT, SHACL.QUALIFIED_VALUE_SHAPE, DASH.hasValueIn, RSX.targetShape);
    }

    @Override
    public void init() throws SailException {
        if (!this.initialized.compareAndSet(false, true)) {
            return;
        }
        super.init();
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        if (super.getBaseSail().getDataDir() != null) {
            Object path = super.getBaseSail().getDataDir().getPath();
            if (((String)path).endsWith("/")) {
                path = ((String)path).substring(0, ((String)path).length() - 1);
            }
            path = (String)path + "/shapes-graph/";
            logger.info("Shapes will be persisted in: " + (String)path);
            this.shapesRepo = new SailRepository(new MemoryStore(new File((String)path)));
        } else {
            this.shapesRepo = new SailRepository(new MemoryStore());
        }
        this.shapesRepo.init();
        try (SailRepositoryConnection shapesRepoConnection = this.shapesRepo.getConnection();){
            shapesRepoConnection.begin(IsolationLevels.NONE);
            shapesRepoConnection.commit();
        }
        assert (this.executorService[0] == null);
    }

    @InternalUseOnly
    public List<Shape> getShapes(RepositoryConnection shapesRepoConnection) throws SailException {
        List<Shape> shapes;
        SailRepository shapesRepoWithReasoning = new SailRepository(SchemaCachingRDFSInferencer.fastInstantiateFrom(shaclVocabulary, new MemoryStore(), false));
        shapesRepoWithReasoning.init();
        try (SailRepositoryConnection shapesRepoWithReasoningConnection = shapesRepoWithReasoning.getConnection();){
            shapesRepoWithReasoningConnection.begin(IsolationLevels.NONE);
            try (RepositoryResult<Statement> statements = shapesRepoConnection.getStatements(null, null, null, false, new Resource[0]);){
                shapesRepoWithReasoningConnection.add(statements, new Resource[0]);
            }
            this.enrichShapes(shapesRepoWithReasoningConnection);
            shapesRepoWithReasoningConnection.commit();
            shapes = Shape.Factory.getShapes(shapesRepoWithReasoningConnection, this);
        }
        shapesRepoWithReasoning.shutDown();
        return shapes;
    }

    @Override
    public synchronized void shutDown() throws SailException {
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        boolean terminated = this.shutdownExecutorService(false);
        this.initialized.set(false);
        super.shutDown();
        if (!terminated) {
            this.shutdownExecutorService(true);
        }
        this.executorService[0] = null;
    }

    private boolean shutdownExecutorService(boolean forced) {
        if (this.executorService[0] != null) {
            boolean terminated = false;
            this.executorService[0].shutdown();
            try {
                terminated = this.executorService[0].awaitTermination(200L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (forced && !terminated) {
                this.executorService[0].shutdownNow();
                logger.error("Shutdown ShaclSail while validation is still running.");
                terminated = true;
            }
            return terminated;
        }
        return true;
    }

    synchronized <T> Future<T> submitRunnableToExecutorService(Callable<T> runnable) {
        if (this.executorService[0] == null) {
            this.executorService[0] = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2, r -> {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            });
        }
        return this.executorService[0].submit(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NotifyingSailConnection getConnection() throws SailException {
        this.init();
        ShaclSailConnection shaclSailConnection = new ShaclSailConnection(this, super.getConnection(), super.getConnection(), super.getConnection(), super.getConnection(), this.shapesRepo.getConnection());
        ShaclSail shaclSail = this;
        synchronized (shaclSail) {
            if (this.currentConnection == null) {
                this.currentConnection = shaclSailConnection;
            } else {
                this.multipleConcurrentConnections = true;
            }
        }
        return shaclSailConnection;
    }

    private void enrichShapes(SailRepositoryConnection shaclSailConnection) {
        if (shaclSailConnection.isEmpty()) {
            return;
        }
        shaclSailConnection.add(DASH_CONSTANTS, new Resource[0]);
        this.implicitTargetClass(shaclSailConnection);
    }

    private void implicitTargetClass(SailRepositoryConnection shaclSailConnection) {
        try (Stream stream = shaclSailConnection.getStatements(null, RDF.TYPE, (Value)RDFS.CLASS, false, new Resource[0]).stream();){
            stream.map(Statement::getSubject).filter(s -> shaclSailConnection.hasStatement((Resource)s, RDF.TYPE, (Value)SHACL.NODE_SHAPE, true, new Resource[0]) || shaclSailConnection.hasStatement((Resource)s, RDF.TYPE, (Value)SHACL.PROPERTY_SHAPE, true, new Resource[0])).forEach(s -> shaclSailConnection.add((Resource)s, SHACL.TARGET_CLASS, (Value)s, new Resource[0]));
        }
    }

    Lock acquireExclusiveWriteLock(Lock lock) {
        if (lock != null && lock.isActive()) {
            return lock;
        }
        assert (lock == null);
        if (this.threadHoldingWriteLock == Thread.currentThread()) {
            throw new SailConflictException("Deadlock detected when a single thread uses multiple connections interleaved and one connection has modified the shapes without calling commit() while another connection also tries to modify the shapes!");
        }
        try {
            Lock writeLock = this.lockManager.getWriteLock();
            this.threadHoldingWriteLock = Thread.currentThread();
            return writeLock;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    Lock releaseExclusiveWriteLock(Lock lock) {
        this.threadHoldingWriteLock = null;
        lock.release();
        return null;
    }

    Lock acquireReadLock() {
        if (this.threadHoldingWriteLock == Thread.currentThread()) {
            throw new SailConflictException("Deadlock detected when a single thread uses multiple connections interleaved and one connection has modified the shapes without calling commit() while another connection calls commit()!");
        }
        try {
            return this.lockManager.getReadLock();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    Lock releaseReadLock(Lock lock) {
        lock.release();
        return null;
    }

    @InternalUseOnly
    public List<Shape> getCurrentShapes() {
        try (SailRepositoryConnection connection = this.shapesRepo.getConnection();){
            List<Shape> list = this.getShapes(connection);
            return list;
        }
    }

    boolean hasShapes() {
        try (SailRepositoryConnection connection = this.shapesRepo.getConnection();){
            boolean bl;
            connection.begin(IsolationLevels.NONE);
            try {
                bl = !connection.isEmpty();
            }
            catch (Throwable throwable) {
                connection.commit();
                throw throwable;
            }
            connection.commit();
            return bl;
        }
    }

    private static SchemaCachingRDFSInferencer createShaclVocabulary() {
        SchemaCachingRDFSInferencer schemaCachingRDFSInferencer;
        block15: {
            InputStream in = ShaclSail.getResourceAsStream("shacl-sparql-inference/shaclVocabulary.ttl");
            try {
                SchemaCachingRDFSInferencer schemaCachingRDFSInferencer2 = new SchemaCachingRDFSInferencer(new MemoryStore());
                try (SchemaCachingRDFSInferencerConnection connection = schemaCachingRDFSInferencer2.getConnection();){
                    connection.begin(IsolationLevels.NONE);
                    Model model = Rio.parse(in, "", RDFFormat.TURTLE, new Resource[0]);
                    model.forEach(s -> connection.addStatement(s.getSubject(), s.getPredicate(), s.getObject(), shaclVocabularyGraph));
                    connection.commit();
                }
                schemaCachingRDFSInferencer = schemaCachingRDFSInferencer2;
                if (in == null) break block15;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Resource could not be read: shacl-sparql-inference/shaclVocabulary.ttl", e);
                }
            }
            in.close();
        }
        return schemaCachingRDFSInferencer;
    }

    private static Model resourceAsModel(String filename) {
        Model model;
        block8: {
            InputStream resourceAsStream = ShaclSail.getResourceAsStream(filename);
            try {
                model = Rio.parse(resourceAsStream, "", RDFFormat.TURTLE, new Resource[0]);
                if (resourceAsStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (resourceAsStream != null) {
                        try {
                            resourceAsStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Resource could not be read: " + filename, e);
                }
            }
            resourceAsStream.close();
        }
        return model;
    }

    private static InputStream getResourceAsStream(String filename) {
        InputStream resourceAsStream = ShaclSail.class.getClassLoader().getResourceAsStream(filename);
        if (resourceAsStream == null) {
            throw new IllegalStateException("Resource could not be found: " + filename);
        }
        return new BufferedInputStream(resourceAsStream);
    }

    public static class TransactionSettings {
        private final String value;

        TransactionSettings(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static final class ValidationApproach
        extends Enum<ValidationApproach>
        implements TransactionSetting {
            public static final /* enum */ ValidationApproach Disabled = new ValidationApproach("Disabled", 0);
            public static final /* enum */ ValidationApproach Bulk = new ValidationApproach("Bulk", 1);
            public static final /* enum */ ValidationApproach Auto = new ValidationApproach("Auto", 2);
            private final String value;
            private final int priority;
            private static final /* synthetic */ ValidationApproach[] $VALUES;

            public static ValidationApproach[] values() {
                return (ValidationApproach[])$VALUES.clone();
            }

            public static ValidationApproach valueOf(String name) {
                return Enum.valueOf(ValidationApproach.class, name);
            }

            private ValidationApproach(String value, int priority) {
                this.value = value;
                this.priority = priority;
            }

            @Override
            public String getName() {
                return ValidationApproach.class.getCanonicalName();
            }

            @Override
            public String getValue() {
                return this.value;
            }

            public static ValidationApproach getHighestPriority(ValidationApproach v1, ValidationApproach v2) {
                assert (v1 != null || v2 != null);
                if (v1 == null) {
                    return v2;
                }
                if (v2 == null) {
                    return v1;
                }
                if (v1.priority < v2.priority) {
                    return v1;
                }
                return v2;
            }

            static {
                $VALUES = new ValidationApproach[]{Disabled, Bulk, Auto};
            }
        }

        @Experimental
        public static enum PerformanceHint implements TransactionSetting
        {
            ParallelValidation("ParallelValidation"),
            SerialValidation("SerialValidation"),
            CacheEnabled("CacheEnabled"),
            CacheDisabled("CacheDisabled");

            private final String value;

            private PerformanceHint(String value) {
                this.value = value;
            }

            @Override
            public String getName() {
                return PerformanceHint.class.getCanonicalName();
            }

            @Override
            public String getValue() {
                return this.value;
            }
        }
    }

    static class CleanableState
    implements Runnable {
        private final AtomicBoolean initialized;
        private final ExecutorService[] executorService;

        CleanableState(AtomicBoolean initialized, ExecutorService[] executorService) {
            this.initialized = initialized;
            this.executorService = executorService;
        }

        @Override
        public void run() {
            if (this.initialized.get()) {
                logger.error("ShaclSail was garbage collected without shutdown() having been called first.");
            }
            if (this.executorService[0] != null) {
                this.executorService[0].shutdownNow();
            }
        }
    }
}

