/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.targets;

import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.SetFilterNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValuesBackedNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.Target;

public class TargetNode
extends Target {
    private final TreeSet<Value> targetNodes;

    public TargetNode(TreeSet<Value> targetNodes) {
        this.targetNodes = targetNodes;
        assert (!this.targetNodes.isEmpty());
    }

    @Override
    public IRI getPredicate() {
        return SHACL.TARGET_NODE;
    }

    @Override
    public PlanNode getAdded(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        return new ValuesBackedNode(this.targetNodes, scope);
    }

    @Override
    public String getQueryFragment(String subjectVariable, String objectVariable, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        StringBuilder sb = new StringBuilder();
        sb.append("VALUES ( ").append(subjectVariable).append(" ) {\n");
        this.targetNodes.stream().map(targetNode -> {
            if (targetNode.isResource()) {
                return "<" + targetNode + ">";
            }
            if (targetNode.isLiteral()) {
                IRI datatype = ((Literal)targetNode).getDatatype();
                if (datatype == null) {
                    return "\"" + targetNode.stringValue() + "\"";
                }
                if (((Literal)targetNode).getLanguage().isPresent()) {
                    return "\"" + targetNode.stringValue() + "\"@" + (String)((Literal)targetNode).getLanguage().get();
                }
                return "\"" + targetNode.stringValue() + "\"^^<" + datatype.stringValue() + ">";
            }
            throw new IllegalStateException(targetNode.getClass().getSimpleName());
        }).forEach(targetNode -> sb.append("( ").append((String)targetNode).append(" )\n"));
        sb.append("}\n");
        return sb.toString();
    }

    @Override
    public PlanNode getTargetFilter(ConnectionsGroup connectionsGroup, PlanNode parent) {
        return new SetFilterNode(this.targetNodes, parent, 0, true);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection) {
        this.targetNodes.forEach(t -> model.add(subject, this.getPredicate(), t, new Resource[0]));
    }

    @Override
    public Stream<StatementMatcher> getStatementMatcher(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner) {
        assert (subject == null);
        return Stream.empty();
    }

    @Override
    public String getTargetQueryFragment(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, StatementMatcher.StableRandomVariableProvider stableRandomVariableProvider) {
        assert (subject == null);
        StringBuilder sb = new StringBuilder();
        sb.append("VALUES ( ?").append(object.getName()).append(" ) {\n");
        this.targetNodes.stream().map(targetNode -> {
            if (targetNode.isResource()) {
                return "<" + targetNode + ">";
            }
            if (targetNode.isLiteral()) {
                IRI datatype = ((Literal)targetNode).getDatatype();
                if (datatype == null) {
                    return "\"" + targetNode.stringValue() + "\"";
                }
                if (((Literal)targetNode).getLanguage().isPresent()) {
                    return "\"" + targetNode.stringValue() + "\"@" + (String)((Literal)targetNode).getLanguage().get();
                }
                return "\"" + targetNode.stringValue() + "\"^^<" + datatype.stringValue() + ">";
            }
            throw new IllegalStateException(targetNode.getClass().getSimpleName());
        }).forEach(targetNode -> sb.append("( ").append((String)targetNode).append(" )\n"));
        sb.append("}\n");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TargetNode that = (TargetNode)o;
        return this.targetNodes.equals(that.targetNodes);
    }

    public int hashCode() {
        return Objects.hash(this.targetNodes);
    }
}

