/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.FilterPlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Formatter;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;

public class DatatypeFilter
extends FilterPlanNode {
    private final IRI datatype;
    private final XSD.Datatype xsdDatatype;
    private StackTraceElement[] stackTrace;

    public DatatypeFilter(PlanNode parent, IRI datatype) {
        super(parent);
        this.datatype = datatype;
        this.xsdDatatype = XSD.Datatype.from(datatype).orElse(null);
    }

    @Override
    boolean checkTuple(ValidationTuple t) {
        if (!t.getValue().isLiteral()) {
            return false;
        }
        Literal literal = (Literal)t.getValue();
        if (this.xsdDatatype != null && literal instanceof SimpleLiteral) {
            return this.xsdDatatype == ((SimpleLiteral)literal).getXsdDatatype().orElse(null);
        }
        return literal.getDatatype() == this.datatype || literal.getDatatype().equals(this.datatype);
    }

    @Override
    public String toString() {
        return "DatatypeFilter{datatype=" + Formatter.prefix(this.datatype) + '}';
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DatatypeFilter that = (DatatypeFilter)o;
        return this.datatype.equals(that.datatype);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.datatype);
    }
}

