/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.datastore;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.math.LongMath;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.math.RoundingMode;
import java.util.Arrays;
import org.eclipse.rdf4j.common.io.NioFile;

public class IDFile
implements Closeable {
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 105, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final long HEADER_LENGTH = 8L;
    private static final long ITEM_SIZE = 8L;
    private final NioFile nioFile;
    private final boolean forceSync;
    private final Cache<Integer, Long[]> cache = CacheBuilder.newBuilder().softValues().build();
    private final int blockSize = 4096;
    private final int cacheLineSize = 512;
    private final int cacheLineShift = LongMath.log2((long)512L, (RoundingMode)RoundingMode.UNNECESSARY);
    private int gcReducingCacheIndex;
    private Long[] gcReducingCache;
    private volatile long nioFileSize;

    public IDFile(File file) throws IOException {
        this(file, false);
        this.nioFileSize = this.nioFile.size();
    }

    public IDFile(File file, boolean forceSync) throws IOException {
        this.nioFile = new NioFile(file);
        this.forceSync = forceSync;
        try {
            if (this.nioFile.size() == 0L) {
                this.nioFile.writeBytes(MAGIC_NUMBER, 0L);
                this.nioFile.writeByte((byte)1, 3L);
                this.nioFile.writeBytes(new byte[]{0, 0, 0, 0}, 4L);
                this.sync();
            } else {
                if (this.nioFile.size() < 8L) {
                    throw new IOException("File too small to be a compatible ID file");
                }
                if (!Arrays.equals(MAGIC_NUMBER, this.nioFile.readBytes(0L, MAGIC_NUMBER.length))) {
                    throw new IOException("File doesn't contain compatible ID records");
                }
                byte version = this.nioFile.readByte((long)MAGIC_NUMBER.length);
                if (version > 1) {
                    throw new IOException("Unable to read ID file; it uses a newer file format");
                }
                if (version != 1) {
                    throw new IOException("Unable to read ID file; invalid file format version: " + version);
                }
            }
        }
        catch (IOException e) {
            this.nioFile.close();
            throw e;
        }
        this.nioFileSize = this.nioFile.size();
    }

    public final File getFile() {
        return this.nioFile.getFile();
    }

    public int getMaxID() throws IOException {
        return (int)(this.nioFileSize / 8L) - 1;
    }

    public int storeOffset(long offset) throws IOException {
        long fileSize = this.nioFileSize;
        this.nioFile.writeLong(offset, fileSize);
        this.nioFileSize += 8L;
        return (int)(fileSize / 8L);
    }

    public void setOffset(int id, long offset) throws IOException {
        assert (id > 0) : "id must be larger than 0, is: " + id;
        this.nioFile.writeLong(offset, 8L * (long)id);
        int cacheLookupIndex = id >> this.cacheLineShift;
        int cacheLineLookupIndex = id % 512;
        Long[] cacheLine = this.getCacheLine(cacheLookupIndex);
        if (cacheLine != null) {
            cacheLine[cacheLineLookupIndex] = offset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOffset(int id) throws IOException {
        assert (id > 0) : "id must be larger than 0, is: " + id;
        int cacheLookupIndex = id >> this.cacheLineShift;
        int cacheLineLookupIndex = id % 512;
        Long[] cacheLine = this.getCacheLine(cacheLookupIndex);
        if (cacheLine != null) {
            return cacheLine[cacheLineLookupIndex];
        }
        if (this.getMaxID() > 512 && id < this.getMaxID() - 512) {
            byte[] bytes = this.nioFile.readBytes(8L * (long)(cacheLookupIndex << this.cacheLineShift), 4096);
            cacheLine = this.convertBytesToLongs(bytes);
            IDFile iDFile = this;
            synchronized (iDFile) {
                if (this.cache.getIfPresent((Object)cacheLineLookupIndex) == null) {
                    this.cache.put((Object)cacheLookupIndex, (Object)cacheLine);
                }
                this.gcReducingCache = cacheLine;
                this.gcReducingCacheIndex = cacheLookupIndex;
            }
            return cacheLine[cacheLineLookupIndex];
        }
        return this.nioFile.readLong(8L * (long)id);
    }

    public void clear() throws IOException {
        this.nioFile.truncate(8L);
        this.nioFileSize = this.nioFile.size();
        this.clearCache();
    }

    public void sync() throws IOException {
        if (this.forceSync) {
            this.nioFile.force(false);
        }
    }

    public void sync(boolean force) throws IOException {
        this.nioFile.force(false);
    }

    @Override
    public void close() throws IOException {
        this.nioFile.close();
    }

    private synchronized Long[] getCacheLine(int cacheLookupIndex) {
        if (cacheLookupIndex == this.gcReducingCacheIndex) {
            return this.gcReducingCache;
        }
        return (Long[])this.cache.getIfPresent((Object)cacheLookupIndex);
    }

    private Long[] convertBytesToLongs(byte[] bytes) {
        Long[] cacheLine = new Long[512];
        int i = 0;
        while (i < bytes.length) {
            long l = (long)(bytes[i + 0] & 0xFF) << 56 | ((long)bytes[i + 1] & 0xFFL) << 48 | ((long)bytes[i + 2] & 0xFFL) << 40 | ((long)bytes[i + 3] & 0xFFL) << 32 | ((long)bytes[i + 4] & 0xFFL) << 24 | ((long)bytes[i + 5] & 0xFFL) << 16 | ((long)bytes[i + 6] & 0xFFL) << 8 | (long)bytes[i + 7] & 0xFFL;
            cacheLine[(int)((long)i / 8L)] = l;
            i = (int)((long)i + 8L);
        }
        return cacheLine;
    }

    public synchronized void clearCache() {
        this.cache.invalidateAll();
        this.gcReducingCacheIndex = -1;
        this.gcReducingCache = null;
    }
}

