/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.string;

import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;

public class StrBefore
implements Function {
    @Override
    public String getURI() {
        return FN.SUBSTRING_BEFORE.toString();
    }

    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length != 2) {
            throw new ValueExprEvaluationException("Incorrect number of arguments for STRBEFORE: " + args.length);
        }
        Value leftArg = args[0];
        Value rightArg = args[1];
        if (leftArg instanceof Literal && rightArg instanceof Literal) {
            Literal leftLit = (Literal)leftArg;
            Literal rightLit = (Literal)rightArg;
            if (QueryEvaluationUtil.compatibleArguments(leftLit, rightLit)) {
                Optional leftLanguage = leftLit.getLanguage();
                IRI leftDt = leftLit.getDatatype();
                String lexicalValue = leftLit.getLabel();
                String substring = rightLit.getLabel();
                int index = lexicalValue.indexOf(substring);
                String substringBefore = "";
                if (index > -1) {
                    substringBefore = lexicalValue.substring(0, index);
                } else {
                    leftLanguage = Optional.empty();
                    leftDt = null;
                }
                if (leftLanguage.isPresent()) {
                    return valueFactory.createLiteral(substringBefore, (String)leftLanguage.get());
                }
                if (leftDt != null) {
                    return valueFactory.createLiteral(substringBefore, leftDt);
                }
                return valueFactory.createLiteral(substringBefore);
            }
            throw new ValueExprEvaluationException("incompatible operands for STRBEFORE: " + leftArg + ", " + rightArg);
        }
        throw new ValueExprEvaluationException("incompatible operands for STRBEFORE: " + leftArg + ", " + rightArg);
    }
}

