/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene.config;

import java.util.Properties;
import java.util.Set;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.sail.config.AbstractDelegatingSailImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;
import org.eclipse.rdf4j.sail.config.SailImplConfig;
import org.eclipse.rdf4j.sail.lucene.config.LuceneSailConfigSchema;

public abstract class AbstractLuceneSailConfig
extends AbstractDelegatingSailImplConfig {
    private String indexDir;
    private Properties parameters = new Properties();

    protected AbstractLuceneSailConfig(String type) {
        super(type);
    }

    protected AbstractLuceneSailConfig(String type, SailImplConfig delegate) {
        super(type, delegate);
    }

    protected AbstractLuceneSailConfig(String type, String luceneDir) {
        super(type);
        this.setIndexDir(luceneDir);
    }

    protected AbstractLuceneSailConfig(String type, String luceneDir, SailImplConfig delegate) {
        super(type, delegate);
        this.setIndexDir(luceneDir);
    }

    public String getIndexDir() {
        return this.indexDir;
    }

    public void setIndexDir(String luceneDir) {
        this.indexDir = luceneDir;
    }

    public String getParameter(String key) {
        return this.parameters.getProperty(key);
    }

    public void setParameter(String key, String value) {
        this.parameters.setProperty(key, value);
    }

    public Set<String> getParameterNames() {
        return this.parameters.stringPropertyNames();
    }

    @Override
    public Resource export(Model m) {
        Resource implNode = super.export(m);
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        m.setNamespace("sl", "http://www.openrdf.org/config/sail/lucene#");
        if (this.indexDir != null) {
            m.add(implNode, LuceneSailConfigSchema.INDEX_DIR, (Value)SimpleValueFactory.getInstance().createLiteral(this.indexDir), new Resource[0]);
        }
        for (String key : this.getParameterNames()) {
            m.add(implNode, vf.createIRI("http://www.openrdf.org/config/sail/lucene#", key), (Value)vf.createLiteral(this.getParameter(key)), new Resource[0]);
        }
        return implNode;
    }

    @Override
    public void parse(Model graph, Resource implNode) throws SailConfigException {
        super.parse(graph, implNode);
        Literal indexDirLit = Models.objectLiteral(graph.getStatements(implNode, LuceneSailConfigSchema.INDEX_DIR, null, new Resource[0])).orElseThrow(() -> new SailConfigException("no value found for " + LuceneSailConfigSchema.INDEX_DIR));
        this.setIndexDir(indexDirLit.getLabel());
        for (Statement stmt : graph.getStatements(implNode, null, null, new Resource[0])) {
            if (!stmt.getPredicate().getNamespace().equals("http://www.openrdf.org/config/sail/lucene#") || !(stmt.getObject() instanceof Literal)) continue;
            String key = stmt.getPredicate().getLocalName();
            this.setParameter(key, stmt.getObject().stringValue());
        }
    }
}

