/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.iterator;

import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloseDependentConnectionIteration<T>
extends AbstractCloseableIteration<T, QueryEvaluationException> {
    private static final Logger log = LoggerFactory.getLogger(CloseDependentConnectionIteration.class);
    protected final CloseableIteration<T, QueryEvaluationException> inner;
    protected final RepositoryConnection dependentConn;

    public CloseDependentConnectionIteration(CloseableIteration<T, QueryEvaluationException> inner, RepositoryConnection dependentConn) {
        this.inner = inner;
        this.dependentConn = dependentConn;
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        try {
            boolean res = this.inner.hasNext();
            if (!res) {
                try {
                    this.dependentConn.close();
                }
                catch (Throwable ignore) {
                    log.trace("Failed to close dependent connection:", ignore);
                }
            }
            return res;
        }
        catch (Throwable t) {
            this.dependentConn.close();
            throw t;
        }
    }

    @Override
    public T next() throws QueryEvaluationException {
        try {
            return (T)this.inner.next();
        }
        catch (Throwable t) {
            this.dependentConn.close();
            throw t;
        }
    }

    @Override
    public void remove() throws QueryEvaluationException {
        this.inner.remove();
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            this.inner.close();
        }
        finally {
            try {
                super.handleClose();
            }
            finally {
                this.dependentConn.close();
            }
        }
    }
}

