/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.console.command;

import org.eclipse.rdf4j.console.ConsoleIO;
import org.eclipse.rdf4j.console.ConsoleState;
import org.eclipse.rdf4j.console.command.ConsoleCommand;
import org.eclipse.rdf4j.repository.Repository;

public class Close
extends ConsoleCommand {
    @Override
    public String getName() {
        return "close";
    }

    @Override
    public String getHelpShort() {
        return "Closes the current repository";
    }

    @Override
    public String getHelpLong() {
        return "Usage:\nclose   Closes the current repository\n";
    }

    public Close(ConsoleIO consoleIO, ConsoleState state) {
        super(consoleIO, state);
    }

    @Override
    public void execute(String ... tokens) {
        if (tokens.length == 1) {
            this.closeRepository(true);
        } else {
            this.writeln(this.getHelpLong());
        }
    }

    protected void closeRepository(boolean verbose) {
        Repository repository = this.state.getRepository();
        if (repository == null) {
            if (verbose) {
                this.writeln("There are no open repositories that can be closed");
            }
        } else {
            this.writeln("Closing repository '" + this.state.getRepositoryID() + "'...");
            this.state.setRepository(null);
            this.state.setRepositoryID(null);
        }
    }
}

