/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.sail.shacl.ConnectionsGroup;
import org.eclipse.rdf4j.sail.shacl.RdfsSubClassOfReasoner;
import org.eclipse.rdf4j.sail.shacl.ShaclSail;
import org.eclipse.rdf4j.sail.shacl.ast.Cache;
import org.eclipse.rdf4j.sail.shacl.ast.Identifiable;
import org.eclipse.rdf4j.sail.shacl.ast.ShaclProperties;
import org.eclipse.rdf4j.sail.shacl.ast.Shape;
import org.eclipse.rdf4j.sail.shacl.ast.SparqlFragment;
import org.eclipse.rdf4j.sail.shacl.ast.StatementMatcher;
import org.eclipse.rdf4j.sail.shacl.ast.ValidationApproach;
import org.eclipse.rdf4j.sail.shacl.ast.constraintcomponents.ConstraintComponent;
import org.eclipse.rdf4j.sail.shacl.ast.paths.Path;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.EmptyNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNodeProvider;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ShiftToNodeShape;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.TargetChainPopper;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.UnionNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.Unique;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationReportNode;
import org.eclipse.rdf4j.sail.shacl.ast.targets.TargetChain;
import org.eclipse.rdf4j.sail.shacl.results.ValidationResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyShape
extends Shape
implements ConstraintComponent,
Identifiable {
    private static final Logger logger = LoggerFactory.getLogger(PropertyShape.class);
    List<String> name;
    List<String> description;
    Object defaultValue;
    Object group;
    Path path;

    public PropertyShape() {
    }

    public PropertyShape(PropertyShape propertyShape) {
        super(propertyShape);
        this.name = propertyShape.name;
        this.description = propertyShape.description;
        this.defaultValue = propertyShape.defaultValue;
        this.group = propertyShape.group;
        this.path = propertyShape.path;
    }

    public static PropertyShape getInstance(ShaclProperties properties, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        Shape shape = cache.get(properties.getId());
        if (shape == null) {
            shape = new PropertyShape();
            cache.put(properties.getId(), shape);
            shape.populate(properties, connection, cache, shaclSail);
        }
        if (shape.constraintComponents.isEmpty()) {
            shape.deactivated = true;
        }
        return (PropertyShape)shape;
    }

    @Override
    public void populate(ShaclProperties properties, RepositoryConnection connection, Cache cache, ShaclSail shaclSail) {
        super.populate(properties, connection, cache, shaclSail);
        this.path = Path.buildPath(connection, properties.getPath());
        if (this.path == null) {
            throw new IllegalStateException(properties.getId() + " is a sh:PropertyShape without a sh:path!");
        }
        this.constraintComponents = this.getConstraintComponents(properties, connection, cache, shaclSail);
    }

    @Override
    protected Shape shallowClone() {
        return new PropertyShape(this);
    }

    @Override
    public void toModel(Resource subject, IRI predicate, Model model, Set<Resource> cycleDetection, Set<Resource> rdfListDedupe) {
        super.toModel(subject, predicate, model, cycleDetection, rdfListDedupe);
        model.add(this.getId(), RDF.TYPE, (Value)SHACL.PROPERTY_SHAPE, new Resource[0]);
        if (subject != null) {
            if (predicate == null) {
                model.add(subject, SHACL.PROPERTY, (Value)this.getId(), new Resource[0]);
            } else {
                model.add(subject, predicate, (Value)this.getId(), new Resource[0]);
            }
        }
        model.add(this.getId(), SHACL.PATH, (Value)this.path.getId(), new Resource[0]);
        this.path.toModel(this.path.getId(), null, model, cycleDetection, rdfListDedupe);
        if (cycleDetection.contains(this.getId())) {
            return;
        }
        cycleDetection.add(this.getId());
        this.constraintComponents.forEach(c -> c.toModel(this.getId(), null, model, cycleDetection, rdfListDedupe));
    }

    @Override
    public void setTargetChain(TargetChain targetChain) {
        super.setTargetChain(targetChain.add(this.path));
    }

    @Override
    public PlanNode generateSparqlValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, boolean negatePlan, boolean negateChildren, ConstraintComponent.Scope scope) {
        if (this.isDeactivated()) {
            return new EmptyNode();
        }
        PlanNode union = new EmptyNode();
        for (ConstraintComponent constraintComponent : this.constraintComponents) {
            PlanNode validationPlanNode = constraintComponent.generateSparqlValidationPlan(connectionsGroup, logValidationPlans, negatePlan, false, ConstraintComponent.Scope.propertyShape);
            if (!(constraintComponent instanceof PropertyShape)) {
                validationPlanNode = new ValidationReportNode(validationPlanNode, t -> new ValidationResult(t.getActiveTarget(), t.getValue(), this, constraintComponent.getConstraintComponent(), this.getSeverity(), t.getScope()));
            }
            validationPlanNode = new Unique(new TargetChainPopper(validationPlanNode), true);
            union = new UnionNode(union, validationPlanNode);
        }
        return union;
    }

    @Override
    public PlanNode generateTransactionalValidationPlan(ConnectionsGroup connectionsGroup, boolean logValidationPlans, PlanNodeProvider overrideTargetNode, ConstraintComponent.Scope scope) {
        if (this.isDeactivated()) {
            return new EmptyNode();
        }
        PlanNode union = new EmptyNode();
        for (ConstraintComponent constraintComponent : this.constraintComponents) {
            if (!this.getPath().isSupported()) {
                logger.error("Unsupported path detected. Shape ignored! \n" + this.toString());
                continue;
            }
            PlanNode validationPlanNode = constraintComponent.generateTransactionalValidationPlan(connectionsGroup, logValidationPlans, overrideTargetNode, ConstraintComponent.Scope.propertyShape);
            if (!(constraintComponent instanceof PropertyShape)) {
                validationPlanNode = new ValidationReportNode(validationPlanNode, t -> new ValidationResult(t.getActiveTarget(), t.getValue(), this, constraintComponent.getConstraintComponent(), this.getSeverity(), t.getScope()));
            }
            validationPlanNode = scope == ConstraintComponent.Scope.propertyShape ? new Unique(new TargetChainPopper(validationPlanNode), true) : new ShiftToNodeShape(validationPlanNode);
            union = new UnionNode(union, validationPlanNode);
        }
        return union;
    }

    @Override
    public PlanNode getAllTargetsPlan(ConnectionsGroup connectionsGroup, ConstraintComponent.Scope scope) {
        PlanNode planNode = this.constraintComponents.stream().map(c -> c.getAllTargetsPlan(connectionsGroup, ConstraintComponent.Scope.propertyShape)).reduce((xva$0, xva$1) -> new UnionNode((PlanNode)xva$0, (PlanNode)xva$1)).orElse(new EmptyNode());
        planNode = new UnionNode(planNode, this.getTargetChain().getEffectiveTarget("_target", ConstraintComponent.Scope.propertyShape, connectionsGroup.getRdfsSubClassOfReasoner()).getPlanNode(connectionsGroup, ConstraintComponent.Scope.propertyShape, true));
        planNode = scope == ConstraintComponent.Scope.propertyShape ? new Unique(new TargetChainPopper(planNode), true) : new ShiftToNodeShape(planNode);
        planNode = new Unique(planNode, false);
        return planNode;
    }

    @Override
    public ValidationApproach getPreferedValidationApproach() {
        return this.constraintComponents.stream().map(ConstraintComponent::getPreferedValidationApproach).reduce(ValidationApproach::reduce).orElse(ValidationApproach.Transactional);
    }

    @Override
    public Set<ValidationApproach> getSupportedValidationApproaches() {
        return this.constraintComponents.stream().map(ConstraintComponent::getSupportedValidationApproaches).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public ConstraintComponent deepClone() {
        PropertyShape nodeShape = new PropertyShape(this);
        nodeShape.constraintComponents = this.constraintComponents.stream().map(ConstraintComponent::deepClone).collect(Collectors.toList());
        return nodeShape;
    }

    @Override
    public SparqlFragment buildSparqlValidNodes_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope) {
        StatementMatcher.Variable someObject = new StatementMatcher.Variable(UUID.randomUUID().toString().replace("-", ""));
        boolean isFilterCondition = this.constraintComponents.stream().map(o -> o.buildSparqlValidNodes_rsx_targetShape(object, someObject, rdfsSubClassOfReasoner, ConstraintComponent.Scope.propertyShape)).map(SparqlFragment::isFilterCondition).findFirst().orElse(false);
        if (isFilterCondition) {
            String sparql = this.constraintComponents.stream().map(c -> c.buildSparqlValidNodes_rsx_targetShape(object, someObject, rdfsSubClassOfReasoner, ConstraintComponent.Scope.propertyShape)).map(SparqlFragment::getFragment).collect(Collectors.joining(" ) && ( ", "( ", " )"));
            return SparqlFragment.filterCondition(sparql);
        }
        String sparql = this.constraintComponents.stream().map(c -> c.buildSparqlValidNodes_rsx_targetShape(object, someObject, rdfsSubClassOfReasoner, ConstraintComponent.Scope.propertyShape)).map(SparqlFragment::getFragment).reduce((a, b) -> a + "\n" + b).orElse("");
        return SparqlFragment.bgp(sparql);
    }

    @Override
    public Stream<StatementMatcher> getStatementMatchers_rsx_targetShape(StatementMatcher.Variable subject, StatementMatcher.Variable object, RdfsSubClassOfReasoner rdfsSubClassOfReasoner, ConstraintComponent.Scope scope) {
        StatementMatcher.Variable someObject = new StatementMatcher.Variable(UUID.randomUUID().toString().replace("-", ""));
        return this.constraintComponents.stream().flatMap(c -> c.getStatementMatchers_rsx_targetShape(object, someObject, rdfsSubClassOfReasoner, ConstraintComponent.Scope.propertyShape));
    }
}

