/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.ast.planNodes;

import java.util.Objects;
import java.util.function.Function;
import org.apache.commons.text.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.parser.ParsedQuery;
import org.eclipse.rdf4j.query.parser.QueryParserFactory;
import org.eclipse.rdf4j.query.parser.QueryParserRegistry;
import org.eclipse.rdf4j.sail.SailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.memory.MemoryStoreConnection;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.LoggingCloseableIteration;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationExecutionLogger;
import org.eclipse.rdf4j.sail.shacl.ast.planNodes.ValidationTuple;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Select
implements PlanNode {
    private static final Logger logger = LoggerFactory.getLogger(Select.class);
    private final SailConnection connection;
    private final Function<BindingSet, ValidationTuple> mapper;
    private final String query;
    private final boolean sorted;
    private boolean printed = false;
    private ValidationExecutionLogger validationExecutionLogger;

    public Select(SailConnection connection, String query, String orderBy, Function<BindingSet, ValidationTuple> mapper) {
        this.connection = connection;
        this.mapper = mapper;
        if (query.trim().equals("")) {
            logger.error("Query is empty", new Throwable("This throwable is just to log the stack trace"));
            query = "?a <http://fjiewojfiwejfioewhgurh8924y.com/f289h8fhn> ?c. \nFILTER (NOT EXISTS {?a <http://fjiewojfiwejfioewhgurh8924y.com/f289h8fhn> ?c}) \n";
        }
        this.sorted = orderBy != null;
        this.query = "select * where {\n" + query + "\n} " + (orderBy != null ? "order by " + orderBy : "");
    }

    @Override
    public CloseableIteration<? extends ValidationTuple, SailException> iterator() {
        return new LoggingCloseableIteration(this, this.validationExecutionLogger){
            CloseableIteration<? extends BindingSet, QueryEvaluationException> bindingSet;
            {
                this.bindingSet = null;
            }

            private void init() {
                if (this.bindingSet != null) {
                    return;
                }
                QueryParserFactory queryParserFactory = (QueryParserFactory)QueryParserRegistry.getInstance().get((Object)QueryLanguage.SPARQL).get();
                try {
                    ParsedQuery parsedQuery = queryParserFactory.getParser().parseQuery(Select.this.query, null);
                    this.bindingSet = Select.this.connection.evaluate(parsedQuery.getTupleExpr(), parsedQuery.getDataset(), (BindingSet)new MapBindingSet(), true);
                }
                catch (MalformedQueryException e) {
                    logger.error("Malformed query: \n{}", (Object)Select.this.query);
                    throw e;
                }
            }

            public void close() throws SailException {
                if (this.bindingSet != null) {
                    this.bindingSet.close();
                }
            }

            @Override
            boolean localHasNext() throws SailException {
                this.init();
                return this.bindingSet.hasNext();
            }

            @Override
            ValidationTuple loggingNext() throws SailException {
                this.init();
                return (ValidationTuple)Select.this.mapper.apply(this.bindingSet.next());
            }

            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return 0;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        if (this.connection instanceof MemoryStoreConnection) {
            stringBuilder.append(System.identityHashCode(((MemoryStoreConnection)this.connection).getSail()) + " -> " + this.getId()).append("\n");
        } else {
            stringBuilder.append(System.identityHashCode(this.connection) + " -> " + this.getId()).append("\n");
        }
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    public String toString() {
        return "Select{query='" + this.query.replace("\n", "  ") + '\'' + '}';
    }

    @Override
    public void receiveLogger(ValidationExecutionLogger validationExecutionLogger) {
        this.validationExecutionLogger = validationExecutionLogger;
    }

    @Override
    public boolean producesSorted() {
        return this.sorted;
    }

    @Override
    public boolean requiresSorted() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Select select = (Select)o;
        return this.connection.equals(select.connection) && this.mapper.equals(select.mapper) && this.query.equals(select.query);
    }

    public int hashCode() {
        return Objects.hash(this.connection, this.mapper, this.query);
    }
}

