/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sparqlbuilder.rdf;

import java.util.Optional;
import org.eclipse.rdf4j.sparqlbuilder.rdf.Iri;
import org.eclipse.rdf4j.sparqlbuilder.rdf.RdfValue;
import org.eclipse.rdf4j.sparqlbuilder.util.SparqlBuilderUtils;

public abstract class RdfLiteral<T>
implements RdfValue {
    protected T value;

    private RdfLiteral(T value) {
        this.value = value;
    }

    @Override
    public String getQueryString() {
        return String.valueOf(this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdfLiteral)) {
            return false;
        }
        RdfLiteral other = (RdfLiteral)obj;
        if (this.value == null) {
            return other.value == null;
        }
        return this.value.equals(other.value);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public static class BooleanLiteral
    extends RdfLiteral<Boolean> {
        BooleanLiteral(Boolean boolValue) {
            super(boolValue);
        }
    }

    public static class NumericLiteral
    extends RdfLiteral<Number> {
        NumericLiteral(Number numbervalue) {
            super(numbervalue);
        }
    }

    public static class StringLiteral
    extends RdfLiteral<String> {
        private static final String DATATYPE_SPECIFIER = "^^";
        private static final String LANG_TAG_SPECIFIER = "@";
        private Optional<Iri> dataType = Optional.empty();
        private Optional<String> languageTag = Optional.empty();

        StringLiteral(String stringValue) {
            super(stringValue);
        }

        StringLiteral(String stringValue, Iri dataType) {
            super(stringValue);
            this.ofType(dataType);
        }

        StringLiteral(String stringValue, String languageTag) {
            super(stringValue);
            this.ofLanguage(languageTag);
        }

        public StringLiteral ofType(Iri dataType) {
            this.dataType = Optional.ofNullable(dataType);
            return this;
        }

        public StringLiteral ofLanguage(String languageTag) {
            this.languageTag = Optional.ofNullable(languageTag);
            return this;
        }

        @Override
        public String getQueryString() {
            StringBuilder literal = new StringBuilder();
            if (((String)this.value).contains("'") || ((String)this.value).contains("\"")) {
                literal.append(SparqlBuilderUtils.getLongQuotedString((String)this.value));
            } else {
                literal.append(SparqlBuilderUtils.getQuotedString((String)this.value));
            }
            SparqlBuilderUtils.appendQueryElementIfPresent(this.dataType, literal, DATATYPE_SPECIFIER, null);
            SparqlBuilderUtils.appendStringIfPresent(this.languageTag, literal, LANG_TAG_SPECIFIER, null);
            return literal.toString();
        }
    }
}

