/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;

public class Extension
extends UnaryTupleOperator {
    private List<ExtensionElem> elements = new ArrayList<ExtensionElem>();

    public Extension() {
    }

    public Extension(TupleExpr arg) {
        super(arg);
    }

    public Extension(TupleExpr arg, ExtensionElem ... elements) {
        this(arg);
        this.addElements(elements);
    }

    public Extension(TupleExpr arg, Iterable<ExtensionElem> elements) {
        this(arg);
        this.addElements(elements);
    }

    public List<ExtensionElem> getElements() {
        return this.elements;
    }

    public void setElements(Iterable<ExtensionElem> elements) {
        this.elements.clear();
        this.addElements(elements);
    }

    public void addElements(ExtensionElem ... elements) {
        for (ExtensionElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElements(Iterable<ExtensionElem> elements) {
        for (ExtensionElem pe : elements) {
            this.addElement(pe);
        }
    }

    public void addElement(ExtensionElem pe) {
        this.elements.add(pe);
        pe.setParentNode(this);
    }

    @Override
    public Set<String> getBindingNames() {
        LinkedHashSet<String> bindingNames = new LinkedHashSet<String>(this.arg.getBindingNames());
        for (ExtensionElem pe : this.elements) {
            bindingNames.add(pe.getName());
        }
        return bindingNames;
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meet(this);
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        for (ExtensionElem elem : this.elements) {
            elem.visit(visitor);
        }
        super.visitChildren(visitor);
    }

    @Override
    public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
        if (this.replaceNodeInList(this.elements, current, replacement)) {
            return;
        }
        super.replaceChildNode(current, replacement);
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof Extension && super.equals(other)) {
            Extension o = (Extension)other;
            return this.elements.equals(o.getElements());
        }
        return false;
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.elements.hashCode();
    }

    @Override
    public Extension clone() {
        Extension clone = (Extension)super.clone();
        clone.elements = new ArrayList<ExtensionElem>(this.getElements().size());
        for (ExtensionElem elem : this.getElements()) {
            clone.addElement(elem.clone());
        }
        return clone;
    }
}

