/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPIN;

final class SpinWellKnownVars {
    private static final ValueFactory valueFactory = SimpleValueFactory.getInstance();
    static final SpinWellKnownVars INSTANCE = new SpinWellKnownVars();
    private final BiMap<String, IRI> stringToUri = HashBiMap.create();
    private final BiMap<IRI, String> uriToString = this.stringToUri.inverse();

    public SpinWellKnownVars() {
        this.stringToUri.put((Object)"this", (Object)SPIN.THIS_CONTEXT_INSTANCE);
        this.stringToUri.put((Object)"arg1", (Object)SPIN.ARG1_INSTANCE);
        this.stringToUri.put((Object)"arg2", (Object)SPIN.ARG2_INSTANCE);
        this.stringToUri.put((Object)"arg3", (Object)SPIN.ARG3_INSTANCE);
        this.stringToUri.put((Object)"arg4", (Object)SPIN.ARG4_INSTANCE);
        this.stringToUri.put((Object)"arg5", (Object)SPIN.ARG5_INSTANCE);
    }

    public IRI getURI(String name) {
        IRI IRI2 = (IRI)this.stringToUri.get((Object)name);
        if (IRI2 == null && name.startsWith("arg")) {
            try {
                Integer.parseInt(name.substring("arg".length()));
                IRI2 = valueFactory.createIRI("http://spinrdf.org/spin#", "_" + name);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IRI2;
    }

    public String getName(IRI IRI2) {
        String name = (String)this.uriToString.get((Object)IRI2);
        if (name == null && "http://spinrdf.org/spin#".equals(IRI2.getNamespace()) && IRI2.getLocalName().startsWith("_arg")) {
            String lname = IRI2.getLocalName();
            try {
                Integer.parseInt(lname.substring("_arg".length()));
                name = lname.substring(1);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return name;
    }
}

