/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.impl.SimpleLiteral;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class DecimalLiteral
extends SimpleLiteral {
    private static final long serialVersionUID = -3310213093222314380L;
    private final BigDecimal value;

    protected DecimalLiteral(BigDecimal value) {
        this(value, XSD.DECIMAL);
    }

    protected DecimalLiteral(BigDecimal value, IRI datatype) {
        super(value.toPlainString(), datatype);
        this.value = value;
    }

    @Override
    public byte byteValue() {
        return this.value.byteValue();
    }

    @Override
    public short shortValue() {
        return this.value.shortValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.value.doubleValue();
    }

    @Override
    public BigInteger integerValue() {
        return this.value.toBigInteger();
    }

    @Override
    public BigDecimal decimalValue() {
        return this.value;
    }
}

