/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.SHACL;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.sail.NotifyingSail;
import org.eclipse.rdf4j.sail.NotifyingSailConnection;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.helpers.NotifyingSailWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.AST.NodeShape;
import org.eclipse.rdf4j.sail.shacl.ShaclSailConnection;
import org.eclipse.rdf4j.sail.shacl.planNodes.LoggingNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShaclSail
extends NotifyingSailWrapper {
    private static final Logger logger = LoggerFactory.getLogger(ShaclSail.class);
    private List<NodeShape> nodeShapes = Collections.emptyList();
    private static String SH_OR_UPDATE_QUERY;
    private static String SH_OR_NODE_SHAPE_UPDATE_QUERY;
    private static String IMPLICIT_TARGET_CLASS_NODE_SHAPE;
    private static String IMPLICIT_TARGET_CLASS_PROPERTY_SHAPE;
    private SailRepository shapesRepo;
    private boolean parallelValidation = false;
    private boolean undefinedTargetValidatesAllSubjects = false;
    private boolean logValidationPlans = false;
    private boolean logValidationViolations = false;
    private boolean ignoreNoShapesLoadedException = false;
    private boolean validationEnabled = true;
    private boolean cacheSelectNodes = true;
    private boolean rdfsSubClassReasoning = true;
    private boolean initializing = false;

    private static String resourceAsString(String s) throws IOException {
        return IOUtils.toString((InputStream)ShaclSail.class.getClassLoader().getResourceAsStream(s), (String)"UTF-8");
    }

    public ShaclSail(NotifyingSail baseSail) {
        super(baseSail);
    }

    public ShaclSail() {
    }

    public static List<IRI> getSupportedShaclPredicates() {
        return Arrays.asList(SHACL.TARGET_CLASS, SHACL.PATH, SHACL.PROPERTY, SHACL.OR, SHACL.MIN_COUNT, SHACL.MAX_COUNT, SHACL.MIN_LENGTH, SHACL.MAX_LENGTH, SHACL.PATTERN, SHACL.FLAGS, SHACL.NODE_KIND_PROP, SHACL.LANGUAGE_IN, SHACL.DATATYPE, SHACL.MIN_EXCLUSIVE, SHACL.MIN_INCLUSIVE, SHACL.MAX_EXCLUSIVE, SHACL.MAX_INCLUSIVE, SHACL.CLASS, SHACL.TARGET_NODE);
    }

    @Override
    public void initialize() throws SailException {
        this.initializing = true;
        super.initialize();
        if (this.getDataDir() != null) {
            if (this.parallelValidation) {
                logger.info("Automatically disabled parallel SHACL validation because persistent base sail was detected! Re-enable by calling setParallelValidation(true) after calling init() / initialize().");
            }
            this.setParallelValidation(false);
        }
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        if (super.getBaseSail().getDataDir() != null) {
            String path = super.getBaseSail().getDataDir().getPath();
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
            path = path + "-shapes-graph/";
            this.shapesRepo = new SailRepository(new MemoryStore(new File(path)));
        } else {
            this.shapesRepo = new SailRepository(new MemoryStore());
        }
        this.shapesRepo.init();
        try (SailRepositoryConnection shapesRepoConnection = this.shapesRepo.getConnection();){
            shapesRepoConnection.begin((IsolationLevel)IsolationLevels.NONE);
            this.refreshShapes(shapesRepoConnection);
            shapesRepoConnection.commit();
        }
        this.initializing = false;
    }

    synchronized List<NodeShape> refreshShapes(SailRepositoryConnection shapesRepoConnection) throws SailException {
        if (!this.initializing) {
            try (SailRepositoryConnection beforeCommitConnection = this.shapesRepo.getConnection();){
                boolean empty;
                boolean bl = empty = !beforeCommitConnection.hasStatement(null, null, null, false, new Resource[0]);
                if (!empty) {
                    throw new IllegalStateException("ShaclSail does not support modifying shapes that are already loaded or loading more shapes");
                }
            }
        }
        this.runInferencingSparqlQueries(shapesRepoConnection);
        this.nodeShapes = NodeShape.Factory.getShapes(shapesRepoConnection, this);
        return this.nodeShapes;
    }

    @Override
    public void shutDown() throws SailException {
        if (this.shapesRepo != null) {
            this.shapesRepo.shutDown();
            this.shapesRepo = null;
        }
        super.shutDown();
    }

    @Override
    public NotifyingSailConnection getConnection() throws SailException {
        return new ShaclSailConnection(this, super.getConnection(), super.getConnection(), this.shapesRepo.getConnection());
    }

    public void disableValidation() {
        this.validationEnabled = false;
    }

    public void enableValidation() {
        this.validationEnabled = true;
    }

    public boolean isValidationEnabled() {
        return this.validationEnabled;
    }

    public boolean isLogValidationPlans() {
        return this.logValidationPlans;
    }

    public boolean isIgnoreNoShapesLoadedException() {
        return this.ignoreNoShapesLoadedException;
    }

    public void setIgnoreNoShapesLoadedException(boolean ignoreNoShapesLoadedException) {
        this.ignoreNoShapesLoadedException = ignoreNoShapesLoadedException;
    }

    public void setLogValidationPlans(boolean logValidationPlans) {
        this.logValidationPlans = logValidationPlans;
    }

    List<NodeShape> getNodeShapes() {
        return this.nodeShapes;
    }

    private void runInferencingSparqlQueries(SailRepositoryConnection shaclSailConnection) {
        long prevSize;
        long currentSize = shaclSailConnection.size(new Resource[0]);
        do {
            prevSize = currentSize;
            shaclSailConnection.prepareUpdate(IMPLICIT_TARGET_CLASS_PROPERTY_SHAPE).execute();
            shaclSailConnection.prepareUpdate(IMPLICIT_TARGET_CLASS_NODE_SHAPE).execute();
            shaclSailConnection.prepareUpdate(SH_OR_UPDATE_QUERY).execute();
            shaclSailConnection.prepareUpdate(SH_OR_NODE_SHAPE_UPDATE_QUERY).execute();
        } while (prevSize != (currentSize = shaclSailConnection.size(new Resource[0])));
    }

    public void setGlobalLogValidationExecution(boolean loggingEnabled) {
        LoggingNode.loggingEnabled = loggingEnabled;
    }

    public boolean isGlobalLogValidationExecution() {
        return LoggingNode.loggingEnabled;
    }

    public boolean isLogValidationViolations() {
        return this.logValidationViolations;
    }

    public void setLogValidationViolations(boolean logValidationViolations) {
        this.logValidationViolations = logValidationViolations;
    }

    public void setUndefinedTargetValidatesAllSubjects(boolean undefinedTargetValidatesAllSubjects) {
        this.undefinedTargetValidatesAllSubjects = undefinedTargetValidatesAllSubjects;
    }

    public boolean isUndefinedTargetValidatesAllSubjects() {
        return this.undefinedTargetValidatesAllSubjects;
    }

    public boolean isParallelValidation() {
        return this.parallelValidation;
    }

    public void setParallelValidation(boolean parallelValidation) {
        if (parallelValidation) {
            logger.warn("Parallel SHACL validation enabled. This is an experimental feature and may cause deadlocks!");
        }
        this.parallelValidation = parallelValidation;
    }

    public boolean isCacheSelectNodes() {
        return this.cacheSelectNodes;
    }

    public void setCacheSelectNodes(boolean cacheSelectNodes) {
        this.cacheSelectNodes = cacheSelectNodes;
    }

    public boolean isRdfsSubClassReasoning() {
        return this.rdfsSubClassReasoning;
    }

    public void setRdfsSubClassReasoning(boolean rdfsSubClassReasoning) {
        this.rdfsSubClassReasoning = rdfsSubClassReasoning;
    }

    static {
        try {
            SH_OR_UPDATE_QUERY = ShaclSail.resourceAsString("shacl-sparql-inference/sh_or.rq");
            SH_OR_NODE_SHAPE_UPDATE_QUERY = ShaclSail.resourceAsString("shacl-sparql-inference/sh_or_node_shape.rq");
            IMPLICIT_TARGET_CLASS_NODE_SHAPE = ShaclSail.resourceAsString("shacl-sparql-inference/implicitTargetClassNodeShape.rq");
            IMPLICIT_TARGET_CLASS_PROPERTY_SHAPE = ShaclSail.resourceAsString("shacl-sparql-inference/implicitTargetClassPropertyShape.rq");
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }
}

