/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.FN;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;

public class Concat
implements Function {
    @Override
    public String getURI() {
        return FN.CONCAT.toString();
    }

    @Override
    public Literal evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        if (args.length == 0) {
            throw new ValueExprEvaluationException("CONCAT requires at least 1 argument, got " + args.length);
        }
        StringBuilder concatBuilder = new StringBuilder();
        String languageTag = null;
        boolean useLanguageTag = true;
        boolean useDatatype = true;
        for (Value arg : args) {
            Literal lit;
            if (arg instanceof Literal) {
                lit = (Literal)arg;
                if (useLanguageTag && Literals.isLanguageLiteral(lit)) {
                    if (languageTag == null) {
                        languageTag = lit.getLanguage().get();
                    } else if (!languageTag.equals(lit.getLanguage().get())) {
                        languageTag = null;
                        useLanguageTag = false;
                    }
                } else {
                    useLanguageTag = false;
                }
                if (lit.getDatatype() == null) {
                    useDatatype = false;
                }
            } else {
                throw new ValueExprEvaluationException("unexpected argument type for concat operator: " + arg);
            }
            concatBuilder.append(lit.getLabel());
        }
        Literal result = null;
        result = useDatatype ? valueFactory.createLiteral(concatBuilder.toString(), XMLSchema.STRING) : (useLanguageTag ? valueFactory.createLiteral(concatBuilder.toString(), languageTag) : valueFactory.createLiteral(concatBuilder.toString()));
        return result;
    }
}

