/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.shacl.planNodes;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.shacl.planNodes.IteratorData;
import org.eclipse.rdf4j.sail.shacl.planNodes.PlanNode;
import org.eclipse.rdf4j.sail.shacl.planNodes.Tuple;

public class UnionNode
implements PlanNode {
    private PlanNode[] nodes;
    private boolean printed = false;

    public UnionNode(PlanNode ... nodes) {
        this.nodes = nodes;
    }

    @Override
    public CloseableIteration<Tuple, SailException> iterator() {
        return new CloseableIteration<Tuple, SailException>(){
            List<CloseableIteration<Tuple, SailException>> iterators;
            Tuple[] peekList;
            Tuple next;
            {
                this.iterators = Arrays.stream(UnionNode.this.nodes).map(PlanNode::iterator).collect(Collectors.toList());
                this.peekList = new Tuple[UnionNode.this.nodes.length];
            }

            private void calculateNext() {
                if (this.next != null) {
                    return;
                }
                for (int i = 0; i < this.peekList.length; ++i) {
                    CloseableIteration<Tuple, SailException> iterator;
                    if (this.peekList[i] != null || !(iterator = this.iterators.get(i)).hasNext()) continue;
                    this.peekList[i] = (Tuple)iterator.next();
                }
                Tuple sortedFirst = null;
                int sortedFirstIndex = -1;
                for (int i = 0; i < this.peekList.length; ++i) {
                    if (this.peekList[i] == null) continue;
                    if (sortedFirst == null) {
                        sortedFirst = this.peekList[i];
                        sortedFirstIndex = i;
                        continue;
                    }
                    if (this.peekList[i].compareTo(sortedFirst) >= 0) continue;
                    sortedFirst = this.peekList[i];
                    sortedFirstIndex = i;
                }
                if (sortedFirstIndex >= 0) {
                    this.peekList[sortedFirstIndex] = null;
                }
                this.next = sortedFirst;
            }

            @Override
            public void close() throws SailException {
                this.iterators.forEach(CloseableIteration::close);
            }

            @Override
            public boolean hasNext() throws SailException {
                this.calculateNext();
                return this.next != null;
            }

            @Override
            public Tuple next() throws SailException {
                this.calculateNext();
                Tuple temp = this.next;
                this.next = null;
                return temp;
            }

            @Override
            public void remove() throws SailException {
            }
        };
    }

    @Override
    public int depth() {
        return Arrays.stream(this.nodes).mapToInt(PlanNode::depth).max().orElse(0) + 1;
    }

    @Override
    public void getPlanAsGraphvizDot(StringBuilder stringBuilder) {
        if (this.printed) {
            return;
        }
        this.printed = true;
        stringBuilder.append(this.getId() + " [label=\"" + StringEscapeUtils.escapeJava((String)this.toString()) + "\"];").append("\n");
        for (PlanNode node : this.nodes) {
            stringBuilder.append(node.getId() + " -> " + this.getId()).append("\n");
            node.getPlanAsGraphvizDot(stringBuilder);
        }
    }

    public String toString() {
        return "UnionNode";
    }

    @Override
    public String getId() {
        return System.identityHashCode(this) + "";
    }

    @Override
    public IteratorData getIteratorDataType() {
        List collect = Arrays.stream(this.nodes).map(PlanNode::getIteratorDataType).distinct().collect(Collectors.toList());
        if (collect.size() == 1) {
            return (IteratorData)((Object)collect.get(0));
        }
        throw new IllegalStateException("Not implemented support for when union node operates on nodes with different iterator data types");
    }
}

