/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring.delete;

import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.DeleteProcessor;
import org.eclipse.ltk.core.refactoring.participants.DeleteRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.rcptt.core.tags.Tag;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.ui.refactoring.delete.DeleteTagProcessor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;

public class DeleteTagWizard
extends RefactoringWizard {
    public DeleteTagWizard(List<Tag> tags) {
        super((Refactoring)new DeleteRefactoring((DeleteProcessor)new DeleteTagProcessor(tags)), 4);
        this.setDefaultPageTitle(Messages.DeleteTagWizard_PageTitle);
        this.setWindowTitle(Messages.DeleteTagWizard_WindowTitle);
    }

    protected void addUserInputPages() {
        DeleteTagProcessor processor = (DeleteTagProcessor)((Object)this.getRefactoring().getAdapter(DeleteTagProcessor.class));
        this.addPage((IWizardPage)new DeleteTagPage(processor));
    }

    private static final class DeleteTagPage
    extends UserInputWizardPage {
        private final DeleteTagProcessor processor;

        public DeleteTagPage(DeleteTagProcessor processor) {
            super("RenameTagRefactoringInputPage");
            this.processor = processor;
        }

        public void createControl(Composite parent) {
            String message;
            this.initializeDialogUnits((Control)parent);
            Point defaultSpacing = LayoutConstants.getSpacing();
            Composite composite = new Composite(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).spacing(defaultSpacing.x * 2, defaultSpacing.y).applyTo(composite);
            composite.setFont(parent.getFont());
            Display display = parent.getDisplay();
            Image image = new Image((Device)display, display.getSystemImage(4), 0);
            Label imageLabel = new Label(composite, 0);
            imageLabel.setBackground(image.getBackground());
            imageLabel.setImage(image);
            GridDataFactory.swtDefaults().align(0x1000000, 1).span(1, 2).applyTo((Control)imageLabel);
            List<Tag> tags = this.processor.getTags();
            if (tags.size() == 1) {
                Tag tag = tags.get(0);
                message = Messages.bind((String)Messages.DeleteTagWizard_OneTagMsg, (Object)tag.getPath());
            } else {
                message = Messages.bind((String)Messages.DeleteTagWizard_ManyTagsMsg, (Object)tags.size());
            }
            Label label = new Label(composite, 64);
            label.setFont(parent.getFont());
            label.setText(message);
            GridData gridData = new GridData(4, 4, true, false);
            gridData.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)gridData);
            this.setControl((Control)composite);
        }
    }
}

