/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.replace;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.ecl.context.EclContext;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.search.Q7SearchQuery;
import org.eclipse.rcptt.search.Q7SearchResult;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.part.FileEditorInput;

public class ReplaceSearchResult {
    public static void ReplaceInBackground(Q7SearchResult searchResult, String replaceString, IWorkbenchPage page) {
        InternalReplaceJob replaceJob = new InternalReplaceJob(searchResult, replaceString, page);
        replaceJob.setUser(true);
        replaceJob.schedule();
    }

    public static void Replace(Q7SearchResult searchResult, String replaceString, IWorkbenchPage page, IProgressMonitor monitor) throws IOException {
        try {
            monitor.beginTask(ReplaceSearchResult.getReplaceHint(searchResult), searchResult.getMatchCount());
            int scenarioPart = ((Q7SearchQuery)searchResult.getQuery()).getSearchFor();
            String searchPattern = ((Q7SearchQuery)searchResult.getQuery()).getSearchString();
            boolean IsRegEx = ((Q7SearchQuery)searchResult.getQuery()).isRegexSearch();
            Shell shell = page.getWorkbenchWindow().getShell();
            WriteAccessChecker writeAccessChecker = new WriteAccessChecker(shell, false);
            if (!writeAccessChecker.makeResourceWritable((IResource[])ReplaceSearchResult.foundFiles(searchResult))) {
                return;
            }
            try {
                Object[] objectArray = searchResult.getElements();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object element = objectArray[n2];
                    IFile file = searchResult.getFile(element);
                    if (file != null) {
                        try {
                            EclContainer scenario = ReplaceSearchResult.adaptToEclContainer((IQ7NamedElement)RcpttCore.create((IResource)file));
                            String originalText = ReplaceSearchResult.getOriginalText(scenario, scenarioPart);
                            StringBuilder strBuilder = new StringBuilder();
                            int currentOffset = 0;
                            Match[] matchArray = searchResult.getMatches(element);
                            int n3 = matchArray.length;
                            int n4 = 0;
                            while (n4 < n3) {
                                Match match = matchArray[n4];
                                String beforeMatch = originalText.substring(currentOffset, match.getOffset());
                                strBuilder.append(beforeMatch);
                                String replacedStr = replaceString;
                                if (IsRegEx) {
                                    String matchStr = originalText.substring(match.getOffset(), match.getOffset() + match.getLength());
                                    replacedStr = matchStr.replaceAll(searchPattern, replaceString);
                                }
                                strBuilder.append(replacedStr);
                                currentOffset = match.getOffset() + match.getLength();
                                monitor.worked(1);
                                ++n4;
                            }
                            String afterMatch = originalText.substring(currentOffset);
                            strBuilder.append(afterMatch);
                            IQ7NamedElement workingCopy = ReplaceSearchResult.setNewText(scenario, scenarioPart, strBuilder.toString());
                            try {
                                FileEditorInput input = new FileEditorInput(file);
                                IEditorPart editor = page.findEditor((IEditorInput)input);
                                if (editor == null) {
                                    workingCopy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                                }
                            }
                            finally {
                                workingCopy.discardWorkingCopy();
                            }
                        }
                        catch (ModelException e) {
                            Q7UIPlugin.log((Throwable)e);
                        }
                    }
                    ++n2;
                }
                searchResult.removeAll();
            }
            catch (CoreException e) {
                Q7UIPlugin.log((Throwable)e);
            }
        }
        finally {
            monitor.done();
        }
    }

    private static IFile[] foundFiles(Q7SearchResult searchResult) {
        ArrayList<IFile> files = new ArrayList<IFile>();
        Object[] objectArray = searchResult.getElements();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IFile) {
                files.add((IFile)element);
            }
            ++n2;
        }
        return files.toArray(new IFile[0]);
    }

    static EclContainer adaptToEclContainer(IQ7NamedElement element) throws ModelException {
        if (element instanceof ITestCase) {
            return new TestCaseEclContainer((ITestCase)element);
        }
        if (element instanceof IContext && element.getNamedElement() instanceof EclContext) {
            return new ContextEclContainer((IContext)element);
        }
        throw new IllegalArgumentException("Can't extract ECL script from " + element.getClass().getName());
    }

    public static String getReplaceHint(Q7SearchResult searchResult) {
        String replaceHint = "Replacing " + searchResult.getMatchCount() + " matches";
        int scenarioPart = ((Q7SearchQuery)searchResult.getQuery()).getSearchFor();
        switch (scenarioPart) {
            case 0: {
                replaceHint = replaceHint + " in scripts";
                break;
            }
            case 1: {
                replaceHint = replaceHint + " in descriptions";
            }
        }
        return replaceHint;
    }

    private static String getOriginalText(EclContainer scenario, int scenarioPart) throws ModelException {
        String originalText = null;
        switch (scenarioPart) {
            case 1: {
                originalText = scenario.getDescription();
                break;
            }
            case 0: {
                originalText = scenario.getScript().getContent();
            }
        }
        return originalText;
    }

    private static IQ7NamedElement setNewText(EclContainer scenario, int scenarioPart, String newText) throws ModelException {
        switch (scenarioPart) {
            case 1: {
                IQ7NamedElement workingCopy = scenario.element().getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                workingCopy.setDescription(newText);
                return workingCopy;
            }
            case 0: {
                Script script = CoreFactory.eINSTANCE.createScript();
                script.setContent(newText);
                return scenario.setScript(script);
            }
        }
        throw new IllegalArgumentException("" + scenarioPart);
    }

    static class ContextEclContainer
    implements EclContainer {
        private final IContext context;

        public ContextEclContainer(IContext testCase) throws ModelException {
            this.context = testCase;
        }

        @Override
        public String getDescription() throws ModelException {
            return this.context.getNamedElement().getDescription();
        }

        @Override
        public Script getScript() throws ModelException {
            NamedElement element = this.context.getNamedElement();
            return ((EclContext)element).getScript();
        }

        @Override
        public IQ7NamedElement element() {
            return this.context;
        }

        @Override
        public IQ7NamedElement setScript(Script script) throws ModelException {
            IContext rv = (IContext)this.context.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            EclContext eclc = (EclContext)rv.getNamedElement();
            eclc.setScript(script);
            return rv;
        }
    }

    static interface EclContainer {
        public IQ7NamedElement element();

        public String getDescription() throws ModelException;

        public Script getScript() throws ModelException;

        public IQ7NamedElement setScript(Script var1) throws ModelException;
    }

    private static class InternalReplaceJob
    extends Job {
        private Q7SearchResult fSearchResult;
        private String fReplaceString;
        private IWorkbenchPage fPage;

        public InternalReplaceJob(Q7SearchResult searchResult, String replaceString, IWorkbenchPage page) {
            super(ReplaceSearchResult.getReplaceHint(searchResult));
            this.fSearchResult = searchResult;
            this.fReplaceString = replaceString;
            this.fPage = page;
        }

        protected IStatus run(IProgressMonitor monitor) {
            int origPriority = Thread.currentThread().getPriority();
            Thread.currentThread().setPriority(1);
            try {
                try {
                    ReplaceSearchResult.Replace(this.fSearchResult, this.fReplaceString, this.fPage, monitor);
                }
                catch (IOException e) {
                    Status status;
                    String PLUGINID = "org.eclipse.rcptt.search";
                    Status status2 = status = new Status(4, "org.eclipse.rcptt.search", e.getMessage());
                    Thread.currentThread().setPriority(origPriority);
                    return status2;
                }
                IStatus iStatus = Status.OK_STATUS;
                return iStatus;
            }
            finally {
                Thread.currentThread().setPriority(origPriority);
            }
        }
    }

    static class TestCaseEclContainer
    implements EclContainer {
        private final ITestCase testCase;

        public TestCaseEclContainer(ITestCase testCase) {
            this.testCase = testCase;
        }

        @Override
        public String getDescription() throws ModelException {
            return this.testCase.getNamedElement().getDescription();
        }

        @Override
        public Script getScript() throws ModelException {
            return Scenarios.getEcl((ITestCase)this.testCase);
        }

        @Override
        public IQ7NamedElement element() {
            return this.testCase;
        }

        @Override
        public IQ7NamedElement setScript(Script script) throws ModelException {
            ITestCase rv = (ITestCase)this.testCase.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
            rv.setContent((EObject)script);
            return rv;
        }
    }
}

