/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.refactoring;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyParticipant;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.internal.ui.Messages;

public class Q7ResourcesCopyParticipant
extends CopyParticipant {
    IResource element = null;
    IContainer source = null;

    protected boolean initialize(Object element) {
        if (!(this.getArguments().getDestination() instanceof IContainer)) {
            return false;
        }
        if (!(element instanceof IResource)) {
            return false;
        }
        this.element = (IResource)element;
        final boolean[] rv = new boolean[1];
        try {
            this.element.accept(new IResourceVisitor(){

                public boolean visit(IResource resource) throws CoreException {
                    if (Q7SearchCore.findIDByPath((IPath)resource.getFullPath()) != null) {
                        rv[0] = true;
                    }
                    return !rv[0];
                }
            });
        }
        catch (CoreException e) {
            throw new RuntimeException(e);
        }
        this.source = this.element.getParent();
        return rv[0];
    }

    public String getName() {
        return Messages.Q7ResourcesCopyParticipant_Name;
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        assert (this.element != null);
        final CompositeChange rv = new CompositeChange("Update ids");
        this.element.accept(new IResourceVisitor(){

            public boolean visit(IResource resource) throws CoreException {
                if (resource instanceof IFile && Q7SearchCore.findIDByPath((IPath)resource.getFullPath()) != null) {
                    rv.add((Change)new UpdateIdInCopiedFrom((IFile)resource));
                }
                return true;
            }
        });
        return rv;
    }

    static abstract class UpdateIdChange
    extends ResourceChange {
        UpdateIdChange() {
        }

        public Change perform(IProgressMonitor pm) throws CoreException {
            IFile modifiedResource = this.getModifiedResource();
            assert (modifiedResource.exists()) : "Resource " + String.valueOf(modifiedResource) + " doesn't exists yet";
            assert (modifiedResource != null);
            IQ7NamedElement newElement = (IQ7NamedElement)RcpttCore.create((IResource)modifiedResource);
            if (newElement == null) {
                throw new RuntimeException("Failed to load RCPTT element " + String.valueOf(modifiedResource));
            }
            IQ7NamedElement workingCopy = newElement.getWorkingCopy(pm);
            workingCopy.setID(EcoreUtil.generateUUID());
            workingCopy.commitWorkingCopy(false, pm);
            return null;
        }

        public String getName() {
            return "ID update";
        }

        public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
            return new RefactoringStatus();
        }

        protected abstract IFile getModifiedResource();
    }

    class UpdateIdInCopiedFrom
    extends UpdateIdChange {
        private final IFile copiedFrom;

        public UpdateIdInCopiedFrom(IFile copiedFrom) {
            this.copiedFrom = copiedFrom;
        }

        String renamed(IResource res) {
            String newName = Q7ResourcesCopyParticipant.this.getArguments().getExecutionLog().getNewName((Object)res);
            if (newName == null) {
                newName = res.getName();
            }
            return newName;
        }

        IPath changedPath(IResource sourceResource) {
            if (sourceResource.equals((Object)Q7ResourcesCopyParticipant.this.source)) {
                return Path.EMPTY;
            }
            return this.changedPath((IResource)sourceResource.getParent()).append(this.renamed(sourceResource));
        }

        @Override
        protected IFile getModifiedResource() {
            IContainer destination = (IContainer)Q7ResourcesCopyParticipant.this.getArguments().getDestination();
            IFile target = destination.getFile(this.changedPath((IResource)this.copiedFrom));
            assert (target != null);
            return target;
        }
    }
}

