/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionDelegate2;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public abstract class AbstractAllBreakpointEnablement
implements IViewActionDelegate,
IActionDelegate2,
IWorkbenchWindowActionDelegate {
    private IAction fAction;

    public void dispose() {
        this.fAction = null;
    }

    public void init(IAction action) {
        this.fAction = action;
    }

    protected IAction getAction() {
        return this.fAction;
    }

    public void runWithEvent(IAction action, Event event) {
        this.run(action);
    }

    public void init(IViewPart view) {
        this.initialize();
        this.update();
    }

    public void init(IWorkbenchWindow window) {
        this.initialize();
        this.update();
    }

    protected abstract void initialize();

    protected void update() {
        IAction action = this.getAction();
        if (action != null) {
            action.setEnabled(this.isEnabled());
        }
    }

    public void selectionChanged(IAction action, ISelection s) {
    }

    public void run(IAction action) {
    }

    protected abstract boolean isEnabled();

    protected void scheduleEnablement(String jobName, final boolean enablementStatus) {
        final IBreakpoint[] breakpoints = this.getBreakpoints();
        new Job(jobName){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IBreakpoint[] iBreakpointArray = breakpoints;
                    int n = breakpoints.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IBreakpoint breakpoint = iBreakpointArray[n2];
                        breakpoint.setEnabled(enablementStatus);
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    protected IBreakpoint[] getBreakpoints() {
        IBreakpointManager breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        return breakpointManager.getBreakpoints();
    }

    protected void updateBreakpoints(boolean enablementStatus) {
        IBreakpoint[] breakpoints = this.getBreakpoints();
        if (breakpoints.length < 1) {
            return;
        }
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        boolean prompt = store.getBoolean(enablementStatus ? "org.eclipse.debug.ui.enable_all_breakpoints_prompt" : "org.eclipse.debug.ui.disable_all_breakpoints_prompt");
        boolean proceed = true;
        if (prompt) {
            MessageDialogWithToggle mdwt = MessageDialogWithToggle.openYesNoQuestion((Shell)window.getShell(), (String)(enablementStatus ? ActionMessages.EnableAllBreakpointsAction_0 : ActionMessages.DisableAllBreakPointsAction_0), (String)(enablementStatus ? ActionMessages.EnableAllBreakpointsAction_1 : ActionMessages.DisableAllBreakPointsAction_1), (String)(enablementStatus ? ActionMessages.EnableAllBreakpointsAction_3 : ActionMessages.DisableAllBreakPointsAction_2), (!prompt ? 1 : 0) != 0, null, null);
            if (mdwt.getReturnCode() != 2) {
                proceed = false;
            } else {
                store.setValue(enablementStatus ? "org.eclipse.debug.ui.enable_all_breakpoints_prompt" : "org.eclipse.debug.ui.disable_all_breakpoints_prompt", !mdwt.getToggleState());
            }
        }
        if (proceed) {
            if (enablementStatus) {
                this.scheduleEnablement(ActionMessages.EnableAllBreakpointsAction_0, true);
            } else {
                this.scheduleEnablement(ActionMessages.DisableAllBreakPointsAction_0, false);
            }
        }
    }
}

