/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui;

import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.TableColumn;

public abstract class ColumnSorter
extends ViewerComparator {
    private ColumnViewer cviewer = null;
    private TableColumn column = null;
    private int direction = 1024;
    private int columnidx = 0;

    public ColumnSorter(ColumnViewer cviewer, TableColumn column) {
        this.cviewer = cviewer;
        this.column = column;
        this.columnidx = this.getColumnIndex();
        this.column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (ColumnSorter.this.cviewer.getComparator() != ColumnSorter.this) {
                    ColumnSorter.this.setDirection(1024);
                } else {
                    int tdirection = ColumnSorter.this.column.getParent().getSortDirection();
                    if (tdirection == 0) {
                        ColumnSorter.this.setDirection(1024);
                    } else {
                        ColumnSorter.this.setDirection(tdirection == 128 ? 1024 : 128);
                    }
                }
            }
        });
    }

    public abstract String getCompareText(Object var1, int var2);

    public void setDirection(int direction) {
        this.column.getParent().setSortColumn(this.column);
        this.direction = direction;
        this.column.getParent().setSortDirection(this.direction);
        if (this.cviewer.getComparator() == this) {
            this.cviewer.refresh();
        } else {
            this.cviewer.setComparator((ViewerComparator)this);
        }
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        String text2;
        String text1 = this.getCompareText(e1, this.columnidx);
        if (text1 == null) {
            text1 = "";
        }
        if ((text2 = this.getCompareText(e2, this.columnidx)) == null) {
            text2 = "";
        }
        return (this.direction == 128 ? -1 : 1) * text1.compareTo(text2);
    }

    private int getColumnIndex() {
        int idx = this.column.getParent().indexOf(this.column);
        return idx < 0 ? 0 : idx;
    }
}

