/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.views.plugins;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.SearchablePluginsManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.views.plugins.JavaSearchOperation;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;

public class JavaSearchActionGroup
extends ActionGroup {
    public void fillContextMenu(IMenuManager menu) {
        ActionContext context = this.getContext();
        ISelection selection = context.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            IStructuredSelection sSelection = (IStructuredSelection)selection;
            boolean addSeparator = false;
            if (this.canDoJavaSearchOperation(sSelection, true)) {
                menu.add((IAction)new JavaSearchAction(true));
                addSeparator = true;
            }
            if (this.canDoJavaSearchOperation(sSelection, false)) {
                menu.add((IAction)new JavaSearchAction(false));
                addSeparator = true;
            }
            if (addSeparator) {
                menu.add((IContributionItem)new Separator());
            }
        }
    }

    private boolean canDoJavaSearchOperation(IStructuredSelection selection, boolean add) {
        int nhits = 0;
        IPluginModelBase model = null;
        SearchablePluginsManager manager = PDECore.getDefault().getSearchablePluginsManager();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            model = this.getModel(iter.next());
            if (model == null) {
                return false;
            }
            if (model.getUnderlyingResource() != null || add != !manager.isInJavaSearch(model.getPluginBase().getId())) continue;
            ++nhits;
        }
        return nhits > 0;
    }

    private IPluginModelBase getModel(Object object) {
        IPluginModelBase model = null;
        if (object instanceof IAdaptable) {
            model = (IPluginModelBase)((IAdaptable)object).getAdapter(IPluginModelBase.class);
        } else if (object instanceof IPluginModelBase) {
            model = (IPluginModelBase)object;
        }
        return model;
    }

    private void handleJavaSearch(boolean add) {
        IStructuredSelection selection = (IStructuredSelection)this.getContext().getSelection();
        if (selection.isEmpty()) {
            return;
        }
        ArrayList<IPluginModelBase> result = new ArrayList<IPluginModelBase>();
        SearchablePluginsManager manager = PDECore.getDefault().getSearchablePluginsManager();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = this.getModel(iter.next());
            if (model == null || model.getUnderlyingResource() != null || manager.isInJavaSearch(model.getPluginBase().getId()) == add) continue;
            result.add(model);
        }
        if (result.isEmpty()) {
            return;
        }
        IPluginModelBase[] array = result.toArray(new IPluginModelBase[result.size()]);
        JavaSearchOperation op = new JavaSearchOperation(array, add);
        try {
            PlatformUI.getWorkbench().getProgressService().busyCursorWhile((IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
        }
    }

    class JavaSearchAction
    extends Action {
        private final boolean add;

        public JavaSearchAction(boolean add) {
            this.add = add;
            if (add) {
                this.setText(PDEUIMessages.PluginsView_addToJavaSearch);
            } else {
                this.setText(PDEUIMessages.PluginsView_removeFromJavaSearch);
            }
        }

        public void run() {
            IPreferenceStore store = PDEPlugin.getDefault().getPreferenceStore();
            if (!this.add && store.getBoolean("Preferences.MainPage.addToJavaSearch")) {
                boolean confirm = MessageDialog.openConfirm((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.JavaSearchActionGroup_RemoveJavaSearchTitle, (String)PDEUIMessages.JavaSearchActionGroup_RemoveJavaSearchMessage);
                if (confirm) {
                    store.setValue("Preferences.MainPage.addToJavaSearch", false);
                    JavaSearchActionGroup.this.handleJavaSearch(this.add);
                }
            } else {
                JavaSearchActionGroup.this.handleJavaSearch(this.add);
            }
        }
    }
}

