/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.recording.core.ecl.parser;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.ecl.core.CoreFactory;
import org.eclipse.rcptt.ecl.core.Sequence;
import org.eclipse.rcptt.ecl.core.util.EclRefactoring;
import org.eclipse.rcptt.tesla.core.protocol.ActivateCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.ApplyCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.Assert;
import org.eclipse.rcptt.tesla.core.protocol.AssertImageData;
import org.eclipse.rcptt.tesla.core.protocol.AssertionModeRequest;
import org.eclipse.rcptt.tesla.core.protocol.CancelCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.Check;
import org.eclipse.rcptt.tesla.core.protocol.CheckItem;
import org.eclipse.rcptt.tesla.core.protocol.Click;
import org.eclipse.rcptt.tesla.core.protocol.ClickAboutMenu;
import org.eclipse.rcptt.tesla.core.protocol.ClickColumn;
import org.eclipse.rcptt.tesla.core.protocol.ClickPreferencesMenu;
import org.eclipse.rcptt.tesla.core.protocol.Close;
import org.eclipse.rcptt.tesla.core.protocol.Collapse;
import org.eclipse.rcptt.tesla.core.protocol.DeactivateCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.DoubleClick;
import org.eclipse.rcptt.tesla.core.protocol.DragCommand;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetState;
import org.eclipse.rcptt.tesla.core.protocol.HoverAtText;
import org.eclipse.rcptt.tesla.core.protocol.HoverAtTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.Maximize;
import org.eclipse.rcptt.tesla.core.protocol.Minimize;
import org.eclipse.rcptt.tesla.core.protocol.MouseEvent;
import org.eclipse.rcptt.tesla.core.protocol.MouseEventKind;
import org.eclipse.rcptt.tesla.core.protocol.OpenDeclaration;
import org.eclipse.rcptt.tesla.core.protocol.RecordingModeRequest;
import org.eclipse.rcptt.tesla.core.protocol.Restore;
import org.eclipse.rcptt.tesla.core.protocol.RollbackToState;
import org.eclipse.rcptt.tesla.core.protocol.RulerClick;
import org.eclipse.rcptt.tesla.core.protocol.RulerDoubleClick;
import org.eclipse.rcptt.tesla.core.protocol.RulerHover;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SetCursorOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetSWTDialogInfo;
import org.eclipse.rcptt.tesla.core.protocol.SetSelection;
import org.eclipse.rcptt.tesla.core.protocol.SetStatusDialogMode;
import org.eclipse.rcptt.tesla.core.protocol.SetText;
import org.eclipse.rcptt.tesla.core.protocol.SetTextOffset;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection;
import org.eclipse.rcptt.tesla.core.protocol.SetTextSelection2;
import org.eclipse.rcptt.tesla.core.protocol.ShowContentAssist;
import org.eclipse.rcptt.tesla.core.protocol.ShowTabList;
import org.eclipse.rcptt.tesla.core.protocol.Type;
import org.eclipse.rcptt.tesla.core.protocol.TypeAction;
import org.eclipse.rcptt.tesla.core.protocol.TypeText;
import org.eclipse.rcptt.tesla.core.protocol.WaitForRestart;
import org.eclipse.rcptt.tesla.core.protocol.WaitForState;
import org.eclipse.rcptt.tesla.core.protocol.diagram.ActivateDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CancelDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.CommitDirectEdit;
import org.eclipse.rcptt.tesla.core.protocol.diagram.FigureMouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.diagram.MouseCommand;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.ecl.TeslaEclUtils;
import org.eclipse.rcptt.tesla.ecl.TeslaScriptletFactory;
import org.eclipse.rcptt.tesla.ecl.model.Button;
import org.eclipse.rcptt.tesla.ecl.model.ClickLink;
import org.eclipse.rcptt.tesla.ecl.model.ClickText;
import org.eclipse.rcptt.tesla.ecl.model.Decrypt;
import org.eclipse.rcptt.tesla.ecl.model.DragAccept;
import org.eclipse.rcptt.tesla.ecl.model.ExecWithOptions;
import org.eclipse.rcptt.tesla.ecl.model.Expand;
import org.eclipse.rcptt.tesla.ecl.model.FromRawKey;
import org.eclipse.rcptt.tesla.ecl.model.GetProperty;
import org.eclipse.rcptt.tesla.ecl.model.KeyType;
import org.eclipse.rcptt.tesla.ecl.model.Mouse;
import org.eclipse.rcptt.tesla.ecl.model.Options;
import org.eclipse.rcptt.tesla.ecl.model.Selector;
import org.eclipse.rcptt.tesla.ecl.model.SetFocus;
import org.eclipse.rcptt.tesla.ecl.model.TeslaFactory;
import org.eclipse.rcptt.tesla.ecl.model.TeslaPackage;
import org.eclipse.rcptt.tesla.ecl.model.TypeCommandKey;
import org.eclipse.rcptt.tesla.ecl.model.Unfocus;
import org.eclipse.rcptt.tesla.ecl.model.diagram.GetEditPart;
import org.eclipse.rcptt.tesla.ecl.model.diagram.GetFigure;
import org.eclipse.rcptt.tesla.ecl.model.diagram.MousePress;
import org.eclipse.rcptt.tesla.internal.core.SimpleCommandPrinter;
import org.eclipse.rcptt.tesla.recording.core.ecl.KeyStrokeManager;
import org.eclipse.rcptt.tesla.recording.core.ecl.TeslaCommand;
import org.eclipse.rcptt.tesla.recording.core.ecl.TeslaRecordingPlugin;
import org.eclipse.rcptt.tesla.recording.core.ecl.parser.SetSelectionParser;
import org.eclipse.rcptt.tesla.recording.core.ecl.parser.TeslaParserUtil;
import org.eclipse.rcptt.tesla.recording.core.internal.ecl.DiagramUtils;
import org.eclipse.rcptt.tesla.recording.core.internal.ecl.KeyStrokeUtil;
import org.eclipse.rcptt.tesla.recording.core.internal.ecl.SWTCopy;
import org.eclipse.rcptt.tesla.recording.core.internal.ecl.TeslaSelectorParser;
import org.eclipse.rcptt.util.Base64;
import org.eclipse.rcptt.util.KeysAndButtons;

public class TeslaParser
extends TeslaScriptletFactory {
    private static final int DROP_COPY = 1;
    private static final int DROP_TARGET_MOVE = 8;
    private static final int DROP_MOVE = 2;
    private static final int DROP_LINK = 4;
    private static final int DROP_DEFAULT = 16;
    List<Command> teslaCommands;
    private List<org.eclipse.rcptt.ecl.core.Command> script;
    int pos;
    private TeslaSelectorParser selectorParser;

    public org.eclipse.rcptt.ecl.core.Command teslaScenario(TeslaScenario scenario, Integer target) {
        if (scenario == null) {
            return TeslaParser.seq((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[0]);
        }
        scenario = (TeslaScenario)EcoreUtil.copy((EObject)scenario);
        this.selectorParser = new TeslaSelectorParser(scenario);
        this.selectorParser.parse();
        this.teslaCommands = scenario.getCommands();
        this.pos = 0;
        this.script = new ArrayList<org.eclipse.rcptt.ecl.core.Command>();
        while (target == null || this.pos < target) {
            if (this.pos >= this.teslaCommands.size()) break;
            org.eclipse.rcptt.ecl.core.Command newCommand = this.teslaCommand();
            if (newCommand == null) continue;
            this.script.add(newCommand);
        }
        Sequence seq = CoreFactory.eINSTANCE.createSequence();
        List withified = EclRefactoring.withify(this.script, (Comparator)new Comparator<org.eclipse.rcptt.ecl.core.Command>(){

            @Override
            public int compare(org.eclipse.rcptt.ecl.core.Command c1, org.eclipse.rcptt.ecl.core.Command c2) {
                if (c1 instanceof Selector && c2 instanceof Selector) {
                    Selector s1 = (Selector)c1;
                    Selector s2 = (Selector)c2;
                    if (s1.getId() != null && s2.getId() != null) {
                        return s1.getId().compareTo(s2.getId());
                    }
                }
                return 1;
            }
        });
        seq.getCommands().addAll(DiagramUtils.updateSelectors(withified));
        return TeslaScriptletFactory.makeSeq((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{seq});
    }

    public void replaceCommand(org.eclipse.rcptt.ecl.core.Command replaced, org.eclipse.rcptt.ecl.core.Command newCommand) {
        int index = this.script.indexOf(replaced);
        this.script.add(index, newCommand);
        this.script.remove(replaced);
    }

    public void removeCommand(org.eclipse.rcptt.ecl.core.Command remove) {
        this.script.remove(remove);
    }

    public List<org.eclipse.rcptt.ecl.core.Command> getScriptCommand() {
        return Collections.unmodifiableList(this.script);
    }

    protected org.eclipse.rcptt.ecl.core.Command teslaCommand() {
        Command teslaCommand = this.teslaCommands.get(this.pos);
        ++this.pos;
        Method rule = RuleMap.ruleFor(teslaCommand.eClass());
        if (rule != null) {
            try {
                if (rule.getDeclaringClass().equals(((Object)((Object)this)).getClass())) {
                    return (org.eclipse.rcptt.ecl.core.Command)rule.invoke((Object)this, teslaCommand);
                }
                return (org.eclipse.rcptt.ecl.core.Command)rule.invoke(null, new Object[]{this, teslaCommand});
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                TeslaRecordingPlugin.log(t.getMessage(), t);
            }
            catch (Throwable t) {
                TeslaRecordingPlugin.log(t.getMessage(), t);
            }
        }
        return TeslaScriptletFactory.unsupported((String)SimpleCommandPrinter.toString((Command)teslaCommand));
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SelectCommand")
    protected org.eclipse.rcptt.ecl.core.Command selectCommand(SelectCommand selectCommand) {
        return null;
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="GetState")
    protected org.eclipse.rcptt.ecl.core.Command getState(GetState c) {
        return null;
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="WaitForState")
    protected org.eclipse.rcptt.ecl.core.Command waitForState(WaitForState c) {
        return null;
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="RollbackToState")
    protected org.eclipse.rcptt.ecl.core.Command rollbackToState(RollbackToState c) {
        return null;
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Click")
    protected org.eclipse.rcptt.ecl.core.Command click(Click c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeClick((boolean)true, (boolean)c.isDefault(), (boolean)c.isArrow(), (String)KeyStrokeManager.getUtils().getMetaKeys(c.getMetaKeys()))});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ClickColumn")
    protected org.eclipse.rcptt.ecl.core.Command clickColumn(ClickColumn c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeClickColumn((String)c.getName(), (int)c.getIndex())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="DoubleClick")
    protected org.eclipse.rcptt.ecl.core.Command doubleClick(DoubleClick c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeDoubleClick((boolean)true)});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetText")
    protected org.eclipse.rcptt.ecl.core.Command setText(SetText c) {
        if (c.getElement().getKind().equals(ElementKind.DateTime.name()) || c.getElement().getKind().equals(ElementKind.Slider.name())) {
            return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeSetValue((String)c.getValue())});
        }
        org.eclipse.rcptt.tesla.ecl.model.SetText cmd = TeslaFactory.eINSTANCE.createSetText();
        if (c.isHidden()) {
            TeslaParser.bind((org.eclipse.rcptt.ecl.core.Command)cmd, (EStructuralFeature)TeslaPackage.eINSTANCE.getSetText_Text(), (org.eclipse.rcptt.ecl.core.Command)this.decrypt(c.getValue()));
        } else {
            cmd.setText(c.getValue());
        }
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), cmd});
    }

    protected org.eclipse.rcptt.ecl.core.Command decrypt(String rawdata) {
        Decrypt cmd = TeslaFactory.eINSTANCE.createDecrypt();
        cmd.setValue(rawdata);
        return cmd;
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetTextSelection")
    protected org.eclipse.rcptt.ecl.core.Command setTextSelection(SetTextSelection c) {
        if (c.getEndline() != null && c.getEndoffset() != null) {
            return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeSetTextSelection((int)c.getStartLine(), (int)c.getOffset(), (Integer)c.getEndline(), (Integer)c.getEndoffset())});
        }
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeSetTextSelection((int)c.getOffset(), (int)c.getLength())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="TypeText")
    protected org.eclipse.rcptt.ecl.core.Command typeText(TypeText c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeTypeText((String)c.getText(), (boolean)c.isFromDisplay())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Type")
    protected org.eclipse.rcptt.ecl.core.Command type(Type c) {
        KeyType kt = TeslaFactory.eINSTANCE.createKeyType();
        kt.setDisplay(c.isFromDisplay());
        kt.setTimes(c.getTimes());
        int mask = c.getState();
        int keyCode = c.getCode();
        char ch = c.getCharacter();
        int meta = 0;
        if (c.getMeta() != null) {
            meta = c.getMeta();
        }
        if ((keyCode & SWTCopy.MODIFIER_MASK) == keyCode && ch == '\u0000') {
            kt.setChar(null);
        } else if (keyCode >= 0x1000001 && keyCode <= 16777303 && ch == '\u0000') {
            kt.setChar(null);
        } else if ((mask & 0x20000) != 0 && (mask & 0x40000) != 0 && ch + 64 == keyCode && (Character.toLowerCase(ch) < ' ' || Character.toLowerCase(ch) == '\u007f') && (keyCode & 0x1000000) == 0) {
            kt.setChar(null);
        } else if ((mask & 0x40000) != 0 && ch + 64 == Character.toUpperCase(keyCode) && (ch < ' ' || ch == '\u007f') && (keyCode & 0x1000000) == 0) {
            kt.setChar(null);
        } else if ((mask & 0x20000) != 0 && ch == Character.toUpperCase(keyCode)) {
            kt.setChar(null);
        } else if (ch == keyCode) {
            kt.setChar(null);
        } else if (ch >= ' ' && ch <= '~') {
            kt.setChar(String.valueOf(ch));
        } else {
            kt.setChar(String.format("\\u%04X", ch));
        }
        if (!c.isTraverse()) {
            try {
                kt.setKey(KeyStrokeManager.getUtils().formatKeyWithMeta(mask, keyCode, meta));
            }
            catch (Throwable throwable) {
                FromRawKey frk = TeslaFactory.eINSTANCE.createFromRawKey();
                frk.setKeyCode(Integer.valueOf(keyCode));
                frk.setMeta(Integer.valueOf(meta));
                frk.setMask(Integer.valueOf(mask));
                kt = (KeyType)TeslaParser.bind((org.eclipse.rcptt.ecl.core.Command)kt, (EStructuralFeature)TeslaPackage.eINSTANCE.getKeyType_Key(), (org.eclipse.rcptt.ecl.core.Command)frk);
            }
            if (kt.getKey() != null) {
                kt.setKey(TeslaEclUtils.getKeyAlias((String)kt.getKey()));
            }
        } else {
            kt.setKey(KeyStrokeUtil.formatTraverse(keyCode));
            if (keyCode != 128) {
                kt.setChar(null);
            }
        }
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement(), false), kt});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="TypeAction")
    protected org.eclipse.rcptt.ecl.core.Command typeAction(TypeAction c) {
        TypeCommandKey tck = TeslaFactory.eINSTANCE.createTypeCommandKey();
        tck.setCommandId(c.getActionId());
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), tck});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetSelection")
    public org.eclipse.rcptt.ecl.core.Command setSelection(SetSelection c) {
        return new SetSelectionParser().parse(c, this);
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="CheckItem")
    protected org.eclipse.rcptt.ecl.core.Command checkItem(CheckItem c) {
        if (c.getPath() != null && !c.getPath().isEmpty()) {
            org.eclipse.rcptt.ecl.core.Command item = TeslaParserUtil.makeItem((List<String>)c.getPath());
            return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), item, c.isState() ? TeslaScriptletFactory.makeCheck() : TeslaScriptletFactory.makeUncheck()});
        }
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), c.isState() ? TeslaScriptletFactory.makeCheck() : TeslaScriptletFactory.makeUncheck()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Check")
    protected org.eclipse.rcptt.ecl.core.Command checkItem(Check c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), c.isState() ? TeslaScriptletFactory.makeCheck() : TeslaScriptletFactory.makeUncheck()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Close")
    protected org.eclipse.rcptt.ecl.core.Command close(Close c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeClose()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetStatusDialogMode")
    protected org.eclipse.rcptt.ecl.core.Command setStatusDialogMode(SetStatusDialogMode c) {
        Options opts = TeslaScriptletFactory.makeOptions();
        opts.setAllowStatusDialog(c.isEnabled());
        if (c.isEnabled()) {
            org.eclipse.rcptt.ecl.core.Command nextCmd;
            ArrayList<org.eclipse.rcptt.ecl.core.Command> sequence = new ArrayList<org.eclipse.rcptt.ecl.core.Command>();
            while (this.pos < this.teslaCommands.size() && (!((nextCmd = this.teslaCommand()) instanceof Options) || ((Options)nextCmd).isAllowStatusDialog())) {
                sequence.add(nextCmd);
            }
            if (sequence.size() > 0) {
                ExecWithOptions exec = TeslaScriptletFactory.makeExecWithOptions();
                exec.setAllowStatusDialog(opts.isAllowStatusDialog());
                exec.setCommand((org.eclipse.rcptt.ecl.core.Command)TeslaParser.makeSeq(sequence));
                return exec;
            }
        }
        return opts;
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Minimize")
    protected org.eclipse.rcptt.ecl.core.Command minimize(Minimize c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaFactory.eINSTANCE.createMinimize()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Maximize")
    protected org.eclipse.rcptt.ecl.core.Command maximize(Maximize c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaFactory.eINSTANCE.createMaximize()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Restore")
    protected org.eclipse.rcptt.ecl.core.Command restore(Restore c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaFactory.eINSTANCE.createRestore()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ShowTabList")
    protected org.eclipse.rcptt.ecl.core.Command showTabList(ShowTabList c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaFactory.eINSTANCE.createShowTabList()});
    }

    private static String formatDetail(int detail) {
        switch (detail) {
            case 1: {
                return "copy";
            }
            case 2: {
                return "move";
            }
            case 4: {
                return "link";
            }
            case 8: {
                return "target-move";
            }
            case 16: {
                return "any";
            }
        }
        return "none";
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="DragCommand")
    protected org.eclipse.rcptt.ecl.core.Command dragCommand(DragCommand c) {
        String[] split = c.getStyle().split(",");
        String detail = null;
        Integer operations = null;
        Button button = null;
        String mask = null;
        String[] stringArray = split;
        int n = split.length;
        int n2 = 0;
        while (n2 < n) {
            String var = stringArray[n2];
            String[] strings = var.split(":");
            int val = Integer.parseInt(strings[1]);
            if (strings[0].equals("detail")) {
                detail = TeslaParser.formatDetail(val);
            }
            if (strings[0].equals("button")) {
                button = Button.values()[val];
            }
            if (strings[0].equals("mask")) {
                mask = KeyStrokeManager.getUtils().getMetaKeys(val);
            }
            if (strings[0].equals("operations")) {
                operations = val;
            }
            ++n2;
        }
        DragAccept drag = null;
        Integer x = c.getX();
        Integer y = c.getY();
        switch (c.getKind()) {
            case ACCEPT: {
                drag = TeslaScriptletFactory.makeDragAccept((Integer)x, (Integer)y, detail, operations, mask, button);
                break;
            }
            case DETECT: {
                drag = TeslaScriptletFactory.makeDragDetect((Integer)x, (Integer)y, detail, operations, mask, button);
                break;
            }
            case DROP: {
                drag = TeslaScriptletFactory.makeDrop((Integer)x, (Integer)y, detail, operations, mask, button);
                break;
            }
            case END: {
                drag = TeslaScriptletFactory.makeDragEnd((Integer)x, (Integer)y, detail, operations, mask, button);
                break;
            }
            case ENTER: {
                drag = TeslaScriptletFactory.makeDragEnter((Integer)x, (Integer)y, detail, operations, mask, button);
                break;
            }
            case LEAVE: {
                drag = TeslaScriptletFactory.makeDragExit((Integer)x, (Integer)y, detail, operations, mask, button);
                break;
            }
            case OVER: {
                drag = TeslaScriptletFactory.makeDragOver((Integer)x, (Integer)y, detail, operations, mask, button);
                break;
            }
            case SET_DATA: {
                drag = TeslaScriptletFactory.makeDragSetData((Integer)x, (Integer)y, detail, operations, mask, button);
                break;
            }
            case START: {
                drag = TeslaScriptletFactory.makeDragStart((Integer)x, (Integer)y, detail, operations, mask, button);
            }
        }
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), drag});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetSWTDialogInfo")
    protected org.eclipse.rcptt.ecl.core.Command setSWTCopyDialogInfo(SetSWTDialogInfo c) {
        String kind = null;
        switch (c.getKind()) {
            case COLOR: {
                kind = "Color";
                break;
            }
            case FILE_SELECTOR: {
                kind = "File";
                break;
            }
            case FONT_DIALOG: {
                kind = "Font";
                break;
            }
            case FOLDER_SELECTOR: {
                kind = "Folder";
                break;
            }
            case MESSAGE_BOX: {
                kind = "MessageBox";
            }
        }
        return TeslaScriptletFactory.makeDialogReturns((String)kind, (EList)c.getPath());
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetTextOffset")
    protected org.eclipse.rcptt.ecl.core.Command setTextOffset(SetTextOffset c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeSetTextOffset((int)c.getLine(), (int)c.getOffset())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetCursorOffset")
    protected org.eclipse.rcptt.ecl.core.Command setTextOffset(SetCursorOffset c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeSetCaretPos((int)c.getLine(), (int)c.getOffset())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetTextSelection2")
    protected org.eclipse.rcptt.ecl.core.Command selectText(SetTextSelection2 c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeSelectRange((int)c.getStartLine(), (int)c.getStartOffset(), (int)c.getEndLine(), (int)c.getEndOffset())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="HoverAtTextOffset")
    protected org.eclipse.rcptt.ecl.core.Command hoverAtTextOffset(HoverAtTextOffset c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeHoverAtTextOffset((int)c.getLine(), (int)c.getOffset())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="HoverAtText")
    protected org.eclipse.rcptt.ecl.core.Command hoverAtTextOffset(HoverAtText c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeHoverText((int)c.getLine(), (int)c.getOffset(), (int)c.getStateMask())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="RulerClick")
    protected org.eclipse.rcptt.ecl.core.Command rulerClick(RulerClick c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeClickRuler((int)c.getLine(), (Button)Button.values()[c.getButton()], (int)c.getStateMask())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="RulerDoubleClick")
    protected org.eclipse.rcptt.ecl.core.Command rulerDoubleClick(RulerDoubleClick c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeDoubleClickRuler((int)c.getLine(), (Button)Button.values()[c.getButton()], (int)c.getStateMask())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="RulerHover")
    protected org.eclipse.rcptt.ecl.core.Command rulerHover(RulerHover c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeHoverRuler((int)c.getLine(), (int)c.getStateMask())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="OpenDeclaration")
    protected org.eclipse.rcptt.ecl.core.Command openDeclaration(OpenDeclaration c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeOpenDeclaration()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/diagram", classifier="MouseCommand")
    protected org.eclipse.rcptt.ecl.core.Command mouseCommand(MouseCommand c) {
        MousePress mouse = null;
        String mask = KeyStrokeManager.getUtils().getMetaKeys(c.getStateMask());
        Button button = c.getButton() == 0 ? null : Button.values()[c.getButton()];
        switch (c.getKind()) {
            case DOWN: {
                mouse = TeslaScriptletFactory.makeMousePress((int)c.getX(), (int)c.getY(), (Button)button, null, null, (String)mask);
                break;
            }
            case UP: {
                mouse = TeslaScriptletFactory.makeMouseRelease((int)c.getX(), (int)c.getY(), (Button)button, null, null, (String)mask);
                break;
            }
            case MOVE: {
                mouse = TeslaScriptletFactory.makeMouseMove((int)c.getX(), (int)c.getY(), (Button)button, null, null, (String)mask);
                break;
            }
            case DOUBLE_CLICK: {
                mouse = TeslaScriptletFactory.makeMouseDoubleClick((int)c.getX(), (int)c.getY(), (Button)button, null, null, (String)mask);
                break;
            }
            case HOVER: {
                mouse = TeslaScriptletFactory.makeMouseHover((int)c.getX(), (int)c.getY(), (Button)button, null, null, (String)mask);
                break;
            }
            case DRAG: {
                mouse = TeslaScriptletFactory.makeMouseDrag((int)c.getX(), (int)c.getY(), (Button)button, null, null, (String)mask);
                break;
            }
            case ENTER: {
                mouse = TeslaScriptletFactory.makeMouseEnter((int)c.getX(), (int)c.getY(), (Button)button, null, null, (String)mask);
                break;
            }
            case EXIT: {
                mouse = TeslaScriptletFactory.makeMouseExit((int)c.getX(), (int)c.getY(), (Button)button, null, null, (String)mask);
                break;
            }
            default: {
                return TeslaScriptletFactory.unsupported((String)SimpleCommandPrinter.toString((Command)c));
            }
        }
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), mouse});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/diagram", classifier="FigureMouseCommand")
    protected org.eclipse.rcptt.ecl.core.Command figureMouseCommand(FigureMouseCommand c) {
        EList partPath = c.getPartPath();
        GetEditPart ep = null;
        if (partPath.size() > 0) {
            ep = TeslaScriptletFactory.makeEditPart((List)partPath);
        }
        EList figurePath = c.getFigurePath();
        GetFigure f = null;
        if (figurePath.size() > 0) {
            f = TeslaScriptletFactory.makeFigure((List)figurePath);
        }
        String mask = KeyStrokeManager.getUtils().getMetaKeys(c.getStateMask());
        Button button = c.getButton() == 0 ? null : Button.values()[c.getButton()];
        MousePress mouse = null;
        switch (c.getKind()) {
            case DOWN: {
                mouse = TeslaScriptletFactory.makeMousePress((int)c.getX(), (int)c.getY(), (Button)button, (Integer)c.getFigureHeight(), (Integer)c.getFigureWidth(), (String)mask);
                break;
            }
            case UP: {
                mouse = TeslaScriptletFactory.makeMouseRelease((int)c.getX(), (int)c.getY(), (Button)button, (Integer)c.getFigureHeight(), (Integer)c.getFigureWidth(), (String)mask);
                break;
            }
            case MOVE: {
                mouse = TeslaScriptletFactory.makeMouseMove((int)c.getX(), (int)c.getY(), (Button)button, (Integer)c.getFigureHeight(), (Integer)c.getFigureWidth(), (String)mask);
                break;
            }
            case DOUBLE_CLICK: {
                mouse = TeslaScriptletFactory.makeMouseDoubleClick((int)c.getX(), (int)c.getY(), (Button)button, (Integer)c.getFigureHeight(), (Integer)c.getFigureWidth(), (String)mask);
                break;
            }
            case HOVER: {
                mouse = TeslaScriptletFactory.makeMouseHover((int)c.getX(), (int)c.getY(), (Button)button, (Integer)c.getFigureHeight(), (Integer)c.getFigureWidth(), (String)mask);
                break;
            }
            case DRAG: {
                mouse = TeslaScriptletFactory.makeMouseDrag((int)c.getX(), (int)c.getY(), (Button)button, (Integer)c.getFigureHeight(), (Integer)c.getFigureWidth(), (String)mask);
                break;
            }
            case ENTER: {
                mouse = TeslaScriptletFactory.makeMouseEnter((int)c.getX(), (int)c.getY(), (Button)button, (Integer)c.getFigureHeight(), (Integer)c.getFigureWidth(), (String)mask);
                break;
            }
            case EXIT: {
                mouse = TeslaScriptletFactory.makeMouseExit((int)c.getX(), (int)c.getY(), (Button)button, (Integer)c.getFigureHeight(), (Integer)c.getFigureWidth(), (String)mask);
                break;
            }
            default: {
                return TeslaScriptletFactory.unsupported((String)SimpleCommandPrinter.toString((Command)c));
            }
        }
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), ep, f, mouse});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ActivateCellEditor")
    protected org.eclipse.rcptt.ecl.core.Command activateCellEditor(ActivateCellEditor c) {
        org.eclipse.rcptt.ecl.core.Command selector = this.selectorOf(c.getElement());
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{selector, TeslaScriptletFactory.makeCellEditorActivate((Integer)c.getColumn(), (Integer)c.getType().getValue(), (Integer)c.getButton())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ApplyCellEditor")
    protected org.eclipse.rcptt.ecl.core.Command applyCellEditor(ApplyCellEditor c) {
        org.eclipse.rcptt.ecl.core.Command selector = this.selectorOf(c.getElement());
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{selector, TeslaScriptletFactory.makeCellEditorApply((boolean)c.isDeactivate())});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="CancelCellEditor")
    protected org.eclipse.rcptt.ecl.core.Command cancelCellEditor(CancelCellEditor c) {
        org.eclipse.rcptt.ecl.core.Command selector = this.selectorOf(c.getElement());
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{selector, TeslaScriptletFactory.makeCellEditorCancel()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="DeactivateCellEditor")
    protected org.eclipse.rcptt.ecl.core.Command deactivateCellEditor(DeactivateCellEditor c) {
        org.eclipse.rcptt.ecl.core.Command selector = this.selectorOf(c.getElement());
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{selector, TeslaScriptletFactory.makeCellEditorDeactivate()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/diagram", classifier="ActivateDirectEdit")
    protected org.eclipse.rcptt.ecl.core.Command activateDirectEdit(ActivateDirectEdit c) {
        if (c.getPartPath().isEmpty()) {
            return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeDirectEditActivate()});
        }
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeEditPart((List)c.getPartPath()), TeslaScriptletFactory.makeDirectEditActivate()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/diagram", classifier="CommitDirectEdit")
    protected org.eclipse.rcptt.ecl.core.Command applyDirectEdit(CommitDirectEdit c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeDirectEditCommit()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/diagram", classifier="CancelDirectEdit")
    protected org.eclipse.rcptt.ecl.core.Command cancelDirectEdit(CancelDirectEdit c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaScriptletFactory.makeDirectEditCancel()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Assert")
    protected org.eclipse.rcptt.ecl.core.Command assertCommand(Assert c) {
        org.eclipse.rcptt.ecl.core.Command s = this.selectorOf(c.getElement(), !ElementKind.EclipseWindow.name().equals(c.getElement().getKind()));
        GetProperty prop = TeslaParser.makeGetProperty((String)c.getAttribute());
        prop.setIndex(c.getIndex());
        switch (c.getKind()) {
            case EQUALS: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeEquals((String)c.getValue()), TeslaParser.makeVerifyTrue()});
            }
            case NOT_EQUALS: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeEquals((String)c.getValue()), TeslaParser.makeVerifyFalse()});
            }
            case ASSERT_TRUE: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeVerifyTrue()});
            }
            case ASSERT_FALSE: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeVerifyFalse()});
            }
            case IS_EMPTY: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeIsEmpty(), TeslaParser.makeVerifyTrue()});
            }
            case NOT_EMPTY: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeIsEmpty(), TeslaParser.makeVerifyFalse()});
            }
            case CONTAINS: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeContains((String)c.getValue()), TeslaParser.makeVerifyTrue()});
            }
            case NOT_CONTAINS: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeContains((String)c.getValue()), TeslaParser.makeVerifyFalse()});
            }
            case REGEXP: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeMatches((String)c.getValue()), TeslaParser.makeVerifyTrue()});
            }
            case NOT_REGEXP: {
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, prop, TeslaParser.makeMatches((String)c.getValue()), TeslaParser.makeVerifyFalse()});
            }
            case CONTAINS_IMAGE: {
                String fileContent = Base64.encode((byte[])c.getImageData().getImage());
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, TeslaParser.makeContainsImage((String)"base64://", (String)fileContent), TeslaParser.makeVerifyTrue()});
            }
            case IMAGE_CONTAINS_TEXT: {
                AssertImageData data = c.getImageData();
                return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{s, TeslaParser.makeRegionContainsText((int)data.getX(), (int)data.getY(), (int)data.getSx(), (int)data.getSy(), (int)data.getWidth(), (int)data.getHeight()), TeslaParser.makeContains((String)c.getValue()), TeslaParser.makeVerifyTrue()});
            }
        }
        return TeslaScriptletFactory.unsupported((String)SimpleCommandPrinter.toString((Command)c));
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ClickLink")
    protected org.eclipse.rcptt.ecl.core.Command clickLink(org.eclipse.rcptt.tesla.core.protocol.ClickLink c) {
        ClickLink result = TeslaFactory.eINSTANCE.createClickLink();
        result.setRef(c.getRef());
        return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), result});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Expand")
    protected org.eclipse.rcptt.ecl.core.Command expand(org.eclipse.rcptt.tesla.core.protocol.Expand e) {
        Expand result = TeslaFactory.eINSTANCE.createExpand();
        return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(e.getElement()), result});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="Collapse")
    protected org.eclipse.rcptt.ecl.core.Command collapse(Collapse c) {
        org.eclipse.rcptt.tesla.ecl.model.Collapse result = TeslaFactory.eINSTANCE.createCollapse();
        return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), result});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="MouseEvent")
    protected org.eclipse.rcptt.ecl.core.Command mouse(MouseEvent m) {
        Mouse result = TeslaFactory.eINSTANCE.createMouse();
        result.setButton(KeysAndButtons.getButtonNameSafe((int)m.getButton()));
        result.setCount(m.getCount());
        result.setEvent(m.getKind().getLiteral());
        int stateMask = m.getStateMask();
        if (m.getKind() == MouseEventKind.UP) {
            stateMask &= ~KeysAndButtons.getButtonMaskSafe((int)m.getButton());
        }
        result.setWith(KeysAndButtons.stateMaskToStr((int)stateMask));
        result.setX(m.getX());
        result.setY(m.getY());
        return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(m.getElement()), result});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="SetFocus")
    protected org.eclipse.rcptt.ecl.core.Command setFocus(org.eclipse.rcptt.tesla.core.protocol.SetFocus f) {
        if (f.isValue()) {
            SetFocus result = TeslaFactory.eINSTANCE.createSetFocus();
            return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(f.getElement()), result});
        }
        Unfocus result = TeslaFactory.eINSTANCE.createUnfocus();
        return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(f.getElement()), result});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ClickText")
    protected org.eclipse.rcptt.ecl.core.Command clickText(org.eclipse.rcptt.tesla.core.protocol.ClickText f) {
        ClickText result = TeslaFactory.eINSTANCE.createClickText();
        result.setStart(f.getStart());
        result.setEnd(f.getEnd());
        result.setButton(f.getButton());
        return TeslaParser.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(f.getElement()), result});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="WaitForRestart")
    protected org.eclipse.rcptt.ecl.core.Command waitForRestart(WaitForRestart c) {
        return TeslaFactory.eINSTANCE.createWaitUntilEclipseIsReady();
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ShowContentAssist")
    protected org.eclipse.rcptt.ecl.core.Command showContentAssist(ShowContentAssist c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{this.selectorOf(c.getElement()), TeslaFactory.eINSTANCE.createShowContentAssist()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ClickAboutMenu")
    protected org.eclipse.rcptt.ecl.core.Command clickAboutMenu(ClickAboutMenu c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{TeslaFactory.eINSTANCE.createGetAboutMenu(), TeslaFactory.eINSTANCE.createClick()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="ClickPreferencesMenu")
    protected org.eclipse.rcptt.ecl.core.Command clickPreferencesMenu(ClickPreferencesMenu c) {
        return TeslaScriptletFactory.makePipe((org.eclipse.rcptt.ecl.core.Command[])new org.eclipse.rcptt.ecl.core.Command[]{TeslaFactory.eINSTANCE.createGetPreferencesMenu(), TeslaFactory.eINSTANCE.createClick()});
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="RecordingModeRequest")
    protected org.eclipse.rcptt.ecl.core.Command recordingModeRequest(RecordingModeRequest c) {
        return null;
    }

    @TeslaCommand(packageUri="http://eclipse.org/rcptt/tesla/protocol", classifier="AssertionModeRequest")
    protected org.eclipse.rcptt.ecl.core.Command assertionModeRequest(AssertionModeRequest c) {
        return null;
    }

    protected org.eclipse.rcptt.ecl.core.Command selectorOf(Element e, boolean reduceEclipseWindow) {
        return this.selectorParser.selectorOf(e, reduceEclipseWindow);
    }

    public org.eclipse.rcptt.ecl.core.Command selectorOf(Element e) {
        return this.selectorParser.selectorOf(e, true);
    }

    protected <T> boolean match(Class<T> caster) {
        if (this.pos < 0 || this.pos >= this.teslaCommands.size()) {
            return false;
        }
        Command command = this.teslaCommands.get(this.pos);
        return caster.isInstance(command);
    }

    public static class RuleMap {
        private static Map<EClass, Method> ruleMap;
        private static final String EXTENSION_ID = "org.eclipse.rcptt.tesla.recording.core.ecl.parserExtension";
        private static final List<Object> extensions;

        static {
            extensions = new ArrayList<Object>();
        }

        public static Method ruleFor(EClass eClass) {
            Method rule;
            if (ruleMap == null) {
                RuleMap.init();
            }
            if ((rule = ruleMap.get(eClass)) != null) {
                return rule;
            }
            return null;
        }

        private static synchronized void init() {
            ruleMap = new HashMap<EClass, Method>();
            RuleMap.putRulesFrom(TeslaParser.class);
            RuleMap.initExtensions();
            for (Object ext : extensions) {
                RuleMap.putRulesFrom(ext.getClass());
            }
        }

        private static void putRulesFrom(Class<?> klass) throws AssertionError {
            Method[] declaredMethods;
            Method[] methodArray = declaredMethods = klass.getDeclaredMethods();
            int n = declaredMethods.length;
            int n2 = 0;
            while (n2 < n) {
                EPackage ePackage;
                EClass eClass;
                Method method = methodArray[n2];
                TeslaCommand teslaCommand = method.getAnnotation(TeslaCommand.class);
                if (teslaCommand != null && ruleMap.put(eClass = (EClass)(ePackage = EPackage.Registry.INSTANCE.getEPackage(teslaCommand.packageUri())).getEClassifier(teslaCommand.classifier()), method) != null) {
                    throw new AssertionError();
                }
                ++n2;
            }
        }

        private static void initExtensions() {
            IConfigurationElement[] config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_ID);
            try {
                IConfigurationElement[] iConfigurationElementArray = config;
                int n = config.length;
                int n2 = 0;
                while (n2 < n) {
                    IConfigurationElement element = iConfigurationElementArray[n2];
                    Object extension = element.createExecutableExtension("class");
                    extensions.add(extension);
                    ++n2;
                }
            }
            catch (CoreException e) {
                TeslaRecordingPlugin.log("Error while get tesla parser extension.", e);
            }
        }
    }
}

