/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.commons;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public abstract class ArrayTransfer
extends ByteArrayTransfer {
    protected void javaToNative(Object object, TransferData transferData) {
        if (!(object instanceof Object[])) {
            return;
        }
        Object[] objects = (Object[])object;
        int count = objects.length;
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream objectOut = new ObjectOutputStream(out);
            objectOut.writeInt(count);
            int i = 0;
            while (i < objects.length) {
                objectOut.writeObject(objects[i]);
                ++i;
            }
            objectOut.close();
            out.close();
            byte[] bytes = out.toByteArray();
            super.javaToNative((Object)bytes, transferData);
        }
        catch (IOException e) {
            Q7UIPlugin.log(e);
        }
    }

    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        if (bytes == null) {
            return null;
        }
        try {
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(bytes));
            int count = in.readInt();
            Object[] objects = new Object[count];
            int i = 0;
            while (i < count) {
                objects[i] = in.readObject();
                ++i;
            }
            in.close();
            return objects;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }
}

