/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.versioning.updaters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.versioning.IQ7VersionManager;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.CommandToElementEntry;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.TeslaScenario;
import org.eclipse.rcptt.tesla.internal.core.ModelUtils;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;

public class TeslaElementUpdater
implements IQ7VersionManager {
    @Override
    public void updateElement(NamedElement element, boolean allowSave) {
        Scenario sc;
        EObject content;
        double version = this.getVersion(element);
        if (version < 3.0 && element instanceof Scenario && (content = (sc = (Scenario)element).getContent()) instanceof TeslaScenario) {
            this.updateScenario((TeslaScenario)content);
        }
    }

    public void updateScenario(TeslaScenario content) {
        EList commands = content.getCommands();
        EList mappingRaw = content.getElementMapping();
        HashSet<String> resolvedNames = new HashSet<String>();
        HashMap<Command, CommandToElementEntry> mapping = new HashMap<Command, CommandToElementEntry>();
        for (CommandToElementEntry mapEntry : mappingRaw) {
            Command command = mapEntry.getCommand();
            mapping.put(command, mapEntry);
        }
        ElementGenerator gen = new ElementGenerator();
        HashMap<String, Element> updateMap = new HashMap<String, Element>();
        for (Command cmd : commands) {
            CommandToElementEntry entry = (CommandToElementEntry)mapping.get(cmd);
            if (entry != null) {
                EList elements = entry.getElements();
                ArrayList<Element> newElements = new ArrayList<Element>();
                for (Element element : elements) {
                    String key = ModelUtils.makeKey((Element)element);
                    if (resolvedNames.contains(key)) {
                        Element newElement = this.generateElement(gen, resolvedNames, element);
                        String newKey = ModelUtils.makeKey((Element)newElement);
                        updateMap.put(key, newElement);
                        resolvedNames.add(newKey);
                        newElements.add(newElement);
                        continue;
                    }
                    resolvedNames.add(key);
                    updateMap.put(key, element);
                    newElements.add(element);
                }
                entry.getElements().clear();
                entry.getElements().addAll(newElements);
            }
            ModelUtils.updateElementsAccordingTo((EObject)cmd, updateMap, new HashSet());
        }
    }

    private Element generateElement(ElementGenerator gen, Set<String> resolvedNames, Element element) {
        Element g = gen.generate(element.getKind());
        while (resolvedNames.contains(ModelUtils.makeKey((Element)g))) {
            gen.updateToNext(g);
        }
        return g;
    }

    private double getVersion(NamedElement e) {
        try {
            return Double.parseDouble(e.getVersion());
        }
        catch (NumberFormatException ee) {
            return 1.0;
        }
    }
}

