/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import java.util.Collections;
import java.util.Vector;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.internal.core.ischema.ISchemaEnumeration;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaRestriction;
import org.eclipse.pde.internal.core.ischema.ISchemaSimpleType;
import org.eclipse.pde.internal.core.schema.ChoiceRestriction;
import org.eclipse.pde.internal.core.schema.SchemaAttribute;
import org.eclipse.pde.internal.core.schema.SchemaEnumeration;
import org.eclipse.pde.internal.core.schema.SchemaSimpleType;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.schema.ElementSection;
import org.eclipse.pde.internal.ui.editor.schema.NewRestrictionDialog;
import org.eclipse.pde.internal.ui.editor.schema.SchemaAttributeDetails;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class SchemaStringAttributeDetails
extends SchemaAttributeDetails {
    private Button fTransTrue;
    private Button fTransFalse;
    private TableViewer fRestrictionsTable;
    private Button fAddRestriction;
    private Button fRemoveRestriction;

    public SchemaStringAttributeDetails(ElementSection section) {
        super(section);
    }

    @Override
    protected void createTypeDetails(Composite parent, FormToolkit toolkit) {
        Color foreground = toolkit.getColors().getColor("org.eclipse.ui.forms.TITLE");
        Label label = toolkit.createLabel(parent, PDEUIMessages.SchemaDetails_translatable);
        label.setForeground(foreground);
        GridData gd = new GridData(2);
        gd.horizontalIndent = 11;
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        Button[] buttons = this.createTrueFalseButtons(parent, toolkit, 2);
        this.fTransTrue = buttons[0];
        this.fTransFalse = buttons[1];
        label = toolkit.createLabel(parent, PDEUIMessages.SchemaAttributeDetails_restrictions);
        label.setForeground(foreground);
        gd = new GridData(2);
        gd.horizontalIndent = 11;
        gd.verticalIndent = 2;
        label.setLayoutData((Object)gd);
        Composite tableComp = toolkit.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        tableComp.setLayout((Layout)layout);
        tableComp.setLayoutData((Object)new GridData(768));
        Table table = toolkit.createTable(tableComp, 2562);
        gd = new GridData(768);
        gd.heightHint = 40;
        gd.horizontalIndent = 3;
        table.setLayoutData((Object)gd);
        this.fRestrictionsTable = new TableViewer(table);
        this.fRestrictionsTable.setContentProvider((IContentProvider)new SchemaAttributeDetails.SchemaAttributeContentProvider());
        this.fRestrictionsTable.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        Composite resButtonComp = toolkit.createComposite(parent);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        resButtonComp.setLayout((Layout)layout);
        resButtonComp.setLayoutData((Object)new GridData(2));
        this.fAddRestriction = toolkit.createButton(resButtonComp, PDEUIMessages.SchemaAttributeDetails_addRestButton, 0);
        this.fRemoveRestriction = toolkit.createButton(resButtonComp, PDEUIMessages.SchemaAttributeDetails_removeRestButton, 0);
        this.fAddRestriction.setLayoutData((Object)new GridData(768));
        this.fRemoveRestriction.setLayoutData((Object)new GridData(768));
    }

    @Override
    public void updateFields(ISchemaObject object) {
        if (!(object instanceof SchemaAttribute)) {
            return;
        }
        super.updateFields(object);
        this.fTransTrue.setSelection(this.getAttribute().isTranslatable());
        this.fTransFalse.setSelection(!this.getAttribute().isTranslatable());
        this.fRestrictionsTable.setInput(new Object());
        boolean editable = this.isEditableElement();
        this.fTransTrue.setEnabled(editable);
        this.fTransFalse.setEnabled(editable);
        this.fRestrictionsTable.getControl().setEnabled(editable);
        this.fAddRestriction.setEnabled(editable);
        this.fRemoveRestriction.setEnabled(!this.fRestrictionsTable.getStructuredSelection().isEmpty() && editable);
    }

    @Override
    public void hookListeners() {
        super.hookListeners();
        this.fTransTrue.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            this.getAttribute().setTranslatableProperty(this.fTransTrue.getSelection());
        }));
        this.fAddRestriction.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            NewRestrictionDialog dialog = new NewRestrictionDialog(this.getPage().getSite().getShell());
            if (dialog.open() != 0) {
                return;
            }
            String text = dialog.getNewRestriction();
            if (text != null && text.length() > 0) {
                ISchemaSimpleType type = this.getAttribute().getType();
                ChoiceRestriction res = (ChoiceRestriction)type.getRestriction();
                Vector<SchemaEnumeration> vres = new Vector<SchemaEnumeration>();
                if (res != null) {
                    ISchemaEnumeration[] currRes = res.getChildren();
                    Collections.addAll(vres, currRes);
                }
                vres.add(new SchemaEnumeration((ISchemaObject)this.getAttribute().getSchema(), text));
                if (res == null) {
                    res = new ChoiceRestriction(this.getAttribute().getSchema());
                }
                res.setChildren(vres);
                if (type instanceof SchemaSimpleType) {
                    ((SchemaSimpleType)type).setRestriction((ISchemaRestriction)res);
                }
                this.fRestrictionsTable.refresh();
            }
        }));
        this.fRemoveRestriction.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            if (this.blockListeners()) {
                return;
            }
            IStructuredSelection selection = this.fRestrictionsTable.getStructuredSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object[] aselection = selection.toArray();
            ISchemaSimpleType type = this.getAttribute().getType();
            ChoiceRestriction res = (ChoiceRestriction)type.getRestriction();
            Vector<ISchemaEnumeration> vres = new Vector<ISchemaEnumeration>();
            if (res != null) {
                ISchemaEnumeration[] currRes;
                ISchemaEnumeration[] iSchemaEnumerationArray = currRes = res.getChildren();
                int n = currRes.length;
                int n2 = 0;
                while (n2 < n) {
                    ISchemaEnumeration currRe = iSchemaEnumerationArray[n2];
                    boolean stays = true;
                    Object[] objectArray = aselection;
                    int n3 = aselection.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Object element = objectArray[n4];
                        if (currRe.equals(element)) {
                            stays = false;
                        }
                        ++n4;
                    }
                    if (stays) {
                        vres.add(currRe);
                    }
                    ++n2;
                }
                res.setChildren(vres);
                if (type instanceof SchemaSimpleType) {
                    if (vres.isEmpty()) {
                        ((SchemaSimpleType)type).setRestriction(null);
                    } else {
                        ((SchemaSimpleType)type).setRestriction((ISchemaRestriction)res);
                    }
                }
                this.fRestrictionsTable.refresh();
            }
        }));
        this.fRestrictionsTable.addSelectionChangedListener(event -> {
            if (this.blockListeners()) {
                return;
            }
            this.fRemoveRestriction.setEnabled(this.getAttribute().getSchema().isEditable() && !event.getSelection().isEmpty());
        });
    }
}

