/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.templating;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.pde.osgi.xmlns.metatype.v1_4.Tad;
import org.eclipse.pde.osgi.xmlns.metatype.v1_4.Ticon;
import org.eclipse.pde.osgi.xmlns.metatype.v1_4.Tocd;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

class JaxbObjectClassDefinition
implements ObjectClassDefinition {
    private final Tocd ocd;

    public JaxbObjectClassDefinition(Tocd ocd) {
        if (ocd == null) {
            throw new NullPointerException();
        }
        this.ocd = ocd;
    }

    public String getName() {
        return this.ocd.getName();
    }

    public String getID() {
        return this.ocd.getId();
    }

    public String getDescription() {
        return this.ocd.getDescription();
    }

    public AttributeDefinition[] getAttributeDefinitions(int filter) {
        Stream<Tad> stream = this.ocd.getADOrIconOrAny().stream().filter(Tad.class::isInstance).map(Tad.class::cast);
        if (filter == 2) {
            stream = stream.filter(Predicate.not(Tad::isRequired));
        } else if (filter == 1) {
            stream = stream.filter(Tad::isRequired);
        } else if (filter != -1) {
            return null;
        }
        AttributeDefinition[] definitions = (AttributeDefinition[])stream.toArray(AttributeDefinition[]::new);
        if (definitions.length == 0) {
            return null;
        }
        return definitions;
    }

    public InputStream getIcon(int size) throws IOException {
        List<Ticon> icons = this.ocd.getADOrIconOrAny().stream().filter(Ticon.class::isInstance).map(Ticon.class::cast).toList();
        if (icons.isEmpty()) {
            throw new FileNotFoundException();
        }
        for (Ticon icon : icons) {
            if (icon.getSize().intValue() != size) continue;
            return new URL(icon.getResource()).openStream();
        }
        return new URL(icons.get(0).getResource()).openStream();
    }
}

