/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.workspace.Q7Utils;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.FileUtil;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public abstract class BasePersistenceModel
implements IPersistenceModel {
    private static final Bundle BUNDLE = FrameworkUtil.getBundle(BasePersistenceModel.class);
    private static final ILog LOG = Platform.getLog((Bundle)BUNDLE);
    protected final Map<String, File> files = new HashMap<String, File>();
    protected final Resource element;
    protected final File root;
    protected final IPath rootPath;
    private boolean modified = false;
    private byte[] internalContent = null;
    private Set<String> extractions = new HashSet<String>();
    private boolean disposed = false;

    protected abstract void doExtractAll(InputStream var1) throws IOException;

    protected abstract void doExtractFile(String var1, InputStream var2) throws IOException;

    protected abstract void doReadIndex(InputStream var1) throws IOException;

    protected abstract void doStoreTo(File var1) throws FileNotFoundException, IOException;

    @Override
    public boolean isContentEntryRequired() {
        return true;
    }

    @Override
    public boolean isAllowEmptyMetadataContent() {
        return false;
    }

    public BasePersistenceModel(Resource element) {
        java.nio.file.Path dir;
        this.element = element;
        Object nonExistent = null;
        RcpttPlugin default1 = RcpttPlugin.getDefault();
        assert (default1 != null);
        String uri = element == null || element.getURI() == null ? "_" : element.getURI().toString();
        java.nio.file.Path baseDirectory = default1.getStateLocation().append("attachments").toFile().toPath();
        try {
            Files.createDirectories(baseDirectory, new FileAttribute[0]);
            dir = Files.createTempDirectory(baseDirectory, FileUtil.limitSize((String)FileUtil.getID((String)uri)), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to create a temporary directory in " + String.valueOf(baseDirectory), e);
        }
        this.rootPath = Path.fromOSString((String)dir.toString());
        this.root = this.rootPath.toFile();
        try {
            this.readIndex();
        }
        catch (CoreException e) {
            LOG.log((IStatus)this.toMultiStatus("Failed to read " + String.valueOf(Q7Utils.getLocation(element)), e));
        }
        catch (IOException e) {
            this.error("Failed to read " + String.valueOf(Q7Utils.getLocation(element)), e);
        }
    }

    private MultiStatus toMultiStatus(String message, CoreException e) {
        return new MultiStatus(BUNDLE.getSymbolicName(), 0, new IStatus[]{e.getStatus()}, message, (Throwable)e);
    }

    @Override
    public Resource getResource() {
        return this.element;
    }

    public void setInternalContent(byte[] internalContent) {
        this.internalContent = internalContent;
        try {
            this.readIndex();
        }
        catch (CoreException e) {
            LOG.log((IStatus)this.toMultiStatus("Failed to write " + String.valueOf(Q7Utils.getLocation(this.element)), e));
        }
        catch (IOException e) {
            this.error("Failed to write " + String.valueOf(Q7Utils.getLocation(this.element)), e);
        }
    }

    private void initialize() {
        assert (!this.disposed);
        this.root.mkdirs();
    }

    @Override
    public boolean hasElements() {
        return !this.files.isEmpty();
    }

    @Override
    public String[] getNames() {
        return this.files.keySet().toArray(new String[this.files.size()]);
    }

    private void readIndex() throws CoreException, IOException {
        assert (!this.disposed);
        Throwable throwable = null;
        Object var2_3 = null;
        try (InputStream contents = this.getContentsStream();){
            if (contents == null) {
                return;
            }
            this.doReadIndex(contents);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected InputStream getContentsStream() {
        IFile file;
        InputStream input;
        block7: {
            input = null;
            IFile iFile = file = this.element != null ? Q7Utils.getLocation(this.element) : null;
            if (file != null && !file.exists()) {
                return null;
            }
            if (this.internalContent != null) {
                input = new ByteArrayInputStream(this.internalContent);
            }
            try {
                if (input != null || file != null) break block7;
                return null;
            }
            catch (CoreException e) {
                int code = e.getStatus().getCode();
                if (code == 369 || code == 368 || code == 271) {
                    return null;
                }
                throw new IllegalStateException("Error code: " + code, e);
            }
        }
        if (input == null) {
            input = file.getContents();
        }
        BufferedInputStream contents = new BufferedInputStream(input);
        return contents;
    }

    protected File putFileItem(String name, IPath filePath) {
        return this.files.put(name, filePath.toFile());
    }

    @Override
    public synchronized void dispose() {
        if (this.disposed) {
            return;
        }
        this.removeAll();
        this.disposed = true;
    }

    @Override
    public final synchronized InputStream read(String name) {
        File file = this.extractEntryIfNotYet(name);
        if (file == null) {
            return null;
        }
        if (file.exists()) {
            try {
                return this.getInput(file);
            }
            catch (FileNotFoundException e) {
                RcpttPlugin.log(e);
            }
        }
        return null;
    }

    private File extractEntryIfNotYet(String name) {
        if (this.disposed) {
            throw new IllegalStateException("Disposed");
        }
        File file = this.files.get(name);
        if (file == null) {
            return null;
        }
        this.waitUntilExtracted(name);
        try {
            if (!file.exists()) {
                this.extractFile(name);
                this.waitUntilExtracted(name);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Can't extract " + name + " from " + String.valueOf(this.element), e);
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void waitUntilExtracted(String name) {
        Set<String> set = this.extractions;
        synchronized (set) {
            while (true) {
                if (!this.extractions.contains(name)) {
                    return;
                }
                try {
                    this.extractions.wait(100L);
                }
                catch (InterruptedException e) {
                    RcpttPlugin.log(e);
                }
            }
        }
    }

    protected BufferedInputStream getInput(File file) throws FileNotFoundException {
        return new BufferedInputStream(new FileInputStream(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void extractFile(String fName) throws IOException {
        InputStream contents;
        block29: {
            this.initialize();
            contents = null;
            try {
                block28: {
                    Set<String> set = this.extractions;
                    // MONITORENTER : set
                    if (!this.extractions.contains(fName)) break block28;
                    // MONITOREXIT : set
                    Set<String> set2 = this.extractions;
                    {
                        catch (Throwable throwable) {
                            // MONITOREXIT : set
                            throw throwable;
                        }
                    }
                    // MONITORENTER : set2
                    this.extractions.remove(fName);
                    this.extractions.notifyAll();
                    // MONITOREXIT : set2
                    try {
                        if (contents == null) return;
                        contents.close();
                        return;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                this.extractions.add(fName);
                // MONITOREXIT : set
                contents = this.getContentsStream();
                if (contents != null) break block29;
                Set<String> set = this.extractions;
            }
            catch (Throwable throwable) {
                Set<String> set = this.extractions;
                // MONITORENTER : set
                this.extractions.remove(fName);
                this.extractions.notifyAll();
                // MONITOREXIT : set
                try {
                    if (contents == null) throw throwable;
                    contents.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            this.extractions.remove(fName);
            this.extractions.notifyAll();
            // MONITOREXIT : set
            try {
                if (contents == null) return;
                contents.close();
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        this.doExtractFile(fName, contents);
        Set<String> set = this.extractions;
        // MONITORENTER : set
        this.extractions.remove(fName);
        this.extractions.notifyAll();
        // MONITOREXIT : set
        try {
            if (contents == null) return;
            contents.close();
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public synchronized void delete(String name) {
        File file = this.files.get(name);
        if (file != null && file.exists()) {
            file.delete();
        }
        this.files.remove(name);
    }

    @Override
    public synchronized boolean restore(String name) {
        File file = this.files.get(name);
        if (file != null && file.exists()) {
            file.delete();
            try {
                this.extractFile(name);
            }
            catch (IOException e) {
                throw new IllegalStateException("Can't extract " + name + " from " + String.valueOf(this.element), e);
            }
            return file.exists();
        }
        return false;
    }

    @Override
    public OutputStream store(String name) {
        this.modified = true;
        return this.internalStore(name);
    }

    protected OutputStream internalStore(String name) {
        this.initialize();
        IPath path = this.rootPath.append((IPath)new Path(name));
        File file = path.toFile();
        file.getParentFile().mkdirs();
        this.files.put(name, file);
        try {
            return new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (FileNotFoundException e) {
            RcpttPlugin.log(e);
            return null;
        }
    }

    @Override
    public void extractAll() {
        this.initialize();
        InputStream contents = null;
        try {
            contents = this.getContentsStream();
            if (contents == null) {
                return;
            }
            try {
                this.doExtractAll(contents);
            }
            catch (Throwable e1) {
                RcpttPlugin.log(e1);
            }
        }
        finally {
            try {
                if (contents != null) {
                    contents.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    @Override
    public File storeToTemporaty() {
        this.initialize();
        File file = this.rootPath.append(".q7.content.temporary" + System.currentTimeMillis()).toFile();
        try {
            this.doStoreTo(file);
        }
        catch (Exception e) {
            RcpttPlugin.log(e);
        }
        return file;
    }

    @Override
    public void removeAll() {
        this.files.clear();
        if (this.root != null) {
            FileUtil.deleteFiles((File[])this.root.listFiles());
            this.root.delete();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean copyFrom(IPersistenceModel originalModel) {
        String[] names;
        this.removeAll();
        String[] stringArray = names = originalModel.getNames();
        int n = names.length;
        int n2 = 0;
        while (true) {
            block17: {
                if (n2 >= n) {
                    if (names.length <= 0) return false;
                    return true;
                }
                String name = stringArray[n2];
                try {
                    Throwable throwable = null;
                    Object var8_10 = null;
                    try {
                        InputStream inputStream = originalModel.read(name);
                        try {
                            try (OutputStream outputStream = this.store(name);){
                                FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                            }
                            if (inputStream == null) break block17;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (inputStream == null) throw throwable;
                            inputStream.close();
                            throw throwable;
                        }
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                            throw throwable;
                        }
                        if (throwable == throwable3) throw throwable;
                        throwable.addSuppressed(throwable3);
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    throw new IllegalStateException(e);
                }
            }
            ++n2;
        }
    }

    @Override
    public boolean isModified() {
        return this.modified;
    }

    @Override
    public void updateMetadata() {
    }

    @Override
    public void updateAttributes() {
    }

    @Override
    public void setUnmodified() {
        this.modified = false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void rename(String oldName, String newName) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try {
                InputStream read = this.read(oldName);
                try {
                    try (OutputStream store = this.store(newName);){
                        if (read != null) {
                            FileUtil.copy((InputStream)read, (OutputStream)store);
                            this.delete(oldName);
                        }
                    }
                    if (read == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (read == null) throw throwable;
                    read.close();
                    throw throwable;
                }
                read.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    void error(String message, Exception e) {
        LOG.log((IStatus)new Status(4, BUNDLE.getSymbolicName(), 0, message, (Throwable)e));
    }

    void error(String message) {
        this.error(message, null);
    }
}

