/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee8.nested.jmx;

import org.eclipse.jetty.ee8.nested.AbstractHandler;
import org.eclipse.jetty.ee8.nested.ContextHandler;
import org.eclipse.jetty.jmx.ObjectMBean;
import org.eclipse.jetty.server.Server;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractHandlerMBean
extends ObjectMBean {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractHandlerMBean.class);

    public AbstractHandlerMBean(Object managedObject) {
        super(managedObject);
    }

    public String getObjectContextBasis() {
        if (this._managed != null) {
            AbstractHandler handler;
            Server server;
            String basis = null;
            if (this._managed instanceof ContextHandler) {
                ContextHandler handler2 = (ContextHandler)this._managed;
                String context = this.getContextName(handler2);
                if (context == null) {
                    context = handler2.getDisplayName();
                }
                if (context != null) {
                    return context;
                }
            } else if (!(this._managed instanceof AbstractHandler) || (server = (handler = (AbstractHandler)this._managed).getServer()) != null) {
                // empty if block
            }
            if (basis != null) {
                return basis;
            }
        }
        return super.getObjectContextBasis();
    }

    protected String getContextName(ContextHandler context) {
        Object name = null;
        if (context.getContextPath() != null && context.getContextPath().length() > 0) {
            int idx = context.getContextPath().lastIndexOf(47);
            Object object = name = idx < 0 ? context.getContextPath() : context.getContextPath().substring(++idx);
            if (name == null || ((String)name).length() == 0) {
                name = "ROOT";
            }
        }
        if (name == null && context.getBaseResource() != null && context.getBaseResource().getPath() != null) {
            name = context.getBaseResource().getPath().getFileName().toString();
        }
        if (context.getVirtualHosts() != null && context.getVirtualHosts().length > 0) {
            name = "\"" + (String)name + "@" + context.getVirtualHosts()[0] + "\"";
        }
        return name;
    }
}

