/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.migrationsupport.rules.adapter;

import java.lang.reflect.Method;
import org.apiguardian.api.API;
import org.junit.jupiter.migrationsupport.rules.adapter.GenericBeforeAndAfterAdvice;
import org.junit.jupiter.migrationsupport.rules.member.TestRuleAnnotatedMember;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.rules.TestRule;

@API(status=API.Status.INTERNAL, since="5.0")
public abstract class AbstractTestRuleAdapter
implements GenericBeforeAndAfterAdvice {
    private final TestRule target;

    public AbstractTestRuleAdapter(TestRuleAnnotatedMember annotatedMember, Class<? extends TestRule> adapteeClass) {
        this.target = annotatedMember.getTestRule();
        Preconditions.condition((boolean)adapteeClass.isAssignableFrom(this.target.getClass()), () -> adapteeClass + " is not assignable from " + this.target.getClass());
    }

    protected Object executeMethod(String name) {
        return this.executeMethod(name, new Class[0], new Object[0]);
    }

    protected Object executeMethod(String methodName, Class<?>[] parameterTypes, Object ... arguments) {
        Method method = (Method)ReflectionSupport.findMethod((Class)this.target.getClass(), (String)methodName, (Class[])parameterTypes).orElseThrow(() -> new JUnitException(String.format("Failed to find method %s(%s) in class %s", methodName, ClassUtils.nullSafeToString((Class[])parameterTypes), this.target.getClass().getName())));
        return ReflectionSupport.invokeMethod((Method)method, (Object)this.target, (Object[])arguments);
    }
}

