/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.rebase;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.CompareUI;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.internal.FileChecker;
import org.eclipse.egit.core.internal.util.ProjectUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.commands.shared.AbortRebaseCommand;
import org.eclipse.egit.ui.internal.commands.shared.AbstractRebaseCommandHandler;
import org.eclipse.egit.ui.internal.commands.shared.SkipRebaseCommand;
import org.eclipse.egit.ui.internal.dialogs.CleanupUncomittedChangesDialog;
import org.eclipse.egit.ui.internal.merge.GitMergeEditorInput;
import org.eclipse.egit.ui.internal.merge.MergeInputMode;
import org.eclipse.egit.ui.internal.merge.MergeModeDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jgit.api.RebaseResult;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevWalk;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class RebaseResultDialog
extends MessageDialog {
    private static final String SPACE = " ";
    private static final Image INFO = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_INFO_TSK");
    private final RebaseResult result;
    private final Repository repo;
    private final Set<String> conflictPaths = new HashSet<String>();
    private Button toggleButton;
    private Button startMergeButton;
    private Button skipCommitButton;
    private Button abortRebaseButton;
    private Button doNothingButton;
    private Group nextStepsGroup;

    public static void show(RebaseResult result, Repository repository) {
        switch (result.getStatus()) {
            case ABORTED: 
            case INTERACTIVE_PREPARED: {
                return;
            }
            case CONFLICTS: {
                PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
                    Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                    CleanupUncomittedChangesDialog dialog = new CleanupUncomittedChangesDialog(shell, UIText.BranchResultDialog_CheckoutConflictsTitle, UIText.AbstractRebaseCommandHandler_cleanupDialog_text, repository, result.getConflicts(), false);
                    dialog.open();
                });
                return;
            }
            case STOPPED: 
            case STASH_APPLY_CONFLICTS: {
                break;
            }
            default: {
                if (Activator.getDefault().getPreferenceStore().getBoolean("show_rebase_confirm")) break;
                return;
            }
        }
        PlatformUI.getWorkbench().getDisplay().asyncExec(() -> {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            new RebaseResultDialog(shell, repository, result).open();
        });
    }

    private static String getTitle(RebaseResult.Status status) {
        switch (status) {
            case OK: {
                return UIText.RebaseResultDialog_SuccessfullyFinished;
            }
            case ABORTED: {
                return UIText.RebaseResultDialog_Aborted;
            }
            case STOPPED: {
                return UIText.RebaseResultDialog_Stopped;
            }
            case EDIT: {
                return UIText.RebaseResultDialog_Edit;
            }
            case FAILED: {
                return UIText.RebaseResultDialog_Failed;
            }
            case UP_TO_DATE: {
                return UIText.RebaseResultDialog_UpToDate;
            }
            case FAST_FORWARD: {
                return UIText.RebaseResultDialog_FastForward;
            }
            case NOTHING_TO_COMMIT: {
                return UIText.RebaseResultDialog_NothingToCommit;
            }
            case INTERACTIVE_PREPARED: {
                return UIText.RebaseResultDialog_InteractivePrepared;
            }
            case UNCOMMITTED_CHANGES: {
                return UIText.RebaseResultDialog_UncommittedChanges;
            }
            case STASH_APPLY_CONFLICTS: {
                return UIText.RebaseResultDialog_SuccessfullyFinished + ".\n" + UIText.RebaseResultDialog_stashApplyConflicts;
            }
        }
        throw new IllegalStateException(status.name());
    }

    public static String getStatusText(RebaseResult.Status status) {
        switch (status) {
            case OK: {
                return UIText.RebaseResultDialog_StatusOK;
            }
            case ABORTED: {
                return UIText.RebaseResultDialog_StatusAborted;
            }
            case STOPPED: {
                return UIText.RebaseResultDialog_StatusStopped;
            }
            case EDIT: {
                return UIText.RebaseResultDialog_StatusEdit;
            }
            case FAILED: {
                return UIText.RebaseResultDialog_StatusFailed;
            }
            case CONFLICTS: {
                return UIText.RebaseResultDialog_StatusConflicts;
            }
            case UP_TO_DATE: {
                return UIText.RebaseResultDialog_StatusUpToDate;
            }
            case FAST_FORWARD: {
                return UIText.RebaseResultDialog_StatusFastForward;
            }
            case NOTHING_TO_COMMIT: {
                return UIText.RebaseResultDialog_StatusNothingToCommit;
            }
            case UNCOMMITTED_CHANGES: {
                return UIText.RebaseResultDialog_UncommittedChanges;
            }
            case INTERACTIVE_PREPARED: {
                return UIText.RebaseResultDialog_StatusInteractivePrepared;
            }
            case STASH_APPLY_CONFLICTS: {
                return UIText.RebaseResultDialog_SuccessfullyFinished + ".\n" + UIText.RebaseResultDialog_stashApplyConflicts;
            }
        }
        return status.toString();
    }

    private static String[] getButtonLabel(RebaseResult.Status status) {
        String[] buttonLabel = new String[1];
        switch (status) {
            case STOPPED: 
            case EDIT: 
            case CONFLICTS: 
            case INTERACTIVE_PREPARED: 
            case STASH_APPLY_CONFLICTS: {
                buttonLabel[0] = IDialogConstants.PROCEED_LABEL;
                break;
            }
            default: {
                buttonLabel[0] = IDialogConstants.CLOSE_LABEL;
            }
        }
        return buttonLabel;
    }

    private RebaseResultDialog(Shell shell, Repository repository, RebaseResult result) {
        super(shell, UIText.RebaseResultDialog_DialogTitle, INFO, RebaseResultDialog.getTitle(result.getStatus()), result.getStatus() == RebaseResult.Status.FAILED ? 1 : 2, RebaseResultDialog.getButtonLabel(result.getStatus()), 0);
        this.setShellStyle(this.getShellStyle() | 0x4F0);
        this.repo = repository;
        this.result = result;
    }

    protected Control createCustomArea(Composite parent) {
        if (this.result.getStatus() == RebaseResult.Status.STOPPED) {
            return this.createStoppedDialogArea(parent);
        }
        if (this.result.getStatus() == RebaseResult.Status.FAILED || this.result.getStatus() == RebaseResult.Status.CONFLICTS) {
            return this.createFailedOrConflictDialog(parent);
        }
        this.createToggleButton(parent);
        return null;
    }

    private Control createFailedOrConflictDialog(Composite parent) {
        Composite composite = new Composite(parent, 0);
        RebaseResultDialog.createFailedOrConflictsParts(composite, this.result);
        return composite;
    }

    public static void createFailedOrConflictsParts(Composite composite, RebaseResult result) {
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        composite.setLayout((Layout)gridLayout);
        Label resultLabel = new Label(composite, 0);
        resultLabel.setText(UIText.MergeResultDialog_result);
        resultLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        Text resultText = new Text(composite, 10);
        resultText.setText(RebaseResultDialog.getStatusText(result.getStatus()).replace("\n", Text.DELIMITER));
        if (!result.getStatus().isSuccessful()) {
            resultText.setForeground(composite.getParent().getDisplay().getSystemColor(3));
        }
        resultText.setSelection(resultText.getCaretPosition());
        resultText.setLayoutData((Object)new GridData(4, 4, true, false));
        if (result.getStatus() == RebaseResult.Status.FAILED) {
            StringBuilder paths = new StringBuilder();
            Label pathsLabel = new Label(composite, 0);
            pathsLabel.setText(UIText.MergeResultDialog_failed);
            pathsLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
            Text pathsText = new Text(composite, 10);
            pathsText.setLayoutData((Object)new GridData(4, 4, false, false));
            Set failedPaths = result.getFailingPaths().entrySet();
            int n = 0;
            for (Map.Entry e : failedPaths) {
                if (n > 0) {
                    paths.append(Text.DELIMITER);
                }
                paths.append(e.getValue());
                paths.append("\t");
                paths.append((String)e.getKey());
                if (++n > 10 && failedPaths.size() > 15) break;
            }
            if (n < failedPaths.size()) {
                paths.append(Text.DELIMITER);
                paths.append(MessageFormat.format(UIText.MergeResultDialog_nMore, n - failedPaths.size()));
            }
            pathsText.setText(paths.toString());
        } else if (result.getStatus() == RebaseResult.Status.CONFLICTS) {
            StringBuilder paths = new StringBuilder();
            Label pathsLabel = new Label(composite, 0);
            pathsLabel.setText(UIText.MergeResultDialog_conflicts);
            pathsLabel.setLayoutData((Object)new GridData(16384, 128, false, false));
            Text pathsText = new Text(composite, 10);
            pathsText.setLayoutData((Object)new GridData(4, 4, false, false));
            List conflList = result.getConflicts();
            int n = 0;
            for (String e : conflList) {
                if (n > 0) {
                    paths.append(Text.DELIMITER);
                }
                paths.append(e);
                if (++n > 10 && conflList.size() > 15) break;
            }
            if (n < conflList.size()) {
                paths.append(Text.DELIMITER);
                paths.append(MessageFormat.format(UIText.MergeResultDialog_nMore, n - conflList.size()));
            }
            pathsText.setText(paths.toString());
        }
    }

    private Control createStoppedDialogArea(Composite parent) {
        FileChecker.CheckResult checkResult;
        boolean conflictListFailure;
        Group commitGroup;
        Composite main;
        block27: {
            main = new Composite(parent, 0);
            main.setLayout((Layout)new GridLayout(1, false));
            GridDataFactory.fillDefaults().indent(0, 0).grab(true, true).applyTo((Control)main);
            commitGroup = new Group(main, 16);
            GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)commitGroup);
            commitGroup.setText(UIText.RebaseResultDialog_DetailsGroup);
            commitGroup.setLayout((Layout)new GridLayout(1, false));
            Label commitIdLabel = new Label((Composite)commitGroup, 0);
            commitIdLabel.setText(UIText.RebaseResultDialog_CommitIdLabel);
            Text commitId = new Text((Composite)commitGroup, 2056);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)commitId);
            Label commitMessageLabel = new Label((Composite)commitGroup, 0);
            commitMessageLabel.setText(UIText.RebaseResultDialog_CommitMessageLabel);
            TextViewer commitMessage = new TextViewer((Composite)commitGroup, 2826);
            GridDataFactory.fillDefaults().grab(true, true).hint(-1, 60).applyTo(commitMessage.getControl());
            conflictListFailure = false;
            DirCache dc = null;
            try {
                try {
                    Throwable throwable = null;
                    Object var11_14 = null;
                    try (RevWalk rw = new RevWalk(this.repo);){
                        RevCommit commit = rw.parseCommit((AnyObjectId)this.result.getCurrentCommit());
                        commitMessage.getTextWidget().setText(commit.getFullMessage());
                        commitId.setText(commit.name());
                        dc = this.repo.lockDirCache();
                        int i = 0;
                        while (i < dc.getEntryCount()) {
                            if (dc.getEntry(i).getStage() > 0) {
                                this.conflictPaths.add(dc.getEntry(i).getPathString());
                            }
                            ++i;
                        }
                        if (this.conflictPaths.size() > 0) {
                            this.message = NLS.bind((String)UIText.RebaseResultDialog_Conflicting, (Object)this.conflictPaths.size());
                            this.messageLabel.setText(this.message);
                        }
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                catch (IOException e) {
                    conflictListFailure = true;
                    if (dc != null) {
                        dc.unlock();
                    }
                    break block27;
                }
            }
            catch (Throwable throwable) {
                if (dc != null) {
                    dc.unlock();
                }
                throw throwable;
            }
            if (dc != null) {
                dc.unlock();
            }
        }
        boolean mergeToolAvailable = true;
        if (!conflictListFailure) {
            checkResult = FileChecker.checkFiles((Repository)this.repo, this.conflictPaths);
            mergeToolAvailable = checkResult.isOk();
        } else {
            checkResult = null;
            mergeToolAvailable = false;
        }
        if (conflictListFailure) {
            failureLabel = new Label(main, 0);
            failureLabel.setText(UIText.RebaseResultDialog_ConflictListFailureMessage);
        } else {
            if (checkResult != null && !checkResult.isOk()) {
                failureLabel = new Label(main, 0);
                failureLabel.setText(RebaseResultDialog.getProblemDescription(checkResult));
            }
            Label conflictListLabel = new Label(main, 0);
            conflictListLabel.setText(UIText.RebaseResultDialog_DiffDetailsLabel);
            TableViewer conflictList = new TableViewer(main, 2048);
            GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)conflictList.getTable());
            conflictList.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
            conflictList.setInput(this.conflictPaths);
            conflictList.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                public String getText(Object element) {
                    FileChecker.CheckResultEntry entry;
                    String path = (String)element;
                    if (checkResult != null && !checkResult.isOk() && (entry = checkResult.getEntry(path)) != null) {
                        if (!entry.inWorkspace) {
                            return UIText.RebaseResultDialog_notInWorkspace + RebaseResultDialog.SPACE + path;
                        }
                        if (!entry.shared) {
                            return UIText.RebaseResultDialog_notShared + RebaseResultDialog.SPACE + path;
                        }
                    }
                    return super.getText(element);
                }
            });
        }
        Group actionGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)actionGroup);
        actionGroup.setText(UIText.RebaseResultDialog_ActionGroupTitle);
        actionGroup.setLayout((Layout)new GridLayout(1, false));
        this.nextStepsGroup = new Group(main, 16);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.nextStepsGroup);
        this.nextStepsGroup.setText(UIText.RebaseResultDialog_NextSteps);
        this.nextStepsGroup.setLayout((Layout)new GridLayout(1, false));
        final TextViewer nextSteps = new TextViewer((Composite)this.nextStepsGroup, 2058);
        GridDataFactory.fillDefaults().grab(true, true).hint(-1, 60).applyTo(nextSteps.getControl());
        nextSteps.getTextWidget().setText(UIText.RebaseResultDialog_NextStepsAfterResolveConflicts);
        this.startMergeButton = new Button((Composite)actionGroup, 16);
        this.startMergeButton.setText(UIText.RebaseResultDialog_StartMergeRadioText);
        this.startMergeButton.setEnabled(mergeToolAvailable);
        this.startMergeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RebaseResultDialog.this.startMergeButton.getSelection()) {
                    nextSteps.getTextWidget().setText(UIText.RebaseResultDialog_NextStepsAfterResolveConflicts);
                    RebaseResultDialog.this.getButton(RebaseResultDialog.this.getDefaultButtonIndex()).setText(IDialogConstants.PROCEED_LABEL);
                }
            }
        });
        this.skipCommitButton = new Button((Composite)actionGroup, 16);
        this.skipCommitButton.setText(UIText.RebaseResultDialog_SkipCommitButton);
        this.skipCommitButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RebaseResultDialog.this.skipCommitButton.getSelection()) {
                    nextSteps.getTextWidget().setText("");
                    RebaseResultDialog.this.getButton(RebaseResultDialog.this.getDefaultButtonIndex()).setText(IDialogConstants.PROCEED_LABEL);
                }
            }
        });
        this.abortRebaseButton = new Button((Composite)actionGroup, 16);
        this.abortRebaseButton.setText(UIText.RebaseResultDialog_AbortRebaseRadioText);
        this.abortRebaseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RebaseResultDialog.this.abortRebaseButton.getSelection()) {
                    nextSteps.getTextWidget().setText("");
                    RebaseResultDialog.this.getButton(RebaseResultDialog.this.getDefaultButtonIndex()).setText(IDialogConstants.ABORT_LABEL);
                }
            }
        });
        this.doNothingButton = new Button((Composite)actionGroup, 16);
        this.doNothingButton.setText(UIText.RebaseResultDialog_DoNothingRadioText);
        this.doNothingButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RebaseResultDialog.this.doNothingButton.getSelection()) {
                    nextSteps.getTextWidget().setText(UIText.RebaseResultDialog_NextStepsDoNothing);
                    RebaseResultDialog.this.getButton(RebaseResultDialog.this.getDefaultButtonIndex()).setText(IDialogConstants.CLOSE_LABEL);
                }
            }
        });
        if (mergeToolAvailable) {
            this.startMergeButton.setSelection(true);
        } else {
            this.doNothingButton.setSelection(true);
        }
        commitGroup.pack();
        RebaseResultDialog.applyDialogFont((Control)main);
        return main;
    }

    private static String getProblemDescription(FileChecker.CheckResult checkResult) {
        StringBuilder result = new StringBuilder();
        if (checkResult.containsNonWorkspaceFiles()) {
            result.append(UIText.RebaseResultDialog_notInWorkspaceMessage);
        }
        if (checkResult.containsNotSharedResources()) {
            if (result.length() > 0) {
                result.append('\n');
            }
            result.append(UIText.RebaseResultDialog_notSharedMessage);
        }
        return result.toString();
    }

    protected void buttonPressed(int buttonId) {
        if (this.toggleButton != null) {
            Activator.getDefault().getPreferenceStore().setValue("show_rebase_confirm", !this.toggleButton.getSelection());
        }
        if (buttonId == 0) {
            if (this.result.getStatus() != RebaseResult.Status.STOPPED) {
                super.buttonPressed(buttonId);
                return;
            }
            if (this.startMergeButton.getSelection()) {
                GitMergeEditorInput input;
                super.buttonPressed(buttonId);
                IProject[] projects = ProjectUtil.getProjects((Repository)this.repo);
                try {
                    ResourcesPlugin.getWorkspace().run(pm -> ProjectUtil.refreshResources((IResource[])projects, (IProgressMonitor)pm), null, 1, null);
                }
                catch (CoreException e) {
                    Activator.logError(e.getMessage(), e);
                }
                ArrayList<IPath> locationList = new ArrayList<IPath>();
                Path repoWorkdirPath = new Path(this.repo.getWorkTree().getPath());
                for (String repoPath : this.conflictPaths) {
                    IPath location = repoWorkdirPath.append(repoPath);
                    locationList.add(location);
                }
                IPath[] locations = locationList.toArray(new IPath[0]);
                int mergeMode = Activator.getDefault().getPreferenceStore().getInt("merge_mode");
                if (mergeMode == 0) {
                    MergeModeDialog dlg = new MergeModeDialog(this.getParentShell());
                    if (dlg.open() != 0) {
                        return;
                    }
                    input = new GitMergeEditorInput(dlg.getMergeMode(), locations);
                } else {
                    MergeInputMode mode = MergeInputMode.fromInteger(mergeMode);
                    input = new GitMergeEditorInput(mode, locations);
                }
                CompareUI.openCompareEditor((CompareEditorInput)input);
                return;
            }
            if (this.skipCommitButton.getSelection()) {
                SkipRebaseCommand skipCommand = new SkipRebaseCommand();
                this.execute(skipCommand);
            } else if (this.abortRebaseButton.getSelection()) {
                AbortRebaseCommand abortCommand = new AbortRebaseCommand();
                this.execute(abortCommand);
            } else {
                this.doNothingButton.getSelection();
            }
        }
        super.buttonPressed(buttonId);
    }

    private void execute(AbstractRebaseCommandHandler command) {
        try {
            command.execute(this.repo);
        }
        catch (ExecutionException e) {
            Activator.showError(e.getMessage(), e);
        }
    }

    private void createToggleButton(Composite parent) {
        boolean toggleState = !Activator.getDefault().getPreferenceStore().getBoolean("show_rebase_confirm");
        this.toggleButton = new Button(parent, 16416);
        this.toggleButton.setText(UIText.RebaseResultDialog_ToggleShowButton);
        this.toggleButton.setSelection(toggleState);
    }
}

