/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.classpath;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathContentProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.classpath.ClasspathLabelProvider;
import org.eclipse.jdt.internal.debug.ui.classpath.IClasspathEntry;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.internal.debug.ui.launcher.IEntriesChangedListener;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.progress.WorkbenchJob;

public class RuntimeClasspathViewer
implements IClasspathViewer {
    private final ListenerList<IEntriesChangedListener> fListeners = new ListenerList();
    private IClasspathEntry fCurrentParent = null;
    private final IEclipsePreferences.IPreferenceChangeListener fPrefListeners = new IEclipsePreferences.IPreferenceChangeListener(){

        public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
            DebugUIPlugin.getStandardDisplay().asyncExec(() -> RuntimeClasspathViewer.this.refresh(true));
        }
    };
    private final RuntimeClasspathFilteredTree fTree;

    public TreeViewer getTreeViewer() {
        return this.fTree.getViewer();
    }

    public RuntimeClasspathViewer(Composite parent) {
        PatternFilter filter = new PatternFilter();
        filter.setIncludeLeadingWildcard(true);
        this.fTree = new RuntimeClasspathFilteredTree(parent, filter);
        this.getTreeViewer().getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (RuntimeClasspathViewer.this.updateSelection(2, (IStructuredSelection)RuntimeClasspathViewer.this.getSelection()) && event.character == '\u007f' && event.stateMask == 0) {
                    RuntimeClasspathViewer.this.getClasspathContentProvider().removeAll(((IStructuredSelection)RuntimeClasspathViewer.this.getSelectedEntries()).toList());
                    RuntimeClasspathViewer.this.notifyChanged();
                }
            }
        });
        this.fTree.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
                if (prefs != null) {
                    prefs.removePreferenceChangeListener(RuntimeClasspathViewer.this.fPrefListeners);
                }
            }
        });
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.eclipse.jdt.launching");
        if (prefs != null) {
            prefs.addPreferenceChangeListener(this.fPrefListeners);
        }
    }

    @Override
    public void setEntries(IRuntimeClasspathEntry[] entries) {
        this.getClasspathContentProvider().setRefreshEnabled(false);
        this.resolveCurrentParent(this.getSelection());
        this.getClasspathContentProvider().removeAll(this.fCurrentParent);
        this.getClasspathContentProvider().setEntries(entries);
        this.getClasspathContentProvider().setRefreshEnabled(true);
        this.notifyChanged();
    }

    @Override
    public IRuntimeClasspathEntry[] getEntries() {
        return this.getClasspathContentProvider().getModel().getAllEntries();
    }

    @Override
    public void addEntries(IRuntimeClasspathEntry[] entries) {
        this.getClasspathContentProvider().setRefreshEnabled(false);
        IStructuredSelection sel = (IStructuredSelection)this.getSelection();
        Object beforeElement = sel.getFirstElement();
        this.resolveCurrentParent(this.getSelection());
        List<IClasspathEntry> existingEntries = Arrays.asList(this.fCurrentParent.getEntries());
        int i = 0;
        while (i < entries.length) {
            if (!existingEntries.contains(entries[i])) {
                this.getClasspathContentProvider().add(this.fCurrentParent, entries[i], beforeElement);
            }
            ++i;
        }
        this.getClasspathContentProvider().setRefreshEnabled(true);
        this.notifyChanged();
    }

    private boolean resolveCurrentParent(ISelection selection) {
        this.fCurrentParent = null;
        for (Object element : (IStructuredSelection)selection) {
            if (element instanceof ClasspathEntry) {
                IClasspathEntry parent = ((IClasspathEntry)element).getParent();
                if (this.fCurrentParent != null) {
                    if (this.fCurrentParent.equals(parent)) continue;
                    return false;
                }
                this.fCurrentParent = parent;
                continue;
            }
            if (this.fCurrentParent != null) {
                if (this.fCurrentParent.equals(element)) continue;
                return false;
            }
            this.fCurrentParent = (IClasspathEntry)element;
        }
        return true;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    public void setLaunchConfiguration(ILaunchConfiguration configuration) {
        if (this.getTreeViewer().getLabelProvider() != null) {
            ((ClasspathLabelProvider)this.getTreeViewer().getLabelProvider()).setLaunchConfiguration(configuration);
        }
    }

    public void addEntriesChangedListener(IEntriesChangedListener listener) {
        this.fListeners.add((Object)listener);
    }

    public void removeEntriesChangedListener(IEntriesChangedListener listener) {
        this.fListeners.remove((Object)listener);
    }

    @Override
    public void notifyChanged() {
        for (IEntriesChangedListener listener : this.fListeners) {
            listener.entriesChanged(this);
        }
    }

    @Override
    public int indexOf(IRuntimeClasspathEntry entry) {
        IClasspathEntry existingEntry;
        IClasspathEntry[] entries = this.getClasspathContentProvider().getBootstrapClasspathEntries();
        int i = 0;
        while (i < entries.length) {
            existingEntry = entries[i];
            if (existingEntry.equals(entry)) {
                return 1;
            }
            ++i;
        }
        entries = this.getClasspathContentProvider().getUserClasspathEntries();
        i = 0;
        while (i < entries.length) {
            existingEntry = entries[i];
            if (existingEntry.equals(entry)) {
                return 1;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Shell getShell() {
        return this.getTreeViewer().getControl().getShell();
    }

    private ClasspathContentProvider getClasspathContentProvider() {
        return (ClasspathContentProvider)this.getTreeViewer().getContentProvider();
    }

    @Override
    public boolean updateSelection(int actionType, IStructuredSelection selection) {
        if (selection.isEmpty()) {
            return false;
        }
        switch (actionType) {
            case 1: {
                for (IClasspathEntry entry : selection) {
                    if (entry.isEditable() || !(entry instanceof ClasspathEntry)) continue;
                    return false;
                }
                return selection.size() > 0;
            }
            case 3: {
                if (this.fTree.hasFilterTextEntered()) {
                    return false;
                }
            }
            case 2: 
            case 4: {
                for (IClasspathEntry entry : selection) {
                    if (entry.isEditable()) continue;
                    return false;
                }
                return selection.size() > 0;
            }
        }
        return true;
    }

    public ISelection getSelectedEntries() {
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(selection.size() * 2);
        for (IClasspathEntry element : selection) {
            if (element.hasEntries()) {
                entries.addAll(Arrays.asList(element.getEntries()));
                continue;
            }
            entries.add(element);
        }
        return new StructuredSelection(entries);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.getTreeViewer().addSelectionChangedListener(listener);
    }

    public ISelection getSelection() {
        return this.getTreeViewer().getSelection();
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.getTreeViewer().removeSelectionChangedListener(listener);
    }

    public void setSelection(ISelection selection) {
        this.getTreeViewer().setSelection(selection);
    }

    @Override
    public void refresh(Object entry) {
        if (this.fTree.isDisposed()) {
            return;
        }
        this.getTreeViewer().refresh();
    }

    private static class RuntimeClasspathFilteredTree
    extends FilteredTree {
        private boolean isFiltering;

        private RuntimeClasspathFilteredTree(Composite parent, PatternFilter filter) {
            super(parent, 0, filter, true);
        }

        private boolean hasFilterTextEntered() {
            return this.isFiltering;
        }

        protected void textChanged() {
            super.textChanged();
            String filterString = this.getFilterString();
            this.isFiltering = filterString != null ? !filterString.trim().isEmpty() : false;
        }

        protected WorkbenchJob doCreateRefreshJob() {
            final WorkbenchJob job = super.doCreateRefreshJob();
            return new WorkbenchJob("Classpath filter refresh"){

                public IStatus runInUIThread(IProgressMonitor monitor) {
                    IStatus status = job.runInUIThread(monitor);
                    if (!isFiltering) {
                        this.getViewer().expandToLevel(2);
                    }
                    return status;
                }
            };
        }
    }
}

