/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.report.internal;

import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.ReportingFactory;
import org.eclipse.rcptt.reporting.util.Q7ReportIterator;
import org.eclipse.rcptt.reporting.util.ReportUtils;
import org.eclipse.rcptt.ui.controls.AbstractEmbeddedComposite;
import org.eclipse.rcptt.ui.launching.StatisticPanel;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StatisticsComposite
extends AbstractEmbeddedComposite {
    private Composite control;
    private StatisticPanel panel;
    private Q7Statistics statistics = ReportingFactory.eINSTANCE.createQ7Statistics();

    private void updateStatistics(Q7Statistics statistics) {
        this.statistics = statistics;
        this.refresh();
    }

    protected void fillActions(IToolBarManager manager) {
    }

    void setReports(Q7ReportIterator iterator) {
        Job.getJobManager().cancel((Object)this);
        if (iterator != null) {
            new UpdateJob(iterator).schedule();
        }
    }

    public String getName() {
        return "Execution statistics";
    }

    public Image getImage() {
        return Images.getImage((String)"icons/file.gif");
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.control = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.control);
        GridLayoutFactory.swtDefaults().numColumns(2).equalWidth(false).applyTo(this.control);
        this.panel = new StatisticPanel(this.control);
        this.refresh();
    }

    private synchronized void refresh() {
        if (this.panel == null) {
            return;
        }
        if (this.panel.isDisposed()) {
            return;
        }
        Q7Statistics tmp2 = this.statistics;
        if (tmp2 == null) {
            tmp2 = ReportingFactory.eINSTANCE.createQ7Statistics();
        }
        final Q7Statistics tmp = tmp2;
        this.panel.getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (StatisticsComposite.this.panel.isDisposed()) {
                    return;
                }
                StatisticsComposite.this.panel.update(tmp.getTotal(), tmp.getPassed() + tmp.getFailed() + tmp.getSkipped(), tmp.getFailed(), tmp.getSkipped(), (long)tmp.getTime());
            }
        });
    }

    public Control getControl() {
        return this.control;
    }

    class UpdateJob
    extends Job {
        private final Q7ReportIterator iterator;

        public boolean belongsTo(Object family) {
            return family == StatisticsComposite.this;
        }

        public UpdateJob(Q7ReportIterator iterator) {
            super("Calculating report statistics");
            this.iterator = iterator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            Q7Statistics statistics;
            try {
                Q7ReportIterator q7ReportIterator = this.iterator;
                synchronized (q7ReportIterator) {
                    statistics = ReportUtils.calculateStatistics((Iterator)this.iterator.iterator());
                }
            }
            catch (NullPointerException e) {
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                throw e;
            }
            StatisticsComposite.this.updateStatistics(statistics);
            return Status.OK_STATUS;
        }
    }
}

