/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.model.resolution;

import aQute.bnd.service.resource.SupportingResource;
import java.util.Map;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.pde.bnd.ui.model.resource.R5LabelFormatter;
import org.eclipse.swt.graphics.Image;
import org.osgi.resource.Capability;
import org.osgi.resource.Resource;

public class CapabilityLabelProvider
extends StyledCellLabelProvider {
    private final boolean shortenNamespaces;

    public CapabilityLabelProvider() {
        this(false);
    }

    public CapabilityLabelProvider(boolean shortenNamespaces) {
        this.shortenNamespaces = shortenNamespaces;
    }

    public void update(ViewerCell cell) {
        Capability cap = (Capability)cell.getElement();
        StyledString label = new StyledString();
        R5LabelFormatter.appendCapability(label, cap, this.shortenNamespaces);
        cell.setText(label.toString());
        cell.setStyleRanges(label.getStyleRanges());
        Image icon = Resources.getImage(R5LabelFormatter.getNamespaceImagePath(cap.getNamespace()));
        cell.setImage(icon);
    }

    public String getToolTipText(Object element) {
        if (element instanceof Capability) {
            Capability cap = (Capability)element;
            return CapabilityLabelProvider.tooltipText(cap);
        }
        return null;
    }

    static String tooltipText(Capability cap) {
        SupportingResource sr;
        int index;
        StringBuilder buf = new StringBuilder(400);
        Resource r = cap.getResource();
        buf.append("FROM: ").append(r).append("\n");
        buf.append(cap.getNamespace());
        if (r instanceof SupportingResource && (index = (sr = (SupportingResource)r).getSupportingIndex()) >= 0) {
            buf.append("Capability from a supporting resource ").append(index).append(" part of ").append(sr.getParent()).append("\n");
        }
        for (Map.Entry attribute : cap.getAttributes().entrySet()) {
            buf.append(";\n\t").append((String)attribute.getKey()).append(" = ").append(attribute.getValue());
        }
        for (Map.Entry directive : cap.getDirectives().entrySet()) {
            buf.append(";\n\t").append((String)directive.getKey()).append(" := ").append((String)directive.getValue());
        }
        return buf.toString();
    }
}

