/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.gmf;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.handles.AbstractHandle;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ITextAwareEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.ConnectionHandleEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.DiagramAssistantEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.editpolicies.PopupBarEditPolicy;
import org.eclipse.gmf.runtime.diagram.ui.handles.CompartmentCollapseHandle;
import org.eclipse.gmf.runtime.diagram.ui.internal.handles.CompartmentResizeHandle;
import org.eclipse.gmf.runtime.gef.ui.internal.tools.DelegatingDragEditPartsTracker;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetText;
import org.eclipse.rcptt.tesla.core.protocol.GetTextResponse;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolPackage;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.ui.Widget;
import org.eclipse.rcptt.tesla.gef.FigureUIElement;
import org.eclipse.rcptt.tesla.gef.GefProcessor;
import org.eclipse.rcptt.tesla.gef.IGefReplayHelper;
import org.eclipse.rcptt.tesla.gmf.GMFModelMapper;
import org.eclipse.rcptt.tesla.gmf.TeslaGMFAccess;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.tesla.internal.ui.processors.SWTUIProcessor;

public class GMFProcessor
implements ITeslaCommandProcessor,
IGefReplayHelper {
    private final EClass[] commandsSupported = new EClass[]{ProtocolPackage.Literals.GET_TEXT};
    private AbstractTeslaClient client;

    public int getPriority() {
        return 225;
    }

    public Response executeCommand(Command command, IElementProcessorMapper mapper) {
        EClass eClass = command.eClass();
        EPackage pkg = eClass.getEPackage();
        Response response = null;
        if (pkg.equals(ProtocolPackage.eINSTANCE)) {
            switch (eClass.getClassifierID()) {
                case 10: {
                    response = this.handleGetTextCommand((GetText)command);
                }
            }
        }
        return response;
    }

    private Response handleGetTextCommand(GetText command) {
        EditPart part;
        GetTextResponse response = ProtocolFactory.eINSTANCE.createGetTextResponse();
        GefProcessor processor = (GefProcessor)this.client.getProcessor(GefProcessor.class);
        Element element = command.getElement();
        FigureUIElement figureUIElement = (FigureUIElement)processor.getMapper().get(element);
        if (figureUIElement != null && (part = figureUIElement.getPart()) instanceof ITextAwareEditPart) {
            response.setText(((ITextAwareEditPart)part).getEditText());
            return response;
        }
        return null;
    }

    public String getFeatureID() {
        return "org.eclipse.rcptt.tesla.gmf";
    }

    public void initialize(AbstractTeslaClient client, String id) {
        this.client = client;
    }

    public boolean isCommandSupported(Command cmd) {
        EClass ecl = cmd.eClass();
        EClass[] eClassArray = this.commandsSupported;
        int n = this.commandsSupported.length;
        int n2 = 0;
        while (n2 < n) {
            EClass cl = eClassArray[n2];
            if (cl.equals(ecl)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isSelectorSupported(String kind) {
        return false;
    }

    public ITeslaCommandProcessor.PreExecuteStatus preExecute(Command command, ITeslaCommandProcessor.PreExecuteStatus previousStatus, Q7WaitInfoRoot info) {
        return null;
    }

    public SelectResponse select(SelectCommand cmd, ElementGenerator generator, IElementProcessorMapper mapper) {
        return null;
    }

    public void postSelect(Element element, IElementProcessorMapper mapper) {
        if (element.getKind().equals(ElementKind.DiagramViewer.name()) || element.getKind().equals(ElementKind.PaletteViewer.name())) {
            mapper.map(element, (ITeslaCommandProcessor)this);
        }
        GefProcessor processor = (GefProcessor)this.client.getProcessor(GefProcessor.class);
        if (element.getKind().equals(ElementKind.DiagramFigure.name())) {
            FigureUIElement figureUIElement = (FigureUIElement)processor.getMapper().get(element);
            if (figureUIElement != null && figureUIElement.getPart() instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart) {
                org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart gep = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)figureUIElement.getPart();
                Object descr = element.getDescription();
                boolean modify = false;
                if (descr == null) {
                    descr = "";
                }
                if (((String)descr).indexOf("GMF(") == -1) {
                    modify = true;
                    descr = (String)descr + "GMF(model" + String.valueOf(gep.resolveSemanticElement()) + ")";
                }
                if (modify) {
                    element.setDescription((String)descr);
                }
            }
            mapper.map(element, (ITeslaCommandProcessor)this);
        }
    }

    public boolean isInactivityRequired() {
        return true;
    }

    public boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        return true;
    }

    public void clean() {
    }

    public void terminate() {
        this.client = null;
    }

    public IFigure getFigure(List<Integer> path, GraphicalEditPart part) {
        int kind = path.get(0);
        Rectangle bounds = part.getFigure().getBounds();
        Point p = new Point(bounds.x, bounds.y);
        switch (kind) {
            case -2: {
                Job.getJobManager().wakeUp((Object)ConnectionHandleEditPolicy.class.getName());
                DiagramAssistantEditPolicy editPolicy = (DiagramAssistantEditPolicy)part.getEditPolicy((Object)"ConnectionHandlesPolicy");
                List handles = (List)this.getHandlesField(editPolicy);
                if (handles == null) {
                    TeslaGMFAccess.showDiagramAssistanceOn(p, editPolicy, ConnectionHandleEditPolicy.class);
                    handles = (List)this.getHandlesField(editPolicy);
                }
                editPolicy.mouseExited(null);
                return (IFigure)handles.get(path.get(1));
            }
            case -3: {
                Job.getJobManager().wakeUp((Object)PopupBarEditPolicy.class.getName());
                DiagramAssistantEditPolicy editPolicy = (DiagramAssistantEditPolicy)part.getEditPolicy((Object)"PopupBarEditPolicy");
                TeslaGMFAccess.showDiagramAssistanceOn(p, editPolicy, PopupBarEditPolicy.class);
                IFigure balloon = this.getBaloonField(editPolicy);
                List<Integer> list = path.subList(1, path.size());
                editPolicy.mouseExited(null);
                return this.getFigure(balloon, list);
            }
            case -6: {
                AbstractHandle[] handles;
                AbstractHandle[] abstractHandleArray = handles = this.findHandles(part);
                int n = handles.length;
                int n2 = 0;
                while (n2 < n) {
                    AbstractHandle abstractHandle = abstractHandleArray[n2];
                    EditPart partHandle = TeslaGMFAccess.getEditPart(abstractHandle);
                    if (part.equals(partHandle) && abstractHandle instanceof CompartmentResizeHandle) {
                        return abstractHandle;
                    }
                    ++n2;
                }
                break;
            }
            case -7: {
                AbstractHandle[] handles;
                AbstractHandle[] abstractHandleArray = handles = this.findHandles(part);
                int n = handles.length;
                int n3 = 0;
                while (n3 < n) {
                    AbstractHandle abstractHandle = abstractHandleArray[n3];
                    EditPart partHandle = TeslaGMFAccess.getEditPart(abstractHandle);
                    if (part.equals(partHandle) && abstractHandle instanceof CompartmentCollapseHandle) {
                        return abstractHandle;
                    }
                    ++n3;
                }
                break;
            }
        }
        return null;
    }

    private AbstractHandle[] findHandles(GraphicalEditPart part) {
        IFigure rootFigure = ((FigureCanvas)part.getViewer().getControl()).getContents();
        ArrayList<AbstractHandle> handles = new ArrayList<AbstractHandle>();
        List children = rootFigure.getChildren();
        this.findHandlesLoop(handles, children);
        return handles.toArray(new AbstractHandle[handles.size()]);
    }

    private void findHandlesLoop(List<AbstractHandle> handles, List children) {
        for (Object object : children) {
            if (object instanceof IFigure) {
                List children2 = ((IFigure)object).getChildren();
                this.findHandlesLoop(handles, children2);
            }
            if (!(object instanceof AbstractHandle)) continue;
            handles.add((AbstractHandle)object);
        }
    }

    private IFigure getBaloonField(DiagramAssistantEditPolicy editPolicy) {
        return TeslaGMFAccess.getBallonField(editPolicy);
    }

    private Object getHandlesField(DiagramAssistantEditPolicy editPolicy) {
        return TeslaGMFAccess.getHandlesField(editPolicy);
    }

    private IFigure getFigure(IFigure parent, List<Integer> path) {
        IFigure te = parent;
        for (Integer integer : path) {
            List children = te.getChildren();
            if (children.size() <= integer) {
                return null;
            }
            te = (IFigure)children.get(integer);
        }
        return te;
    }

    public Widget getModel(EditPart part) {
        return GMFModelMapper.map(part, ((SWTUIProcessor)this.client.getProcessor(SWTUIProcessor.class)).getPlayer());
    }

    public boolean isGMFMapped(EditPart part) {
        return GMFModelMapper.isGMFMapped(part);
    }

    public String getPropertyValue(EditPart part, String nodePath) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        return GMFModelMapper.getPropertyValue(part, nodePath);
    }

    public boolean callMasterProcess(ContextManagement.Context currentContext) {
        return false;
    }

    public void checkHang() {
    }

    public void collectInformation(AdvancedInformation information, Command lastCommand) {
    }

    public void updateDragParts(Set<EditPart> dragParts, DragTracker dragTracker) {
        Object part;
        if (dragTracker instanceof DelegatingDragEditPartsTracker && (part = TeslaGMFAccess.getDelegatingDragPart((DelegatingDragEditPartsTracker)dragTracker)) != null) {
            dragParts.add((EditPart)part);
        }
    }

    public EObject getEMFMode(EditPart part) {
        return GMFProcessor.getGMFEMFModel(part);
    }

    public static EObject getGMFEMFModel(EditPart part) {
        EObject eObject;
        EObject obj;
        org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart gpart;
        Object model;
        if (part instanceof org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart && (model = (gpart = (org.eclipse.gmf.runtime.diagram.ui.editparts.GraphicalEditPart)part).getModel()) instanceof EObject && (obj = (EObject)model) instanceof View && (eObject = ((View)obj).getElement()) != null) {
            return eObject;
        }
        return null;
    }

    public void notifyUI() {
    }
}

