/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.editor.FormLayoutFactory;
import org.eclipse.pde.internal.ui.editor.ILauncherFormPageHelper;
import org.eclipse.pde.internal.ui.editor.LaunchShortcutOverviewPage;
import org.eclipse.pde.internal.ui.editor.PDEFormEditor;
import org.eclipse.pde.internal.ui.editor.PDELauncherFormEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildInputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContext;
import org.eclipse.pde.internal.ui.editor.context.InputContextManager;
import org.eclipse.pde.internal.ui.editor.plugin.CreateManifestOperation;
import org.eclipse.pde.internal.ui.editor.plugin.ExecutionEnvironmentSection;
import org.eclipse.pde.internal.ui.editor.plugin.FragmentGeneralInfoSection;
import org.eclipse.pde.internal.ui.editor.plugin.GeneralInfoSection;
import org.eclipse.pde.internal.ui.editor.plugin.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.plugin.PluginExportAction;
import org.eclipse.pde.internal.ui.editor.plugin.PluginGeneralInfoSection;
import org.eclipse.pde.internal.ui.editor.plugin.PluginLauncherFormPageHelper;
import org.eclipse.pde.internal.ui.nls.GetNonExternalizedStringsAction;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.progress.UIJob;
import org.osgi.service.prefs.BackingStoreException;

public class OverviewPage
extends LaunchShortcutOverviewPage {
    public static final String P2_INSTALL_COMMAND_HANDLER = "org.eclipse.equinox.p2.ui.sdk.install";
    public static final String PAGE_ID = "overview";
    private PluginExportAction fExportAction;
    private GeneralInfoSection fInfoSection;
    private boolean fDisposed = false;
    private ILauncherFormPageHelper fLauncherHelper;

    public OverviewPage(PDELauncherFormEditor editor) {
        super(editor, PAGE_ID, PDEUIMessages.OverviewPage_tabName);
    }

    @Override
    protected String getHelpResource() {
        return "org.eclipse.pde.doc.user.manifest_plugin_overview";
    }

    @Override
    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        ScrolledForm form = managedForm.getForm();
        FormToolkit toolkit = managedForm.getToolkit();
        if (this.isFragment()) {
            form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FRAGMENT_MF_OBJ));
        } else {
            form.setImage(PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PLUGIN_MF_OBJ));
        }
        form.setText(PDEUIMessages.ManifestEditor_OverviewPage_title);
        this.fillBody(managedForm, toolkit);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)form.getBody(), "org.eclipse.pde.doc.user.manifest_plugin_overview");
        if (!this.isBundle() && this.isEditable()) {
            UIJob messageJob = UIJob.create((String)PDEUIMessages.OverviewPage_ManifestWarning, monitor -> {
                IManagedForm form1 = this.getManagedForm();
                if (form1 != null) {
                    form1.getMessageManager().addMessage((Object)PDEUIMessages.OverviewPage_ManifestWarning, this.isFragment() ? PDEUIMessages.OverviewPage_WarnAboutMissingManifestFragment : PDEUIMessages.OverviewPage_WarnAboutMissingManifest, null, 2);
                }
            });
            messageJob.setSystem(true);
            messageJob.schedule();
        }
    }

    private void fillBody(IManagedForm managedForm, FormToolkit toolkit) {
        Composite body = managedForm.getForm().getBody();
        body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(true, 2));
        Composite left = toolkit.createComposite(body);
        left.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        left.setLayoutData((Object)new TableWrapData(256));
        this.fInfoSection = this.isFragment() ? new FragmentGeneralInfoSection(this, left) : new PluginGeneralInfoSection(this, left);
        managedForm.addPart((IFormPart)this.fInfoSection);
        if (this.isBundle()) {
            managedForm.addPart((IFormPart)new ExecutionEnvironmentSection(this, left));
        }
        Composite right = toolkit.createComposite(body);
        right.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        right.setLayoutData((Object)new TableWrapData(256));
        this.createContentSection(managedForm, right, toolkit);
        if (this.isEditable() || this.getPDEEditor().hasInputContext("plugin-context")) {
            this.createExtensionSection(managedForm, right, toolkit);
        }
        if (this.isEditable()) {
            this.createTestingSection(managedForm, this.isBundle() ? right : left, toolkit);
        }
        if (this.isEditable()) {
            this.createExportingSection(managedForm, right, toolkit);
        }
    }

    private void createContentSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        String sectionTitle = this.isFragment() ? PDEUIMessages.ManifestEditor_ContentSection_ftitle : PDEUIMessages.ManifestEditor_ContentSection_title;
        Section section = this.createStaticSection(toolkit, parent, sectionTitle);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        if (!this.isBundle() && this.isEditable()) {
            String content = this.isFragment() ? PDEUIMessages.OverviewPage_NoPluginConverterFragment : PDEUIMessages.OverviewPage_NoPluginConverterPlugin;
            FormText warningText = this.createClient(container, content, toolkit);
            warningText.setImage("warning", lp.get(PDEPluginImages.DESC_WARNING_ST_OBJ, 0));
            warningText.setImage("error", lp.get(PDEPluginImages.DESC_ERROR_ST_OBJ, 0));
        }
        FormText text = this.createClient(container, this.isFragment() ? PDEUIMessages.OverviewPage_fContent : PDEUIMessages.OverviewPage_content, toolkit);
        text.setImage("page", lp.get(PDEPluginImages.DESC_PAGE_OBJ, 8));
        section.setClient((Control)container);
    }

    private void createExtensionSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        String sectionTitle = PDEUIMessages.ManifestEditor_ExtensionSection_title;
        Section section = this.createStaticSection(toolkit, parent, sectionTitle);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section);
        FormText text = this.createClient(container, this.isFragment() ? PDEUIMessages.OverviewPage_fExtensionContent : PDEUIMessages.OverviewPage_extensionContent, toolkit);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        text.setImage("page", lp.get(PDEPluginImages.DESC_PAGE_OBJ, 8));
        section.setClient((Control)container);
    }

    private void createTestingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, PDEUIMessages.ManifestEditor_TestingSection_title);
        PDELabelProvider lp = PDEPlugin.getDefault().getLabelProvider();
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section);
        String prefixText = !((ManifestEditor)this.getEditor()).showExtensionTabs() ? PDEUIMessages.OverviewPage_OSGiTesting : (this.isFragment() ? PDEUIMessages.OverviewPage_fTesting : PDEUIMessages.OverviewPage_testing);
        FormText text = this.createClient(container, this.getLauncherText(this.getLauncherHelper().isOSGi(), prefixText), toolkit);
        text.setImage("run", lp.get(PDEPluginImages.DESC_RUN_EXC));
        text.setImage("debug", lp.get(PDEPluginImages.DESC_DEBUG_EXC));
        text.setImage("profile", lp.get(PDEPluginImages.DESC_PROFILE_EXC));
        section.setClient((Control)container);
    }

    private void createExportingSection(IManagedForm managedForm, Composite parent, FormToolkit toolkit) {
        Section section = this.createStaticSection(toolkit, parent, PDEUIMessages.ManifestEditor_DeployingSection_title);
        Composite container = this.createStaticSectionClient(toolkit, (Composite)section);
        this.createClient(container, this.isFragment() ? PDEUIMessages.OverviewPage_fDeploying : PDEUIMessages.OverviewPage_deploying, toolkit);
        section.setClient((Control)container);
    }

    protected Composite createStaticSectionClient(FormToolkit toolkit, Composite parent) {
        Composite container = toolkit.createComposite(parent, 0);
        container.setLayout((Layout)FormLayoutFactory.createSectionClientTableWrapLayout(false, 1));
        TableWrapData data = new TableWrapData(256);
        container.setLayoutData((Object)data);
        return container;
    }

    private boolean isFragment() {
        InputContextManager contextManager = this.getPDEEditor().getContextManager();
        if (contextManager == null) {
            return false;
        }
        IBaseModel iBaseModel = contextManager.getAggregateModel();
        if (iBaseModel instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)iBaseModel;
            return model.isFragmentModel();
        }
        return false;
    }

    private boolean isBundle() {
        return this.getPDEEditor().getContextManager().findContext("bundle-context") != null;
    }

    private boolean isEditable() {
        InputContextManager contextManager = this.getPDEEditor().getContextManager();
        if (contextManager == null) {
            return false;
        }
        IBaseModel iBaseModel = contextManager.getAggregateModel();
        if (iBaseModel instanceof IPluginModelBase) {
            IPluginModelBase model = (IPluginModelBase)iBaseModel;
            return model.isEditable();
        }
        return false;
    }

    @Override
    public void linkActivated(HyperlinkEvent e) {
        String href;
        switch (href = (String)e.getHref()) {
            case "dependencies": {
                this.getEditor().setActivePage("dependencies");
                break;
            }
            case "runtime": {
                this.getEditor().setActivePage("runtime");
                break;
            }
            case "extensions": {
                if (this.getEditor().setActivePage("extensions") != null) break;
                this.activateExtensionPages("extensions");
                break;
            }
            case "ex-points": {
                if (this.getEditor().setActivePage("ex-points") != null) break;
                this.activateExtensionPages("ex-points");
                break;
            }
            case "build": {
                if (!this.getPDEEditor().hasInputContext("build-context")) {
                    if (!MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OverviewPage_buildTitle, (String)PDEUIMessages.OverviewPage_buildQuestion)) {
                        return;
                    }
                    IFile file = PDEProject.getBuildProperties((IProject)this.getPDEEditor().getCommonProject());
                    WorkspaceBuildModel model = new WorkspaceBuildModel(file);
                    model.save();
                    FileEditorInput in = new FileEditorInput(file);
                    this.getPDEEditor().getContextManager().putContext((IEditorInput)in, new BuildInputContext(this.getPDEEditor(), (IEditorInput)in, false));
                }
                this.getEditor().setActivePage("build");
                break;
            }
            case "export": {
                this.getExportAction().run();
                break;
            }
            case "action.convert": {
                this.handleConvert();
                break;
            }
            case "action.installPluginConverter": {
                this.handleInstallPluginConverter();
                break;
            }
            case "organize": {
                this.getEditor().doSave(null);
                OrganizeManifestsAction organizeAction = new OrganizeManifestsAction();
                organizeAction.runOrganizeManfestsAction((ISelection)new StructuredSelection((Object)this.getPDEEditor().getCommonProject()));
                break;
            }
            case "externalize": {
                this.getEditor().doSave(null);
                GetNonExternalizedStringsAction externalizeAction = new GetNonExternalizedStringsAction();
                externalizeAction.runGetNonExternalizedStringsAction((ISelection)new StructuredSelection((Object)this.getPDEEditor().getCommonProject()));
                break;
            }
            default: {
                super.linkActivated(e);
            }
        }
    }

    private PluginExportAction getExportAction() {
        if (this.fExportAction == null) {
            this.fExportAction = new PluginExportAction((PDEFormEditor)this.getEditor());
        }
        return this.fExportAction;
    }

    private void handleConvert() {
        block4: {
            try {
                this.fInfoSection.removeListeners();
                PDEFormEditor editor = this.getPDEEditor();
                IPluginModelBase model = (IPluginModelBase)editor.getAggregateModel();
                CreateManifestOperation op = new CreateManifestOperation(model);
                IProgressService service = PlatformUI.getWorkbench().getProgressService();
                editor.doSave(null);
                service.runInUI((IRunnableContext)service, (IRunnableWithProgress)op, (ISchedulingRule)PDEPlugin.getWorkspace().getRoot());
                this.updateBuildProperties();
                editor.doSave(null);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OverviewPage_error, (String)e.getCause().getMessage());
                if (!this.fDisposed) {
                    this.fInfoSection.addListeners();
                }
            }
            catch (InterruptedException e) {
                if (this.fDisposed) break block4;
                this.fInfoSection.addListeners();
            }
        }
    }

    private void handleInstallPluginConverter() {
        ICommandService commandService = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
        Command command = commandService.getCommand(P2_INSTALL_COMMAND_HANDLER);
        if (command.isHandled()) {
            IHandlerService handlerService = (IHandlerService)PlatformUI.getWorkbench().getService(IHandlerService.class);
            try {
                handlerService.executeCommand(P2_INSTALL_COMMAND_HANDLER, null);
            }
            catch (ExecutionException | NotEnabledException | NotHandledException | NotDefinedException ex) {
                this.handleCommandException();
            }
        }
    }

    private void handleCommandException() {
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.OverviewPage_ErrorOccurred, (String)PDEUIMessages.OverviewPage_InstallNewSoftwareCouldNotBeOpened);
    }

    private void updateBuildProperties() throws InvocationTargetException {
        try {
            InputContext context = this.getPDEEditor().getContextManager().findContext("build-context");
            if (context != null) {
                IBuildModel buildModel = (IBuildModel)context.getModel();
                IBuild build = buildModel.getBuild();
                IBuildEntry entry = build.getEntry("bin.includes");
                if (entry == null) {
                    entry = buildModel.getFactory().createEntry("bin.includes");
                    build.add(entry);
                }
                if (!entry.contains("META-INF")) {
                    entry.addToken("META-INF/");
                }
            }
        }
        catch (CoreException e) {
            throw new InvocationTargetException(e);
        }
    }

    private void activateExtensionPages(String activePageId) {
        MessageDialog mdiag = new MessageDialog(PDEPlugin.getActiveWorkbenchShell(), PDEUIMessages.OverviewPage_extensionPageMessageTitle, null, PDEUIMessages.OverviewPage_extensionPageMessageBody, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL}, 0);
        if (mdiag.open() != 0) {
            return;
        }
        try {
            ManifestEditor manifestEditor = (ManifestEditor)this.getEditor();
            manifestEditor.addExtensionTabs(3);
            manifestEditor.setShowExtensions(true);
            manifestEditor.setActivePage(activePageId);
        }
        catch (PartInitException | BackingStoreException throwable) {
            // empty catch block
        }
    }

    @Override
    public void dispose() {
        this.fDisposed = true;
        super.dispose();
    }

    @Override
    protected short getIndent() {
        return 5;
    }

    protected ILauncherFormPageHelper getLauncherHelper() {
        if (this.fLauncherHelper == null) {
            this.fLauncherHelper = new PluginLauncherFormPageHelper(this.getPDELauncherEditor());
        }
        return this.fLauncherHelper;
    }
}

