/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.internal.core.util.SerializableClasspathContainer;

public class PDEClasspathContainerSaveHelper {
    public static IClasspathContainer readContainer(InputStream input) throws IOException, ClassNotFoundException {
        ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(input)){
            {
                this.enableResolveObject(true);
            }

            @Override
            protected Object resolveObject(Object o) throws IOException {
                if (o instanceof ProjectEntryReplace) {
                    ProjectEntryReplace project = (ProjectEntryReplace)o;
                    return project.getEntry();
                }
                if (o instanceof LibraryEntryReplace) {
                    LibraryEntryReplace library = (LibraryEntryReplace)o;
                    return library.getEntry();
                }
                if (o instanceof ClasspathAttributeReplace) {
                    ClasspathAttributeReplace classpathAttribute = (ClasspathAttributeReplace)o;
                    return classpathAttribute.getAttribute();
                }
                if (o instanceof AccessRuleReplace) {
                    AccessRuleReplace accessRule = (AccessRuleReplace)o;
                    return accessRule.getAccessRule();
                }
                if (o instanceof PathReplace) {
                    PathReplace path = (PathReplace)o;
                    return path.getPath();
                }
                return super.resolveObject(o);
            }
        };
        return (IClasspathContainer)is.readObject();
    }

    public static IClasspathContainer emptyContainer() {
        return new SerializableClasspathContainer();
    }

    public static IClasspathContainer containerOf(IClasspathEntry[] entries) {
        return new SerializableClasspathContainer(entries);
    }

    public static void writeContainerEntries(IClasspathEntry[] entries, OutputStream output) throws IOException {
        ObjectOutputStream os = new ObjectOutputStream(new BufferedOutputStream(output)){
            {
                this.enableReplaceObject(true);
            }

            @Override
            protected Object replaceObject(Object o) throws IOException {
                if (o instanceof IClasspathEntry) {
                    IClasspathEntry e = (IClasspathEntry)o;
                    if (e.getEntryKind() == 2) {
                        return new ProjectEntryReplace(e);
                    }
                    if (e.getEntryKind() == 1) {
                        return new LibraryEntryReplace(e);
                    }
                } else {
                    if (o instanceof IClasspathAttribute) {
                        IClasspathAttribute classpthAttribute = (IClasspathAttribute)o;
                        return new ClasspathAttributeReplace(classpthAttribute);
                    }
                    if (o instanceof IAccessRule) {
                        IAccessRule accessRule = (IAccessRule)o;
                        return new AccessRuleReplace(accessRule);
                    }
                    if (o instanceof IPath) {
                        IPath path = (IPath)o;
                        return new PathReplace(path);
                    }
                }
                return super.replaceObject(o);
            }
        };
        os.writeObject(new SerializableClasspathContainer(entries));
        os.flush();
    }

    static final class AccessRuleReplace
    implements Serializable {
        private static final long serialVersionUID = 7315582893941374715L;
        private final IPath pattern;
        private final int kind;
        private final boolean ignoreIfBetter;

        AccessRuleReplace(IAccessRule accessRule) {
            this.pattern = accessRule.getPattern();
            this.kind = accessRule.getKind();
            this.ignoreIfBetter = accessRule.ignoreIfBetter();
        }

        IAccessRule getAccessRule() {
            if (this.ignoreIfBetter) {
                return JavaCore.newAccessRule((IPath)this.pattern, (int)(this.kind | 0x100));
            }
            return JavaCore.newAccessRule((IPath)this.pattern, (int)this.kind);
        }
    }

    static final class ClasspathAttributeReplace
    implements Serializable {
        private static final long serialVersionUID = 6370039352012628029L;
        private final String name;
        private final String value;

        ClasspathAttributeReplace(IClasspathAttribute attribute) {
            this.name = attribute.getName();
            this.value = attribute.getValue();
        }

        IClasspathAttribute getAttribute() {
            return JavaCore.newClasspathAttribute((String)this.name, (String)this.value);
        }
    }

    static final class LibraryEntryReplace
    implements Serializable {
        private static final long serialVersionUID = 3901667379326978799L;
        private final IPath path;
        private final IPath sourceAttachmentPath;
        private final IPath sourceAttachmentRootPath;
        private final IClasspathAttribute[] extraAttributes;
        private final boolean exported;
        private final IAccessRule[] accessRules;

        LibraryEntryReplace(IClasspathEntry entry) {
            this.path = entry.getPath();
            this.sourceAttachmentPath = entry.getSourceAttachmentPath();
            this.sourceAttachmentRootPath = entry.getSourceAttachmentRootPath();
            this.accessRules = entry.getAccessRules();
            this.extraAttributes = entry.getExtraAttributes();
            this.exported = entry.isExported();
        }

        IClasspathEntry getEntry() {
            return JavaCore.newLibraryEntry((IPath)this.path, (IPath)this.sourceAttachmentPath, (IPath)this.sourceAttachmentRootPath, (IAccessRule[])this.accessRules, (IClasspathAttribute[])this.extraAttributes, (boolean)this.exported);
        }
    }

    static final class PathReplace
    implements Serializable {
        private static final long serialVersionUID = -2361259525684491181L;
        private final String path;

        PathReplace(IPath path) {
            this.path = path.toPortableString();
        }

        IPath getPath() {
            return IPath.fromPortableString((String)this.path);
        }
    }

    static final class ProjectEntryReplace
    implements Serializable {
        private static final long serialVersionUID = -2397483865904288762L;
        private final IPath path;
        private final IClasspathAttribute[] extraAttributes;
        private final IAccessRule[] accessRules;
        private final boolean exported;
        private final boolean combineAccessRules;

        ProjectEntryReplace(IClasspathEntry entry) {
            this.path = entry.getPath();
            this.accessRules = entry.getAccessRules();
            this.extraAttributes = entry.getExtraAttributes();
            this.exported = entry.isExported();
            this.combineAccessRules = entry.combineAccessRules();
        }

        IClasspathEntry getEntry() {
            return JavaCore.newProjectEntry((IPath)this.path, (IAccessRule[])this.accessRules, (boolean)this.combineAccessRules, (IClasspathAttribute[])this.extraAttributes, (boolean)this.exported);
        }
    }
}

