/*******************************************************************************
 * Copyright (c) 2009, 2019 Xored Software Inc and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-v20.html
 *
 * Contributors:
 *     Xored Software Inc - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.rcptt.tesla.gef.describers;

import org.eclipse.swt.widgets.Widget;

import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.gef.FigureUIElement;
import org.eclipse.rcptt.tesla.gef.GefProcessor;
import org.eclipse.rcptt.tesla.gef.RawFigureUIElement;
import org.eclipse.rcptt.tesla.internal.core.AbstractTeslaClient;
import org.eclipse.rcptt.tesla.ui.describers.IDescriberExtension;
import org.eclipse.rcptt.tesla.ui.describers.IWidgetDescriber;

public class GefDescriberExtension implements IDescriberExtension {

	public GefDescriberExtension() {
	}

	public IWidgetDescriber getDescriber(Widget widget,
			IWidgetDescriber previous, int x, int y) {
		return null;
	}

	public IWidgetDescriber getDescriber(Element element,
			AbstractTeslaClient client) {
		GefProcessor processor = client.getProcessor(GefProcessor.class);
		FigureUIElement uiElement = processor.getMapper().get(element);
		if (uiElement != null) {
			return new EditPartDescriber(uiElement.getPart(),uiElement.getDiagram().getViewer());
		}
		// Try to use figure describer
		RawFigureUIElement rawFigureUIElement = processor.getRawMapper().get(
				element);
		if (rawFigureUIElement != null) {
			return new FigureDescriber(rawFigureUIElement.getFigure(),
					rawFigureUIElement.getPart(), rawFigureUIElement
							.getViewer());
		}
		return null;
	}
}
