/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.logging;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.FileHandler;
import org.eclipse.rcptt.logging.BaseFileQ7Monitor;
import org.eclipse.rcptt.logging.IQ7Monitor;
import org.eclipse.rcptt.logging.Q7LoggingManager;

public class ConfigurableFileQ7Monitor
extends BaseFileQ7Monitor
implements IQ7Monitor {
    private String id;
    private String prefix;
    private File file;
    private String fileID;
    private Set<IQ7Monitor> childs = new HashSet<IQ7Monitor>();

    public ConfigurableFileQ7Monitor(String id, String prefix, File file, String name) {
        this.fileID = Q7LoggingManager.getID(name);
        this.id = id;
        this.prefix = prefix;
        this.file = file;
        this.reinit();
    }

    @Override
    protected FileHandler getFileHandle() throws IOException {
        File logFile = new File(this.file, this.fileID);
        return new FileHandler(logFile.getAbsolutePath() + "_%g.log", this.getLogFileSize(), this.getLogFileCount(), true);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    protected String getFailMessage() {
        return "Failed to write to log:" + this.file.getAbsolutePath() + ":" + this.fileID;
    }

    @Override
    public void close() {
        super.close();
        for (IQ7Monitor child : this.childs) {
            child.close();
        }
        this.childs.clear();
        Q7LoggingManager.getManager().remove(this);
    }

    @Override
    public void putChild(IQ7Monitor result) {
        this.childs.add(result);
    }

    @Override
    public String getFile() {
        return new File(this.file, this.fileID).getAbsolutePath();
    }

    @Override
    public File getRootFolder() {
        return this.file;
    }
}

