/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.capability.ui.views;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.rcptt.core.scenario.CapabilityContext;
import org.eclipse.rcptt.core.scenario.CapabilityContextItem;
import org.eclipse.rcptt.ctx.capability.CapabilityManager;
import org.eclipse.rcptt.ctx.capability.ui.views.Messages;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;

public class CapabilityDialog
extends ListSelectionDialog {
    private static final LabelProvider LABEL_PROVIDER = new LabelProvider();
    private final CapabilityContextItem current;

    public CapabilityDialog(Shell shell, CapabilityContext context, CapabilityContextItem current) {
        super(shell, (Object)context, (IStructuredContentProvider)new ContentProvider(context, current), (ILabelProvider)LABEL_PROVIDER, Messages.CapabilityDialog_Message);
        this.current = current;
        this.setTitle(Messages.CapabilityDialog_Title);
    }

    public CapabilityDialog(Shell shell, CapabilityContext context) {
        this(shell, context, null);
    }

    protected List<?> getInitialElementSelections() {
        return this.current != null ? this.current.getCapability() : Collections.emptyList();
    }

    protected Control createDialogArea(Composite parent) {
        Control area = super.createDialogArea(parent);
        return area;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CapabilityDialog.this.updatesButtonState();
            }
        });
        this.updatesButtonState();
        return control;
    }

    public String[] getResult() {
        Object[] result = super.getResult();
        return (String[])Arrays.copyOf(result, result.length, String[].class);
    }

    private void updatesButtonState() {
        this.getButton(0).setEnabled(this.getViewer().getCheckedElements().length > 0);
    }

    private static class ContentProvider
    implements IStructuredContentProvider {
        private final CapabilityContextItem current;
        private final CapabilityContext context;

        public ContentProvider(CapabilityContext context, CapabilityContextItem item) {
            this.context = context;
            this.current = item;
        }

        public Object[] getElements(Object input) {
            return CapabilityManager.getManager().getAvaliableCapabiltiies(this.context, this.current);
        }
    }
}

